/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.WebConfig;
import com.ruslan.growsseth.http.DataSyncMemorySavedData;
import com.ruslan.growsseth.utils.GrowssethLogger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002`aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\r\u001a\u00020\u000b\"\b\b\u0000\u0010\u0004*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ=\u0010\r\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000f2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\r\u0010\u0011J/\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0004\b\u001b\u0010\u001cJM\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u001e\u0010\u001e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u001d2\u0006\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J!\u0010#\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u00192\u0006\u0010%\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b*\u0010\u0003J\u000f\u0010+\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b+\u0010\u0003J'\u0010-\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b-\u0010.J;\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00192\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0012\b\u0002\u0010/\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b0\u00101J\u0019\u00103\u001a\u0004\u0018\u0001022\u0006\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b3\u00104R$\u00106\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001a8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R(\u0010;\u001a\u0004\u0018\u00010:2\b\u00105\u001a\u0004\u0018\u00010:8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R(\u0010?\u001a\u0004\u0018\u00010:2\b\u00105\u001a\u0004\u0018\u00010:8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b?\u0010<\u001a\u0004\b@\u0010>R$\u0010B\u001a\u00020A2\u0006\u00105\u001a\u00020A8\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\bB\u0010C\"\u0004\bD\u0010ER8\u0010H\u001a&\u0012\u0004\u0012\u00020\u0005\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0G0F8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140F8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010IR\u001c\u0010L\u001a\n K*\u0004\u0018\u00010J0J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0014\u0010O\u001a\u00020N8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u0018\u0010R\u001a\u0004\u0018\u00010Q8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\"\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010IR&\u0010W\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0V0U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bW\u0010XR\u0014\u0010Z\u001a\u00020Y8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bZ\u0010[R\u0017\u0010\\\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_\u00a8\u0006b"}, d2={"Lcom/ruslan/growsseth/http/DataRemoteSync;", "", "<init>", "()V", "T", "", "endpoint", "Lkotlinx/serialization/DeserializationStrategy;", "serializer", "Lkotlin/Function2;", "Lnet/minecraft/server/MinecraftServer;", "", "callback", "subscribe", "(Ljava/lang/String;Lkotlinx/serialization/DeserializationStrategy;Lkotlin/jvm/functions/Function2;)V", "Ljava/lang/reflect/Type;", "type", "(Ljava/lang/String;Ljava/lang/reflect/Type;Lkotlin/jvm/functions/Function2;)V", "subscribeRaw", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "Lcom/ruslan/growsseth/http/DataRemoteSync$EndpointParams;", "endpointParams", "(Ljava/lang/String;)Lcom/ruslan/growsseth/http/DataRemoteSync$EndpointParams;", "url", "server", "Ljava/util/concurrent/CompletableFuture;", "", "doSync", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;)Ljava/util/concurrent/CompletableFuture;", "", "callbacks", "syncEndpoint", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lnet/minecraft/server/MinecraftServer;)Ljava/util/concurrent/CompletableFuture;", "params", "Ljava/net/HttpURLConnection;", "makeConnection", "(Ljava/lang/String;Lcom/ruslan/growsseth/http/DataRemoteSync$EndpointParams;)Ljava/net/HttpURLConnection;", "conn", "sendRequest", "(Ljava/net/HttpURLConnection;)Ljava/util/concurrent/CompletableFuture;", "getResponseContent", "(Ljava/net/HttpURLConnection;)Ljava/lang/String;", "setupExecutorService", "shutdownExecutorService", "response", "saveEndpointToMemory", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;Ljava/lang/String;)V", "existingFuture", "restoreEndpointFromMemory", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;Ljava/util/concurrent/CompletableFuture;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/class_3218;", "getOverworldOrNull", "(Lnet/minecraft/server/MinecraftServer;)Lnet/minecraft/class_3218;", "value", "lastSyncSuccessful", "Z", "getLastSyncSuccessful", "()Z", "Ljava/time/LocalDateTime;", "lastUpdateTime", "Ljava/time/LocalDateTime;", "getLastUpdateTime", "()Ljava/time/LocalDateTime;", "lastSuccessfulUpdateTime", "getLastSuccessfulUpdateTime", "Ljava/time/Duration;", "tickUpdateRealTimeDistance", "Ljava/time/Duration;", "setTickUpdateRealTimeDistance", "(Ljava/time/Duration;)V", "", "", "observersByEndpoint", "Ljava/util/Map;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Ljava/util/concurrent/ExecutorService;", "requestsService", "Ljava/util/concurrent/ExecutorService;", "didFirstLoad", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function1;", "doOnNextServerStart", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/ruslan/growsseth/utils/GrowssethLogger;", "logger", "Lcom/ruslan/growsseth/utils/GrowssethLogger;", "DEFAULT_PARAMS", "Lcom/ruslan/growsseth/http/DataRemoteSync$EndpointParams;", "getDEFAULT_PARAMS", "()Lcom/ruslan/growsseth/http/DataRemoteSync$EndpointParams;", "EndpointParams", "Callbacks", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nDataRemoteSync.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataRemoteSync.kt\ncom/ruslan/growsseth/http/DataRemoteSync\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n1#2:354\n216#3,2:355\n216#3,2:357\n1734#4,3:359\n1863#4,2:362\n1863#4,2:364\n1863#4,2:366\n*S KotlinDebug\n*F\n+ 1 DataRemoteSync.kt\ncom/ruslan/growsseth/http/DataRemoteSync\n*L\n108#1:355,2\n200#1:357,2\n112#1:359,3\n143#1:362,2\n174#1:364,2\n159#1:366,2\n*E\n"})
public final class DataRemoteSync {
    @NotNull
    public static final DataRemoteSync INSTANCE = new DataRemoteSync();
    private static boolean lastSyncSuccessful;
    @Nullable
    private static LocalDateTime lastUpdateTime;
    @Nullable
    private static LocalDateTime lastSuccessfulUpdateTime;
    @NotNull
    private static Duration tickUpdateRealTimeDistance;
    @NotNull
    private static final Map<String, List<Function2<String, MinecraftServer, Unit>>> observersByEndpoint;
    @NotNull
    private static final Map<String, EndpointParams> endpointParams;
    private static final Gson gson;
    @NotNull
    private static final Json json;
    @Nullable
    private static ExecutorService requestsService;
    @NotNull
    private static Map<String, Boolean> didFirstLoad;
    @NotNull
    private static final LinkedBlockingQueue<Function1<MinecraftServer, Unit>> doOnNextServerStart;
    @NotNull
    private static final GrowssethLogger logger;
    @NotNull
    private static final EndpointParams DEFAULT_PARAMS;

    private DataRemoteSync() {
    }

    public final boolean getLastSyncSuccessful() {
        return lastSyncSuccessful;
    }

    @Nullable
    public final LocalDateTime getLastUpdateTime() {
        return lastUpdateTime;
    }

    @Nullable
    public final LocalDateTime getLastSuccessfulUpdateTime() {
        return lastSuccessfulUpdateTime;
    }

    private final void setTickUpdateRealTimeDistance(Duration value) {
        if (value.compareTo(Duration.ofSeconds(10L)) > 0) {
            throw new IllegalArgumentException("Duration too short, must be at least 10s: " + value);
        }
        tickUpdateRealTimeDistance = value;
    }

    public final <T> void subscribe(@NotNull String endpoint, @NotNull DeserializationStrategy<? extends T> serializer2, @NotNull Function2<? super T, ? super MinecraftServer, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.subscribeRaw(endpoint, (Function2<? super String, ? super MinecraftServer, Unit>)((Function2)(arg_0, arg_1) -> DataRemoteSync.subscribe$lambda$1(callback, serializer2, endpoint, arg_0, arg_1)));
    }

    public final <T> void subscribe(@NotNull String endpoint, @NotNull Type type, @NotNull Function2<? super T, ? super MinecraftServer, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.subscribeRaw(endpoint, (Function2<? super String, ? super MinecraftServer, Unit>)((Function2)(arg_0, arg_1) -> DataRemoteSync.subscribe$lambda$2(callback, type, endpoint, arg_0, arg_1)));
    }

    public final void subscribeRaw(@NotNull String endpoint, @NotNull Function2<? super String, ? super MinecraftServer, Unit> callback) {
        String string;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (StringsKt.startsWith$default((String)endpoint, (String)"/", (boolean)false, (int)2, null)) {
            CharSequence charSequence = endpoint;
            Regex regex = new Regex("^/");
            String string2 = "";
            string = regex.replace(charSequence, string2);
        } else {
            string = endpoint;
        }
        String adjEndpoint = string;
        observersByEndpoint.computeIfAbsent(adjEndpoint, arg_0 -> DataRemoteSync.subscribeRaw$lambda$4(DataRemoteSync::subscribeRaw$lambda$3, arg_0)).add(callback);
    }

    @NotNull
    public final EndpointParams endpointParams(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        EndpointParams endpointParams = DataRemoteSync.endpointParams.computeIfAbsent(endpoint, arg_0 -> DataRemoteSync.endpointParams$lambda$6(DataRemoteSync::endpointParams$lambda$5, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)endpointParams, (String)"computeIfAbsent(...)");
        return endpointParams;
    }

    @NotNull
    public final CompletableFuture<Boolean> doSync(@NotNull String url, @NotNull MinecraftServer server) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!WebConfig.webDataSync) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        if (StringsKt.isBlank((CharSequence)url)) {
            RuinsOfGrowsseth.LOGGER.warn("Data sync url is empty, won't run", new Object[0]);
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        LocalDateTime it = localDateTime = LocalDateTime.now();
        boolean bl = false;
        lastUpdateTime = it;
        LocalDateTime updateTime = localDateTime;
        CompletableFuture future = new CompletableFuture();
        Map successes = new LinkedHashMap();
        Map<String, List<Function2<String, MinecraftServer, Unit>>> $this$forEach$iv = observersByEndpoint;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<Function2<String, MinecraftServer, Unit>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Function2<String, MinecraftServer, Unit>>> element$iv;
            Map.Entry<String, List<Function2<String, MinecraftServer, Unit>>> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String endpoint = entry.getKey();
            List<Function2<String, MinecraftServer, Unit>> callbacks = entry.getValue();
            INSTANCE.syncEndpoint(url, endpoint, callbacks, server).thenAccept(arg_0 -> DataRemoteSync.doSync$lambda$11$lambda$10(arg_0 -> DataRemoteSync.doSync$lambda$11$lambda$9(successes, endpoint, future, arg_0), arg_0));
        }
        CompletionStage completionStage = future.thenApply(arg_0 -> DataRemoteSync.doSync$lambda$13(arg_0 -> DataRemoteSync.doSync$lambda$12(updateTime, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final CompletableFuture<Boolean> syncEndpoint(String url, String endpoint, List<? extends Function2<? super String, ? super MinecraftServer, Unit>> callbacks, MinecraftServer server) {
        EndpointParams endpointParams = DataRemoteSync.endpointParams.get(endpoint);
        if (endpointParams == null) {
            endpointParams = DEFAULT_PARAMS;
        }
        EndpointParams params = endpointParams;
        String fullUrl = url + "/" + endpoint;
        HttpURLConnection conn = this.makeConnection(fullUrl, params);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.sendRequest(conn).whenComplete((arg_0, arg_1) -> DataRemoteSync.syncEndpoint$lambda$22((arg_0, arg_1) -> DataRemoteSync.syncEndpoint$lambda$21(endpoint, server, callbacks, future, arg_0, arg_1), arg_0, arg_1));
        return future;
    }

    private final HttpURLConnection makeConnection(String url, EndpointParams params) {
        URLConnection uRLConnection = new URI(url).toURL().openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        Map<String, String> $this$forEach$iv = params.getHeaders();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            conn.setRequestProperty(it.getKey(), it.getValue());
        }
        return conn;
    }

    static /* synthetic */ HttpURLConnection makeConnection$default(DataRemoteSync dataRemoteSync, String string, EndpointParams endpointParams, int n, Object object) {
        if ((n & 2) != 0) {
            endpointParams = DEFAULT_PARAMS;
        }
        return dataRemoteSync.makeConnection(string, endpointParams);
    }

    private final CompletableFuture<HttpURLConnection> sendRequest(HttpURLConnection conn) {
        CompletableFuture<HttpURLConnection> completableFuture = new CompletableFuture<HttpURLConnection>();
        Object object = requestsService;
        if (object == null || (object = object.submit(() -> DataRemoteSync.sendRequest$lambda$24(conn, completableFuture))) == null) {
            object = () -> DataRemoteSync.sendRequest$lambda$25(completableFuture);
        }
        return completableFuture;
    }

    private final String getResponseContent(HttpURLConnection conn) {
        BufferedReader respReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        String inputLine = null;
        StringBuffer contentBuffer = new StringBuffer();
        while (true) {
            String string;
            String it = string = respReader.readLine();
            boolean bl = false;
            inputLine = it;
            if (string == null) break;
            contentBuffer.append(inputLine);
        }
        respReader.close();
        String string = contentBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void setupExecutorService() {
        this.shutdownExecutorService();
        int threads = 1;
        requestsService = Executors.newFixedThreadPool(threads, new ThreadFactory(){
            private final AtomicInteger poolNum;
            private final AtomicInteger threadNum;
            private final String namePrefix;
            {
                this.poolNum = new AtomicInteger(1);
                this.threadNum = new AtomicInteger(1);
                this.namePrefix = "growsseth-" + this.poolNum.getAndIncrement() + "-thread-requests";
            }

            public Thread newThread(Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                return new Thread(null, r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    private final void shutdownExecutorService() {
        block0: {
            ExecutorService executorService = requestsService;
            if (executorService == null) break block0;
            executorService.shutdown();
        }
    }

    private final void saveEndpointToMemory(MinecraftServer server, String endpoint, String response) {
        class_3218 overworld = this.getOverworldOrNull(server);
        if (overworld != null) {
            DataSyncMemorySavedData savedData = DataSyncMemorySavedData.Companion.get(overworld);
            savedData.getLastEndpointOutputs().put(endpoint, response);
            savedData.method_80();
            logger.info("Updated data sync save data", new Object[0]);
        } else if (server.method_3806()) {
            doOnNextServerStart.offer((Function1<MinecraftServer, Unit>)((Function1)arg_0 -> DataRemoteSync.saveEndpointToMemory$lambda$27(server, endpoint, response, arg_0)));
        }
    }

    private final CompletableFuture<String> restoreEndpointFromMemory(MinecraftServer server, String endpoint, CompletableFuture<String> existingFuture) {
        CompletableFuture<String> future;
        CompletableFuture<String> completableFuture = existingFuture;
        if (completableFuture == null) {
            completableFuture = future = new CompletableFuture<String>();
        }
        if (!server.method_3806()) {
            future.completeExceptionally(new IllegalStateException("Restore endpoint abort: Server not running anymore"));
            return future;
        }
        class_3218 overworld = this.getOverworldOrNull(server);
        boolean bl = overworld != null ? future.complete(DataSyncMemorySavedData.Companion.get(overworld).getLastEndpointOutputs().get(endpoint)) : doOnNextServerStart.offer((Function1<MinecraftServer, Unit>)((Function1)arg_0 -> DataRemoteSync.restoreEndpointFromMemory$lambda$28(server, endpoint, future, arg_0)));
        return future;
    }

    static /* synthetic */ CompletableFuture restoreEndpointFromMemory$default(DataRemoteSync dataRemoteSync, MinecraftServer minecraftServer, String string, CompletableFuture completableFuture, int n, Object object) {
        if ((n & 4) != 0) {
            completableFuture = null;
        }
        return dataRemoteSync.restoreEndpointFromMemory(minecraftServer, string, completableFuture);
    }

    private final class_3218 getOverworldOrNull(MinecraftServer server) {
        class_3218 class_32182;
        try {
            class_32182 = server.method_30002();
        }
        catch (NullPointerException e) {
            class_32182 = null;
        }
        return class_32182;
    }

    @NotNull
    public final EndpointParams getDEFAULT_PARAMS() {
        return DEFAULT_PARAMS;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final Unit subscribe$lambda$1(Function2 $callback, DeserializationStrategy $serializer, String $endpoint, String response, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            $callback.invoke(json.decodeFromString($serializer, response), (Object)server);
        }
        catch (SerializationException e) {
            Object[] objectArray = new Object[]{e};
            logger.error("[" + $endpoint + "] JSON* PARSE FAILURE, IS " + response, objectArray);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e};
            logger.error("[" + $endpoint + "] OTHER FAILURE", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit subscribe$lambda$2(Function2 $callback, Type $type, String $endpoint, String response, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            $callback.invoke(gson.fromJson(response, $type), (Object)server);
        }
        catch (JsonParseException e) {
            Object[] objectArray = new Object[]{e};
            logger.error("[" + $endpoint + "] JSON PARSE FAILURE, IS " + response, objectArray);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e};
            logger.error("[" + $endpoint + "] OTHER FAILURE", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final List subscribeRaw$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List subscribeRaw$lambda$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final EndpointParams endpointParams$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new EndpointParams(null, 1, null);
    }

    private static final EndpointParams endpointParams$lambda$6(Function1 $tmp0, Object p0) {
        return (EndpointParams)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit doSync$lambda$11$lambda$9(Map $successes, String $endpoint, CompletableFuture $future, Boolean success) {
        $successes.put($endpoint, success);
        if ($successes.keySet().size() >= observersByEndpoint.keySet().size()) {
            boolean bl;
            CompletableFuture completableFuture;
            block4: {
                void $this$all$iv;
                Iterable iterable = $successes.values();
                completableFuture = $future;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl2 = false;
                        if (it) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            boolean bl3 = bl;
            completableFuture.complete(bl3);
        }
        return Unit.INSTANCE;
    }

    private static final void doSync$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Boolean doSync$lambda$12(LocalDateTime $updateTime, Boolean success) {
        lastSyncSuccessful = success;
        if (success.booleanValue()) {
            lastSuccessfulUpdateTime = $updateTime;
        }
        return success;
    }

    private static final Boolean doSync$lambda$13(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit syncEndpoint$lambda$21$lambda$15(String $endpoint, List $callbacks, MinecraftServer $server, String savedData) {
        if (savedData == null) {
            logger.warn("[" + $endpoint + "] No data for sync in server memory!", new Object[0]);
            return Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = $callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke((Object)savedData, (Object)$server);
        }
        didFirstLoad.put($endpoint, true);
        logger.info("[" + $endpoint + "] Restore successful", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final void syncEndpoint$lambda$21$lambda$16(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit syncEndpoint$lambda$21$lambda$19(String $endpoint, List $callbacks, MinecraftServer $server, String savedData) {
        if (savedData == null) {
            logger.warn("[" + $endpoint + "] No data for sync in server memory!", new Object[0]);
            return Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = $callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke((Object)savedData, (Object)$server);
        }
        didFirstLoad.put($endpoint, true);
        logger.info("[" + $endpoint + "] Restore successful", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final void syncEndpoint$lambda$21$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit syncEndpoint$lambda$21(String $endpoint, MinecraftServer $server, List $callbacks, CompletableFuture $future, HttpURLConnection conn2, Throwable exception) {
        try {
            boolean bl;
            if (exception != null) {
                if (!didFirstLoad.containsKey($endpoint)) {
                    logger.info("[" + $endpoint + "] Restoring from server memory after connection error as didn't load the first time yet", new Object[0]);
                    DataRemoteSync.restoreEndpointFromMemory$default(INSTANCE, $server, $endpoint, null, 4, null).thenAccept(arg_0 -> DataRemoteSync.syncEndpoint$lambda$21$lambda$16(arg_0 -> DataRemoteSync.syncEndpoint$lambda$21$lambda$15($endpoint, $callbacks, $server, arg_0), arg_0));
                }
                logger.error("[" + $endpoint + "] ERROR: " + exception.getMessage(), new Object[0]);
                bl = false;
            } else {
                int status = conn2.getResponseCode();
                if (status < 300 && $server.method_3806()) {
                    didFirstLoad.put($endpoint, true);
                    Intrinsics.checkNotNull((Object)conn2);
                    String content = INSTANCE.getResponseContent(conn2);
                    INSTANCE.saveEndpointToMemory($server, $endpoint, content);
                    logger.info("[" + $endpoint + "] SUCCESS, STATUS: " + status, new Object[0]);
                    Iterable $this$forEach$iv = $callbacks;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Function2 it = (Function2)element$iv;
                        boolean bl2 = false;
                        it.invoke((Object)content, (Object)$server);
                    }
                    bl = true;
                } else if (!$server.method_3806()) {
                    logger.error("Data sync " + $endpoint + ": server not running, abort...", new Object[0]);
                    bl = false;
                } else {
                    Intrinsics.checkNotNull((Object)conn2);
                    logger.error("[" + $endpoint + "] ERROR, STATUS " + status + "\n" + INSTANCE.getResponseContent(conn2), new Object[0]);
                    if (!didFirstLoad.containsKey($endpoint)) {
                        logger.info("[" + $endpoint + "] Restoring from server memory after error as didn't load the first time yet", new Object[0]);
                        DataRemoteSync.restoreEndpointFromMemory$default(INSTANCE, $server, $endpoint, null, 4, null).thenAccept(arg_0 -> DataRemoteSync.syncEndpoint$lambda$21$lambda$20(arg_0 -> DataRemoteSync.syncEndpoint$lambda$21$lambda$19($endpoint, $callbacks, $server, arg_0), arg_0));
                    }
                    bl = false;
                }
            }
            boolean result = bl;
            $future.complete(result);
        }
        catch (Exception e) {
            logger.error(ExceptionsKt.stackTraceToString((Throwable)e), new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final void syncEndpoint$lambda$22(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void sendRequest$lambda$24(HttpURLConnection $conn, CompletableFuture $completableFuture) {
        logger.info("DATA SYNC: CONNECTING VIA " + $conn.getURL(), new Object[0]);
        try {
            $conn.connect();
            $completableFuture.complete($conn);
            $conn.disconnect();
            logger.info("DATA SYNC: DISCONNECTED FROM " + $conn.getURL(), new Object[0]);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            logger.error("DATA SYNC: FAILURE WITH " + $conn.getURL(), objectArray);
            $completableFuture.completeExceptionally(e);
        }
    }

    private static final boolean sendRequest$lambda$25(CompletableFuture $completableFuture) {
        return $completableFuture.completeExceptionally(new IllegalStateException("Executor service not setup!"));
    }

    private static final Unit saveEndpointToMemory$lambda$27(MinecraftServer $server, String $endpoint, String $response, MinecraftServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.saveEndpointToMemory($server, $endpoint, $response);
        return Unit.INSTANCE;
    }

    private static final Unit restoreEndpointFromMemory$lambda$28(MinecraftServer $server, String $endpoint, CompletableFuture $future, MinecraftServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.restoreEndpointFromMemory($server, $endpoint, $future);
        return Unit.INSTANCE;
    }

    static {
        Duration duration = Duration.ofSeconds((long)(WebConfig.dataSyncReloadTime * (float)60));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        tickUpdateRealTimeDistance = duration;
        observersByEndpoint = new LinkedHashMap();
        endpointParams = new LinkedHashMap();
        gson = new GsonBuilder().create();
        json = JsonKt.Json$default(null, DataRemoteSync::json$lambda$0, (int)1, null);
        didFirstLoad = new LinkedHashMap();
        doOnNextServerStart = new LinkedBlockingQueue();
        logger = RuinsOfGrowsseth.LOGGER;
        DEFAULT_PARAMS = new EndpointParams(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u001d\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/ruslan/growsseth/http/DataRemoteSync$Callbacks;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "handleServerAboutToStartEvent", "(Lnet/minecraft/server/MinecraftServer;)V", "handleServerStoppingEvent", "Lnet/minecraft/class_3218;", "level", "onServerLevel", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3218;)V", "", "url", "onServerTick", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;)V", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nDataRemoteSync.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataRemoteSync.kt\ncom/ruslan/growsseth/http/DataRemoteSync$Callbacks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n1#2:354\n*E\n"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        public final void handleServerAboutToStartEvent(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            INSTANCE.setupExecutorService();
        }

        public final void handleServerStoppingEvent() {
            INSTANCE.shutdownExecutorService();
        }

        public final void onServerLevel(@NotNull MinecraftServer server, @NotNull class_3218 level) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (WebConfig.webDataSync && Intrinsics.areEqual((Object)level.method_27983(), (Object)class_1937.field_25179)) {
                while (!((Collection)doOnNextServerStart).isEmpty()) {
                    ((Function1)doOnNextServerStart.poll()).invoke((Object)server);
                }
            }
        }

        public final void onServerTick(@NotNull String url, @NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (WebConfig.webDataSync) {
                boolean bl;
                LocalDateTime time = LocalDateTime.now();
                LocalDateTime localDateTime = INSTANCE.getLastUpdateTime();
                if (localDateTime != null) {
                    LocalDateTime it = localDateTime;
                    boolean bl2 = false;
                    bl = Duration.between(it, time).compareTo(tickUpdateRealTimeDistance) >= 0;
                } else {
                    bl = false;
                }
                if (bl) {
                    logger.info("Data sync: started periodic sync", new Object[0]);
                    INSTANCE.doSync(url, server);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\t\u001a\u00020\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R#\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/ruslan/growsseth/http/DataRemoteSync$EndpointParams;", "", "", "", "headers", "<init>", "(Ljava/util/Map;)V", "component1", "()Ljava/util/Map;", "copy", "(Ljava/util/Map;)Lcom/ruslan/growsseth/http/DataRemoteSync$EndpointParams;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getHeaders", "ruins-of-growsseth"})
    public static final class EndpointParams {
        @NotNull
        private final Map<String, String> headers;

        public EndpointParams(@NotNull Map<String, String> headers) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            this.headers = headers;
        }

        public /* synthetic */ EndpointParams(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(map);
        }

        @NotNull
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final Map<String, String> component1() {
            return this.headers;
        }

        @NotNull
        public final EndpointParams copy(@NotNull Map<String, String> headers) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            return new EndpointParams(headers);
        }

        public static /* synthetic */ EndpointParams copy$default(EndpointParams endpointParams, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = endpointParams.headers;
            }
            return endpointParams.copy(map);
        }

        @NotNull
        public String toString() {
            return "EndpointParams(headers=" + this.headers + ")";
        }

        public int hashCode() {
            return ((Object)this.headers).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EndpointParams)) {
                return false;
            }
            EndpointParams endpointParams = (EndpointParams)other;
            return Intrinsics.areEqual(this.headers, endpointParams.headers);
        }

        public EndpointParams() {
            this(null, 1, null);
        }
    }
}

