/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.mixin.debug;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.config.DebugConfig;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2385;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_2897;
import net.minecraft.class_5321;
import net.minecraft.class_5485;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class StructureDebugMixins {

    @Mixin(value={class_7869.class})
    public static class ChunkGeneratorStructureStateMixin {
        @Inject(method={"hasBiomesForStructureSet"}, at={@At(value="HEAD")}, cancellable=true)
        private static void hasBiomesForStructureSet(class_7059 structureSet, class_1966 biomeSource, CallbackInfoReturnable<Boolean> cir) {
            if (DebugConfig.structuresDebugMode) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Mixin(value={class_2897.class})
    public static abstract class FlatLevelSourceMixin
    extends class_2794 {
        protected FlatLevelSourceMixin(class_1966 biomeSource) {
            super(biomeSource);
        }

        protected FlatLevelSourceMixin(class_1966 biomeSource, Function<class_6880<class_1959>, class_5485> generationSettingsGetter) {
            super(biomeSource, generationSettingsGetter);
        }

        @Inject(method={"createState(Lnet/minecraft/core/HolderLookup;Lnet/minecraft/world/level/levelgen/RandomState;J)Lnet/minecraft/world/level/chunk/ChunkGeneratorStructureState;"}, at={@At(value="HEAD")}, cancellable=true)
        private void overrideStructuresInDebug(class_7225<class_7059> structureSetLookup, class_7138 randomState, long seed, CallbackInfoReturnable<class_7869> cir) {
            if (DebugConfig.structuresDebugMode) {
                RuinsOfGrowsseth.LOGGER.info("(debug mode) Replaced flat worldgen structure selection", new Object[0]);
                cir.setReturnValue((Object)super.method_46696(structureSetLookup, randomState, seed));
            }
        }
    }

    @Mixin(value={class_7655.class})
    public static class RegistryDataLoaderMixin {
        @WrapOperation(method={"loadElementFromResource"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")})
        private static <E> DataResult<E> loadRegistryContents(Decoder<E> instance, DynamicOps<class_2520> ops, Object jsonElement, Operation<DataResult<E>> original, @Local(argsOnly=true) class_2385<E> registry) {
            return RegistryDataLoaderMixin.growsseth$registryWrapper(instance, ops, jsonElement, original, registry);
        }

        @WrapOperation(method={"loadContentsFromNetwork"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")})
        private static <E> DataResult<E> loadRegistryContentsFromNetwork(Decoder<E> instance, DynamicOps<class_2520> ops, Object jsonElement, Operation<DataResult<E>> original, @Local(argsOnly=true) class_2385<E> registry) {
            return RegistryDataLoaderMixin.growsseth$registryWrapper(instance, ops, jsonElement, original, registry);
        }

        @Unique
        private static <E> DataResult<E> growsseth$registryWrapper(Decoder<E> instance, DynamicOps<class_2520> ops, Object jsonElement, Operation<DataResult<E>> original, class_2385<E> registry) {
            DataResult<E> result = (DataResult<E>)original.call(new Object[]{instance, ops, jsonElement});
            class_5321 key = registry.method_30517();
            if (DebugConfig.structuresDebugMode && key.equals(class_7924.field_41248) && jsonElement.toString().contains("growsseth")) {
                result = RegistryDataLoaderMixin.growsseth$alterStructureSetWeight(key, result);
            }
            return result;
        }

        @Unique
        private static <E> DataResult<E> growsseth$alterStructureSetWeight(class_5321<?> key, DataResult<?> dataResult) {
            RuinsOfGrowsseth.LOGGER.info("(debug mode) Network | Increasing spawn frequency for {}", key);
            Optional structureSetOpt = RegistryDataLoaderMixin.growsseth$assertCast(dataResult.getOrThrow(), Optional.class);
            class_7059 structureSet = RegistryDataLoaderMixin.growsseth$assertCast(structureSetOpt.orElseThrow(), class_7059.class);
            class_6874 placement = structureSet.comp_511();
            placement.field_37778 = 1.0f;
            if (placement instanceof class_6872) {
                class_6872 randomSpread = (class_6872)placement;
                randomSpread.field_37772 /= 4;
                randomSpread.field_37773 /= 4;
            }
            return DataResult.success(Optional.of(structureSet));
        }

        @Unique
        private static <E> E growsseth$assertCast(Object value, Class<E> clazz) {
            if (!value.getClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Expected " + String.valueOf(value) + " to be an instance of " + clazz.getCanonicalName());
            }
            return (E)value;
        }
    }

    @Mixin(value={class_2794.class})
    public static class ChunkGeneratorMixin {
        @ModifyVariable(method={"tryGenerateStructure"}, at=@At(value="STORE"))
        private Predicate<class_6880<class_1959>> onSetBiomePredicate(Predicate<class_6880<class_1959>> value, @Local(argsOnly=true) class_7059.class_7060 structureSelectionEntry) {
            if (!DebugConfig.structuresDebugMode || !structureSelectionEntry.comp_512().method_40230().map(k -> k.method_29177().method_12836().equals("growsseth")).orElse(false).booleanValue()) {
                return value;
            }
            return h -> true;
        }
    }
}

