/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.quests;

import com.filloax.fxlib.api.UtilsKt;
import com.filloax.fxlib.api.codec.CodecUtilsKt;
import com.filloax.fxlib.api.nbt.NbtUtilsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.quests.QuestComponent;
import com.ruslan.growsseth.quests.QuestStage;
import com.ruslan.growsseth.quests.QuestUpdateEvent;
import com.ruslan.growsseth.utils.GrowssethLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 ]*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0004]^_`B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJW\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001f\u001a\u00020\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J7\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\t\u001a\u00020\u00052\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00102\b\b\u0002\u0010$\u001a\u00020\u0010\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\u0010\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010)\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010-\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b/\u0010.J\u0015\u00100\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020+\u00a2\u0006\u0004\b0\u0010.J\u0015\u00101\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020+\u00a2\u0006\u0004\b1\u0010.J\u000f\u00102\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b2\u00103R\u0017\u0010\u0004\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00104\u001a\u0004\b5\u00106R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00107\u001a\u0004\b8\u00103R \u0010:\u001a\b\u0012\u0004\u0012\u00020\u0005098\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\"\u0010>\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000D8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010FR&\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000D0G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0017\u0010M\u001a\u00020L8\u0006\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR\u0011\u0010T\u001a\u00020Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR$\u0010W\u001a\u00020U2\u0006\u0010V\u001a\u00020U8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010ZR\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00028\u00000\u00158F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u0019\u00a8\u0006a"}, d2={"Lcom/ruslan/growsseth/quests/QuestComponent;", "Lnet/minecraft/class_1309;", "E", "", "entity", "", "name", "<init>", "(Lnet/minecraft/class_1309;Ljava/lang/String;)V", "id", "Lcom/ruslan/growsseth/quests/QuestStage;", "stage", "", "previousStage", "", "priority", "", "blockSiblingStages", "blockNextStages", "addStage", "(Ljava/lang/String;Lcom/ruslan/growsseth/quests/QuestStage;[Ljava/lang/String;IZZ)Z", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestNode;", "getStageNode", "(Ljava/lang/String;)Lcom/ruslan/growsseth/quests/QuestComponent$QuestNode;", "current", "()Lcom/ruslan/growsseth/quests/QuestComponent$QuestNode;", "", "aiStep", "()V", "Lcom/ruslan/growsseth/quests/QuestUpdateEvent;", "event", "update", "(Lcom/ruslan/growsseth/quests/QuestUpdateEvent;)V", "node", "activateStageId", "(Ljava/lang/String;Lcom/ruslan/growsseth/quests/QuestComponent$QuestNode;Lcom/ruslan/growsseth/quests/QuestUpdateEvent;)Lcom/ruslan/growsseth/quests/QuestComponent$QuestNode;", "activate", "backOneStage", "(Z)Z", "started", "()Z", "passedStage", "(Ljava/lang/String;)Z", "Lnet/minecraft/class_2487;", "tag", "writeCustomNbt", "(Lnet/minecraft/class_2487;)V", "readCustomNbt", "writeNbt", "readNbt", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_1309;", "getEntity", "()Lnet/minecraft/class_1309;", "Ljava/lang/String;", "getName", "", "availableStages", "Ljava/util/List;", "getAvailableStages", "()Ljava/util/List;", "updatePeriod", "I", "getUpdatePeriod", "()I", "setUpdatePeriod", "(I)V", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestNodeImpl;", "stagesGraph", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestNodeImpl;", "", "stagesMap", "Ljava/util/Map;", "triggeredFirst", "Z", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "Lnet/minecraft/class_3218;", "getServerLevel", "()Lnet/minecraft/class_3218;", "serverLevel", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "value", "data", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "getData", "()Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "getCurrentNode", "currentNode", "Companion", "QuestData", "QuestNode", "QuestNodeImpl", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestComponent.kt\ncom/ruslan/growsseth/quests/QuestComponent\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 NbtUtils.kt\ncom/filloax/fxlib/api/nbt/NbtUtilsKt\n*L\n1#1,252:1\n11165#2:253\n11500#2,3:254\n1863#3,2:257\n1#4:259\n42#5,8:260\n*S KotlinDebug\n*F\n+ 1 QuestComponent.kt\ncom/ruslan/growsseth/quests/QuestComponent\n*L\n92#1:253\n92#1:254,3\n99#1:257,2\n188#1:260,8\n*E\n"})
public class QuestComponent<E extends class_1309> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final E entity;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> availableStages;
    private int updatePeriod;
    @NotNull
    private final QuestNodeImpl<E> stagesGraph;
    @NotNull
    private final Map<String, QuestNodeImpl<E>> stagesMap;
    private boolean triggeredFirst;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private QuestData data;
    @NotNull
    private static final Codec<QuestData> PERSIST_CODEC;
    @NotNull
    public static final String INIT_STAGE_ID = "init";
    @NotNull
    public static final String QUESTS_TAG_ID = "Quests";
    @NotNull
    public static final String NBT_TAG_PERSIST = "status";

    public QuestComponent(@NotNull E entity, @NotNull String name) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.entity = entity;
        this.name = name;
        this.availableStages = CollectionsKt.listOf((Object)INIT_STAGE_ID);
        this.updatePeriod = UtilsKt.secondsToTicks((float)1.0f);
        this.stagesGraph = new QuestNodeImpl(QuestStage.Companion.blank(), INIT_STAGE_ID, null, null, 0, false, false, 124, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)INIT_STAGE_ID, this.stagesGraph)};
        this.stagesMap = MapsKt.mutableMapOf((Pair[])pairArray);
        MinecraftServer minecraftServer = ((class_1297)this.entity).method_5682();
        if (minecraftServer == null) {
            throw new IllegalStateException("Initialized QuestComponent in client for entity " + this.entity + "!");
        }
        this.server = minecraftServer;
        this.data = new QuestData(null, null, false, 0L, 0L, 31, null);
    }

    @NotNull
    public final E getEntity() {
        return this.entity;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAvailableStages() {
        return this.availableStages;
    }

    public final int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public final void setUpdatePeriod(int n) {
        this.updatePeriod = n;
    }

    @NotNull
    public final MinecraftServer getServer() {
        return this.server;
    }

    @NotNull
    public final class_3218 getServerLevel() {
        class_1937 class_19372 = ((class_1297)this.entity).method_37908();
        Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        return (class_3218)class_19372;
    }

    @NotNull
    public final QuestData getData() {
        return this.data;
    }

    @NotNull
    public final QuestNode<E> getCurrentNode() {
        return this.current();
    }

    /*
     * WARNING - void declaration
     */
    public boolean addStage(@NotNull String id, @NotNull QuestStage<E> stage, @NotNull String[] previousStage, int priority, boolean blockSiblingStages, boolean blockNextStages) {
        List list;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(stage, (String)"stage");
        Intrinsics.checkNotNullParameter((Object)previousStage, (String)"previousStage");
        if (this.stagesMap.containsKey(id)) {
            RuinsOfGrowsseth.LOGGER.error("Added duplicate quest stage " + id, new Object[0]);
            return false;
        }
        QuestNodeImpl node = new QuestNodeImpl(stage, id, null, null, priority, blockSiblingStages, blockNextStages, 12, null);
        if (!(previousStage.length == 0)) {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = previousStage;
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var17_17 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                QuestNodeImpl<E> questNodeImpl = this.stagesMap.get(it);
                if (questNodeImpl == null) {
                    throw new IllegalArgumentException("Parent node " + (String)it + " not added yet / not existing");
                }
                collection.add(questNodeImpl);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf(this.stagesGraph);
        }
        List startPoints = list;
        UtilsKt.addAllByPriority(node.getStartPoints(), (Collection)startPoints, (Function1)((Function1)addStage.1.INSTANCE));
        this.stagesMap.put(id, node);
        Iterable $this$forEach$iv = startPoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QuestNodeImpl it = (QuestNodeImpl)element$iv;
            boolean bl = false;
            UtilsKt.addByPriority(it.getLeadsTo(), node, (Function1)((Function1)addStage.2.1.INSTANCE));
        }
        return true;
    }

    public static /* synthetic */ boolean addStage$default(QuestComponent questComponent, String string, QuestStage questStage, String[] stringArray, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addStage");
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        return questComponent.addStage(string, questStage, stringArray, n, bl, bl2);
    }

    @Nullable
    public final QuestNode<E> getStageNode(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.stagesMap.get(id);
    }

    private final QuestNode<E> current() {
        Map<String, QuestNodeImpl<E>> map = this.stagesMap;
        QuestNodeImpl<E> questNodeImpl = map.get(this.data.getCurrentStageId());
        if (questNodeImpl == null) {
            boolean bl = false;
            RuinsOfGrowsseth.LOGGER.error("Unknown stage " + this.data.getCurrentStageId(), new Object[0]);
            this.data.setCurrentStageId(INIT_STAGE_ID);
            questNodeImpl = this.stagesGraph;
        }
        return questNodeImpl;
    }

    public final void aiStep() {
        if (!this.data.getActive()) {
            return;
        }
        if (((class_1309)this.entity).field_6012 % this.updatePeriod == 0 || !this.triggeredFirst) {
            this.triggeredFirst = true;
            QuestComponent.update$default(this, null, 1, null);
        }
        QuestNode<E> current = this.current();
        current.getStage().onStep(this.entity);
    }

    public void update(@NotNull QuestUpdateEvent event) {
        QuestNode<E> startCurrent;
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        if (!this.data.getActive()) {
            return;
        }
        QuestNode<E> current = this.current();
        do {
            startCurrent = current;
            for (QuestNode<E> node : startCurrent.getLeadsTo()) {
                QuestStage<E> stage = node.getStage();
                if (!stage.getTrigger().isActive(this.entity, event)) continue;
                current = this.activateStageId(node.getId(), node, event);
                if (!node.getBlockSiblings() && !((class_1297)this.entity).method_31481()) continue;
            }
        } while (!Intrinsics.areEqual(startCurrent, current) && !current.getBlockNext() && !((class_1297)this.entity).method_31481());
        current.getStage().onUpdate(this.entity);
    }

    public static /* synthetic */ void update$default(QuestComponent questComponent, QuestUpdateEvent questUpdateEvent, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            questUpdateEvent = QuestUpdateEvent.TICK;
        }
        questComponent.update(questUpdateEvent);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QuestNode<E> activateStageId(@NotNull String id, @NotNull QuestNode<E> node, @Nullable QuestUpdateEvent event) {
        Object object;
        String string;
        GrowssethLogger growssethLogger;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter(node, (String)"node");
                this.data.setCurrentStageId(id);
                ((Collection)this.data.getStageHistory()).add(id);
                this.data.setCurrentStageTriggerTime(this.server.method_30002().method_8510());
                growssethLogger = RuinsOfGrowsseth.LOGGER;
                string = node.getId();
                object = event;
                if (object == null) break block2;
                QuestUpdateEvent questUpdateEvent = object;
                String string2 = string;
                GrowssethLogger growssethLogger2 = growssethLogger;
                boolean bl = false;
                String string3 = " [" + (QuestUpdateEvent)it + "]";
                growssethLogger = growssethLogger2;
                string = string2;
                String string4 = string3;
                object = string4;
                if (string4 != null) break block3;
            }
            object = "";
        }
        growssethLogger.info("Triggered stage " + string + (String)object + "\n\t" + this, new Object[0]);
        node.getStage().onActivated(this.entity);
        return node;
    }

    public static /* synthetic */ QuestNode activateStageId$default(QuestComponent questComponent, String string, QuestNode questNode, QuestUpdateEvent questUpdateEvent, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: activateStageId");
        }
        if ((n & 2) != 0) {
            QuestNodeImpl questNodeImpl = questComponent.stagesMap.get(string);
            if (questNodeImpl == null) {
                throw new IllegalArgumentException("No node specified and no node with id " + string);
            }
            questNode = questNodeImpl;
        }
        if ((n & 4) != 0) {
            questUpdateEvent = null;
        }
        return questComponent.activateStageId(string, questNode, questUpdateEvent);
    }

    public final boolean backOneStage(boolean activate) {
        if (this.data.getStageHistory().size() <= 1) {
            return false;
        }
        this.data.getStageHistory().removeLast();
        this.data.setCurrentStageId((String)CollectionsKt.last(this.data.getStageHistory()));
        this.data.setCurrentStageTriggerTime(this.server.method_30002().method_8510());
        this.data.setCurrentStageTriggerDayTime(this.server.method_30002().method_8532());
        RuinsOfGrowsseth.LOGGER.info("Reverted to quest stage " + this.data.getCurrentStageId() + "\n\t" + this, new Object[0]);
        if (activate) {
            QuestNode<E> questNode = this.getStageNode(this.data.getCurrentStageId());
            if (questNode != null && (questNode = questNode.getStage()) != null) {
                questNode.onActivated(this.entity);
            } else {
                throw new IllegalStateException("No node for previous stage " + this.data.getCurrentStageId());
            }
        }
        return true;
    }

    public static /* synthetic */ boolean backOneStage$default(QuestComponent questComponent, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: backOneStage");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return questComponent.backOneStage(bl);
    }

    public final boolean started() {
        return !Intrinsics.areEqual((Object)this.data.getCurrentStageId(), (Object)INIT_STAGE_ID);
    }

    public final boolean passedStage(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.data.getStageHistory().contains(id);
    }

    public void writeCustomNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    public void readCustomNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    /*
     * WARNING - void declaration
     */
    public final void writeNbt(@NotNull class_2487 tag) {
        void qTag;
        class_2487 key$iv;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        class_2487 class_24872 = tag;
        String string = QUESTS_TAG_ID;
        class_2520 default$iv = (class_2520)new class_2487();
        boolean $i$f$getOrPut = false;
        class_2520 value$iv = $this$getOrPut$iv.method_10580((String)key$iv);
        if (value$iv == null) {
            class_2520 class_25202 = default$iv.method_10707();
            if (class_25202 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            }
            value$iv = (class_2520)((class_2487)class_25202);
            $this$getOrPut$iv.method_10566((String)key$iv, value$iv);
        } else if (!(value$iv instanceof class_2487)) {
            throw new ClassCastException("Existing tag is of wrong type! " + value$iv.getClass());
        }
        class_2487 questsTag = (class_2487)value$iv;
        key$iv = class_24872 = new class_2487();
        String string2 = this.name;
        class_2487 class_24873 = questsTag;
        boolean bl = false;
        qTag.method_10566(NBT_TAG_PERSIST, (class_2520)CodecUtilsKt.encodeNbt(PERSIST_CODEC, (Object)this.data).getOrThrow(arg_0 -> QuestComponent.writeNbt$lambda$5$lambda$4(CodecUtilsKt.throwableCodecErr((String)"QuestComponent write"), arg_0)));
        this.writeCustomNbt((class_2487)qTag);
        Unit unit = Unit.INSTANCE;
        class_24873.method_10566(string2, (class_2520)class_24872);
    }

    public final void readNbt(@NotNull class_2487 tag) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.data = new QuestData(null, null, false, 0L, 0L, 31, null);
            class_2487 class_24872 = NbtUtilsKt.getCompoundOrNull((class_2487)tag, (String)QUESTS_TAG_ID);
            if (class_24872 == null) break block2;
            class_2487 questsTag = class_24872;
            boolean bl = false;
            class_2487 class_24873 = NbtUtilsKt.getCompoundOrNull((class_2487)questsTag, (String)this.name);
            if (class_24873 != null) {
                class_2487 qTag = class_24873;
                boolean bl2 = false;
                class_2487 class_24874 = qTag.method_10562(NBT_TAG_PERSIST);
                Intrinsics.checkNotNullExpressionValue((Object)class_24874, (String)"getCompound(...)");
                Optional result = CodecUtilsKt.decodeNbt(PERSIST_CODEC, (class_2520)((class_2520)class_24874)).result();
                result.ifPresent(arg_0 -> QuestComponent.readNbt$lambda$9$lambda$8$lambda$7(arg_0 -> QuestComponent.readNbt$lambda$9$lambda$8$lambda$6(this, qTag, arg_0), arg_0));
                if (result.isEmpty()) {
                    RuinsOfGrowsseth.LOGGER.error("Couldn't parse quest data: " + qTag, new Object[0]);
                }
            }
        }
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.data.getStageHistory(), (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final Exception writeNbt$lambda$5$lambda$4(Function1 $tmp0, String p0) {
        return (Exception)$tmp0.invoke((Object)p0);
    }

    private static final Unit readNbt$lambda$9$lambda$8$lambda$6(QuestComponent this$0, class_2487 $qTag, com.mojang.datafixers.util.Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.data = (QuestData)it.getFirst();
        this$0.readCustomNbt($qTag);
        return Unit.INSTANCE;
    }

    private static final void readNbt$lambda$9$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final String PERSIST_CODEC$lambda$15$lambda$10(KMutableProperty1 $tmp0, QuestData p0) {
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List PERSIST_CODEC$lambda$15$lambda$11(KMutableProperty1 $tmp0, QuestData p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean PERSIST_CODEC$lambda$15$lambda$12(KMutableProperty1 $tmp0, QuestData p0) {
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Long PERSIST_CODEC$lambda$15$lambda$13(KMutableProperty1 $tmp0, QuestData p0) {
        return (Long)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Long PERSIST_CODEC$lambda$15$lambda$14(KMutableProperty1 $tmp0, QuestData p0) {
        return (Long)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App PERSIST_CODEC$lambda$15(RecordCodecBuilder.Instance builder) {
        App app = (App)Codec.STRING.fieldOf("currentStageId").forGetter(arg_0 -> QuestComponent.PERSIST_CODEC$lambda$15$lambda$10((KMutableProperty1)Companion.PERSIST_CODEC.1.1.INSTANCE, arg_0));
        PrimitiveCodec primitiveCodec = Codec.STRING;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec, (String)"STRING");
        return builder.group(app, (App)CodecUtilsKt.mutableListCodec((Codec)((Codec)primitiveCodec)).fieldOf("stageHistory").forGetter(arg_0 -> QuestComponent.PERSIST_CODEC$lambda$15$lambda$11((KMutableProperty1)Companion.PERSIST_CODEC.1.2.INSTANCE, arg_0)), (App)Codec.BOOL.fieldOf("active").forGetter(arg_0 -> QuestComponent.PERSIST_CODEC$lambda$15$lambda$12((KMutableProperty1)Companion.PERSIST_CODEC.1.3.INSTANCE, arg_0)), (App)Codec.LONG.optionalFieldOf("currentStageTriggerTime", (Object)-1L).forGetter(arg_0 -> QuestComponent.PERSIST_CODEC$lambda$15$lambda$13((KMutableProperty1)Companion.PERSIST_CODEC.1.4.INSTANCE, arg_0)), (App)Codec.LONG.optionalFieldOf("currentStageTriggerDayTime", (Object)-1L).forGetter(arg_0 -> QuestComponent.PERSIST_CODEC$lambda$15$lambda$14((KMutableProperty1)Companion.PERSIST_CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)builder, QuestData::new);
    }

    static {
        Codec codec = RecordCodecBuilder.create(QuestComponent::PERSIST_CODEC$lambda$15);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        PERSIST_CODEC = codec;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/ruslan/growsseth/quests/QuestComponent$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "PERSIST_CODEC", "Lcom/mojang/serialization/Codec;", "getPERSIST_CODEC", "()Lcom/mojang/serialization/Codec;", "", "INIT_STAGE_ID", "Ljava/lang/String;", "QUESTS_TAG_ID", "NBT_TAG_PERSIST", "ruins-of-growsseth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<QuestData> getPERSIST_CODEC() {
            return PERSIST_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0016\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0014JH\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u0019\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u000eR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\"R(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\u0010\"\u0004\b%\u0010&R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010'\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010*R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010+\u001a\u0004\b,\u0010\u0014\"\u0004\b-\u0010.R\"\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010+\u001a\u0004\b/\u0010\u0014\"\u0004\b0\u0010.\u00a8\u00061"}, d2={"Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "", "", "currentStageId", "", "stageHistory", "", "active", "", "currentStageTriggerTime", "currentStageTriggerDayTime", "<init>", "(Ljava/lang/String;Ljava/util/List;ZJJ)V", "component1", "()Ljava/lang/String;", "component2", "()Ljava/util/List;", "component3", "()Z", "component4", "()J", "component5", "copy", "(Ljava/lang/String;Ljava/util/List;ZJJ)Lcom/ruslan/growsseth/quests/QuestComponent$QuestData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getCurrentStageId", "setCurrentStageId", "(Ljava/lang/String;)V", "Ljava/util/List;", "getStageHistory", "setStageHistory", "(Ljava/util/List;)V", "Z", "getActive", "setActive", "(Z)V", "J", "getCurrentStageTriggerTime", "setCurrentStageTriggerTime", "(J)V", "getCurrentStageTriggerDayTime", "setCurrentStageTriggerDayTime", "ruins-of-growsseth"})
    public static final class QuestData {
        @NotNull
        private String currentStageId;
        @NotNull
        private List<String> stageHistory;
        private boolean active;
        private long currentStageTriggerTime;
        private long currentStageTriggerDayTime;

        public QuestData(@NotNull String currentStageId, @NotNull List<String> stageHistory, boolean active, long currentStageTriggerTime, long currentStageTriggerDayTime) {
            Intrinsics.checkNotNullParameter((Object)currentStageId, (String)"currentStageId");
            Intrinsics.checkNotNullParameter(stageHistory, (String)"stageHistory");
            this.currentStageId = currentStageId;
            this.stageHistory = stageHistory;
            this.active = active;
            this.currentStageTriggerTime = currentStageTriggerTime;
            this.currentStageTriggerDayTime = currentStageTriggerDayTime;
        }

        public /* synthetic */ QuestData(String string, List list, boolean bl, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = QuestComponent.INIT_STAGE_ID;
            }
            if ((n & 2) != 0) {
                Object[] objectArray = new String[]{QuestComponent.INIT_STAGE_ID};
                list = CollectionsKt.mutableListOf((Object[])objectArray);
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                l = -1L;
            }
            if ((n & 0x10) != 0) {
                l2 = -1L;
            }
            this(string, list, bl, l, l2);
        }

        @NotNull
        public final String getCurrentStageId() {
            return this.currentStageId;
        }

        public final void setCurrentStageId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.currentStageId = string;
        }

        @NotNull
        public final List<String> getStageHistory() {
            return this.stageHistory;
        }

        public final void setStageHistory(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.stageHistory = list;
        }

        public final boolean getActive() {
            return this.active;
        }

        public final void setActive(boolean bl) {
            this.active = bl;
        }

        public final long getCurrentStageTriggerTime() {
            return this.currentStageTriggerTime;
        }

        public final void setCurrentStageTriggerTime(long l) {
            this.currentStageTriggerTime = l;
        }

        public final long getCurrentStageTriggerDayTime() {
            return this.currentStageTriggerDayTime;
        }

        public final void setCurrentStageTriggerDayTime(long l) {
            this.currentStageTriggerDayTime = l;
        }

        @NotNull
        public final String component1() {
            return this.currentStageId;
        }

        @NotNull
        public final List<String> component2() {
            return this.stageHistory;
        }

        public final boolean component3() {
            return this.active;
        }

        public final long component4() {
            return this.currentStageTriggerTime;
        }

        public final long component5() {
            return this.currentStageTriggerDayTime;
        }

        @NotNull
        public final QuestData copy(@NotNull String currentStageId, @NotNull List<String> stageHistory, boolean active, long currentStageTriggerTime, long currentStageTriggerDayTime) {
            Intrinsics.checkNotNullParameter((Object)currentStageId, (String)"currentStageId");
            Intrinsics.checkNotNullParameter(stageHistory, (String)"stageHistory");
            return new QuestData(currentStageId, stageHistory, active, currentStageTriggerTime, currentStageTriggerDayTime);
        }

        public static /* synthetic */ QuestData copy$default(QuestData questData, String string, List list, boolean bl, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = questData.currentStageId;
            }
            if ((n & 2) != 0) {
                list = questData.stageHistory;
            }
            if ((n & 4) != 0) {
                bl = questData.active;
            }
            if ((n & 8) != 0) {
                l = questData.currentStageTriggerTime;
            }
            if ((n & 0x10) != 0) {
                l2 = questData.currentStageTriggerDayTime;
            }
            return questData.copy(string, list, bl, l, l2);
        }

        @NotNull
        public String toString() {
            return "QuestData(currentStageId=" + this.currentStageId + ", stageHistory=" + this.stageHistory + ", active=" + this.active + ", currentStageTriggerTime=" + this.currentStageTriggerTime + ", currentStageTriggerDayTime=" + this.currentStageTriggerDayTime + ")";
        }

        public int hashCode() {
            int result = this.currentStageId.hashCode();
            result = result * 31 + ((Object)this.stageHistory).hashCode();
            result = result * 31 + Boolean.hashCode(this.active);
            result = result * 31 + Long.hashCode(this.currentStageTriggerTime);
            result = result * 31 + Long.hashCode(this.currentStageTriggerDayTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuestData)) {
                return false;
            }
            QuestData questData = (QuestData)other;
            if (!Intrinsics.areEqual((Object)this.currentStageId, (Object)questData.currentStageId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.stageHistory, questData.stageHistory)) {
                return false;
            }
            if (this.active != questData.active) {
                return false;
            }
            if (this.currentStageTriggerTime != questData.currentStageTriggerTime) {
                return false;
            }
            return this.currentStageTriggerDayTime == questData.currentStageTriggerDayTime;
        }

        public QuestData() {
            this(null, null, false, 0L, 0L, 31, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\bf\u0018\u0000*\b\b\u0001\u0010\u0002*\u00020\u00012\u00020\u0003R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u00048&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\f8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\f8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u00168&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00168&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/ruslan/growsseth/quests/QuestComponent$QuestNode;", "Lnet/minecraft/class_1309;", "E", "", "Lcom/ruslan/growsseth/quests/QuestStage;", "getStage", "()Lcom/ruslan/growsseth/quests/QuestStage;", "stage", "", "getId", "()Ljava/lang/String;", "id", "", "getStartPoints", "()Ljava/util/List;", "startPoints", "getLeadsTo", "leadsTo", "", "getPriority", "()I", "priority", "", "getBlockSiblings", "()Z", "blockSiblings", "getBlockNext", "blockNext", "ruins-of-growsseth"})
    public static interface QuestNode<E extends class_1309> {
        @NotNull
        public QuestStage<E> getStage();

        @NotNull
        public String getId();

        @NotNull
        public List<QuestNode<E>> getStartPoints();

        @NotNull
        public List<QuestNode<E>> getLeadsTo();

        public int getPriority();

        public boolean getBlockSiblings();

        public boolean getBlockNext();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\u0011\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00010\u0003Bg\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\b\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001dJz\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\b2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rH\u00c6\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u001a\u0010#\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010!H\u00d6\u0003\u00a2\u0006\u0004\b#\u0010$J\u0010\u0010%\u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b%\u0010\u001bR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010(\u001a\u0004\b)\u0010\u0013R&\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010*\u001a\u0004\b+\u0010\u0018R&\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010*\u001a\u0004\b,\u0010\u0018R\u001a\u0010\f\u001a\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010-\u001a\u0004\b.\u0010\u001bR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010/\u001a\u0004\b0\u0010\u001dR\u001a\u0010\u000f\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010/\u001a\u0004\b1\u0010\u001d\u00a8\u00062"}, d2={"Lcom/ruslan/growsseth/quests/QuestComponent$QuestNodeImpl;", "Lnet/minecraft/class_1309;", "E", "Lcom/ruslan/growsseth/quests/QuestComponent$QuestNode;", "Lcom/ruslan/growsseth/quests/QuestStage;", "stage", "", "id", "", "startPoints", "leadsTo", "", "priority", "", "blockSiblings", "blockNext", "<init>", "(Lcom/ruslan/growsseth/quests/QuestStage;Ljava/lang/String;Ljava/util/List;Ljava/util/List;IZZ)V", "toString", "()Ljava/lang/String;", "component1", "()Lcom/ruslan/growsseth/quests/QuestStage;", "component2", "component3", "()Ljava/util/List;", "component4", "component5", "()I", "component6", "()Z", "component7", "copy", "(Lcom/ruslan/growsseth/quests/QuestStage;Ljava/lang/String;Ljava/util/List;Ljava/util/List;IZZ)Lcom/ruslan/growsseth/quests/QuestComponent$QuestNodeImpl;", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "Lcom/ruslan/growsseth/quests/QuestStage;", "getStage", "Ljava/lang/String;", "getId", "Ljava/util/List;", "getStartPoints", "getLeadsTo", "I", "getPriority", "Z", "getBlockSiblings", "getBlockNext", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nQuestComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestComponent.kt\ncom/ruslan/growsseth/quests/QuestComponent$QuestNodeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1557#2:253\n1628#2,3:254\n*S KotlinDebug\n*F\n+ 1 QuestComponent.kt\ncom/ruslan/growsseth/quests/QuestComponent$QuestNodeImpl\n*L\n232#1:253\n232#1:254,3\n*E\n"})
    public static final class QuestNodeImpl<E extends class_1309>
    implements QuestNode<E> {
        @NotNull
        private final QuestStage<E> stage;
        @NotNull
        private final String id;
        @NotNull
        private final List<QuestNode<E>> startPoints;
        @NotNull
        private final List<QuestNode<E>> leadsTo;
        private final int priority;
        private final boolean blockSiblings;
        private final boolean blockNext;

        public QuestNodeImpl(@NotNull QuestStage<E> stage, @NotNull String id, @NotNull List<QuestNode<E>> startPoints, @NotNull List<QuestNode<E>> leadsTo, int priority, boolean blockSiblings, boolean blockNext) {
            Intrinsics.checkNotNullParameter(stage, (String)"stage");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(startPoints, (String)"startPoints");
            Intrinsics.checkNotNullParameter(leadsTo, (String)"leadsTo");
            this.stage = stage;
            this.id = id;
            this.startPoints = startPoints;
            this.leadsTo = leadsTo;
            this.priority = priority;
            this.blockSiblings = blockSiblings;
            this.blockNext = blockNext;
        }

        public /* synthetic */ QuestNodeImpl(QuestStage questStage, String string, List list, List list2, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                list = new ArrayList();
            }
            if ((n2 & 8) != 0) {
                list2 = new ArrayList();
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                bl2 = false;
            }
            this(questStage, string, list, list2, n, bl, bl2);
        }

        @Override
        @NotNull
        public QuestStage<E> getStage() {
            return this.stage;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public List<QuestNode<E>> getStartPoints() {
            return this.startPoints;
        }

        @Override
        @NotNull
        public List<QuestNode<E>> getLeadsTo() {
            return this.leadsTo;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public boolean getBlockSiblings() {
            return this.blockSiblings;
        }

        @Override
        public boolean getBlockNext() {
            return this.blockNext;
        }

        @NotNull
        public String toString() {
            Collection<String> collection;
            QuestNode it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object extra = "";
            if (this.getBlockSiblings()) {
                extra = (String)extra + ", block";
            }
            if (this.getBlockNext()) {
                extra = (String)extra + ", blockNext";
            }
            Iterable iterable = this.getStartPoints();
            String string = this.getId();
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                QuestNode questNode = (QuestNode)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getId());
            }
            $this$map$iv = this.getLeadsTo();
            collection2 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (QuestNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            collection = (List)destination$iv$iv;
            return "QuestNodeImpl[" + string + "]<from: " + (List)collection2 + "; to: " + (List)collection + ", " + this.getPriority() + (String)extra + ">";
        }

        @NotNull
        public final QuestStage<E> component1() {
            return this.stage;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final List<QuestNode<E>> component3() {
            return this.startPoints;
        }

        @NotNull
        public final List<QuestNode<E>> component4() {
            return this.leadsTo;
        }

        public final int component5() {
            return this.priority;
        }

        public final boolean component6() {
            return this.blockSiblings;
        }

        public final boolean component7() {
            return this.blockNext;
        }

        @NotNull
        public final QuestNodeImpl<E> copy(@NotNull QuestStage<E> stage, @NotNull String id, @NotNull List<QuestNode<E>> startPoints, @NotNull List<QuestNode<E>> leadsTo, int priority, boolean blockSiblings, boolean blockNext) {
            Intrinsics.checkNotNullParameter(stage, (String)"stage");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(startPoints, (String)"startPoints");
            Intrinsics.checkNotNullParameter(leadsTo, (String)"leadsTo");
            return new QuestNodeImpl<E>(stage, id, startPoints, leadsTo, priority, blockSiblings, blockNext);
        }

        public static /* synthetic */ QuestNodeImpl copy$default(QuestNodeImpl questNodeImpl, QuestStage questStage, String string, List list, List list2, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                questStage = questNodeImpl.stage;
            }
            if ((n2 & 2) != 0) {
                string = questNodeImpl.id;
            }
            if ((n2 & 4) != 0) {
                list = questNodeImpl.startPoints;
            }
            if ((n2 & 8) != 0) {
                list2 = questNodeImpl.leadsTo;
            }
            if ((n2 & 0x10) != 0) {
                n = questNodeImpl.priority;
            }
            if ((n2 & 0x20) != 0) {
                bl = questNodeImpl.blockSiblings;
            }
            if ((n2 & 0x40) != 0) {
                bl2 = questNodeImpl.blockNext;
            }
            return questNodeImpl.copy(questStage, string, list, list2, n, bl, bl2);
        }

        public int hashCode() {
            int result = this.stage.hashCode();
            result = result * 31 + this.id.hashCode();
            result = result * 31 + ((Object)this.startPoints).hashCode();
            result = result * 31 + ((Object)this.leadsTo).hashCode();
            result = result * 31 + Integer.hashCode(this.priority);
            result = result * 31 + Boolean.hashCode(this.blockSiblings);
            result = result * 31 + Boolean.hashCode(this.blockNext);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuestNodeImpl)) {
                return false;
            }
            QuestNodeImpl questNodeImpl = (QuestNodeImpl)other;
            if (!Intrinsics.areEqual(this.stage, questNodeImpl.stage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)questNodeImpl.id)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.startPoints, questNodeImpl.startPoints)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.leadsTo, questNodeImpl.leadsTo)) {
                return false;
            }
            if (this.priority != questNodeImpl.priority) {
                return false;
            }
            if (this.blockSiblings != questNodeImpl.blockSiblings) {
                return false;
            }
            return this.blockNext == questNodeImpl.blockNext;
        }
    }
}

