/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.structure;

import com.mojang.datafixers.util.Pair;
import com.ruslan.growsseth.RuinsOfGrowsseth;
import com.ruslan.growsseth.compat.LithostitchedCompat;
import com.ruslan.growsseth.config.StructureConfig;
import com.ruslan.growsseth.utils.UtilsKt;
import com.ruslan.growsseth.worldgen.worldpreset.GrowssethWorldPreset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3781;
import net.minecraft.class_3785;
import net.minecraft.class_5188;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJA\u0010\u0015\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J;\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00172\n\u0010\u001a\u001a\u00060\u0017j\u0002`\u00192\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR-\u0010\"\u001a\u0018\u0012\b\u0012\u00060\u0017j\u0002`\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0!0 8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0018\u0010&\u001a\u00060\u0017j\u0002`\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0017\u0010*\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b.\u0010+\u001a\u0004\b/\u0010-R\u0017\u00100\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b0\u0010+\u001a\u0004\b1\u0010-R\u0017\u00102\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b2\u0010+\u001a\u0004\b3\u0010-R\u0017\u00104\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b4\u0010+\u001a\u0004\b5\u0010-\u00a8\u00067"}, d2={"Lcom/ruslan/growsseth/structure/VillageBuildings;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "isLithostitchedLoaded", "", "addVillageBuildings", "(Lnet/minecraft/server/MinecraftServer;Z)V", "Lnet/minecraft/class_2378;", "Lnet/minecraft/class_3785;", "templatePoolRegistry", "Lnet/minecraft/class_5497;", "processorListRegistry", "Lnet/minecraft/class_2960;", "poolId", "poolPieceId", "", "weight", "addBuildingToPool", "(Lnet/minecraft/class_2378;Lnet/minecraft/class_2378;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;I)V", "", "name", "Lcom/ruslan/growsseth/structure/BuildingKey;", "category", "kind", "pool", "Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "register", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "", "", "houseEntries", "Ljava/util/Map;", "getHouseEntries", "()Ljava/util/Map;", "CATEGORY_GOLEM_HOUSE", "Ljava/lang/String;", "DEFAULT_GOLEM_WEIGHT", "I", "DESERT_GOLEM", "Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "getDESERT_GOLEM", "()Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "PLAINS_GOLEM", "getPLAINS_GOLEM", "TAIGA_GOLEM", "getTAIGA_GOLEM", "SAVANNA_GOLEM", "getSAVANNA_GOLEM", "SNOWY_GOLEM", "getSNOWY_GOLEM", "VillageEntry", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nVillageBuildings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VillageBuildings.kt\ncom/ruslan/growsseth/structure/VillageBuildings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,106:1\n1863#2,2:107\n1#3:109\n381#4,7:110\n*S KotlinDebug\n*F\n+ 1 VillageBuildings.kt\ncom/ruslan/growsseth/structure/VillageBuildings\n*L\n49#1:107,2\n92#1:110,7\n*E\n"})
public final class VillageBuildings {
    @NotNull
    public static final VillageBuildings INSTANCE = new VillageBuildings();
    @NotNull
    private static final Map<String, List<VillageEntry>> houseEntries = new LinkedHashMap();
    @NotNull
    public static final String CATEGORY_GOLEM_HOUSE = "golem_house";
    public static final int DEFAULT_GOLEM_WEIGHT = 3;
    @NotNull
    private static final VillageEntry DESERT_GOLEM = INSTANCE.register("desert_golem_house", "golem_house", "desert", "houses", 3);
    @NotNull
    private static final VillageEntry PLAINS_GOLEM = INSTANCE.register("plains_golem_house", "golem_house", "plains", "houses", 3);
    @NotNull
    private static final VillageEntry TAIGA_GOLEM = INSTANCE.register("taiga_golem_house", "golem_house", "taiga", "houses", 3);
    @NotNull
    private static final VillageEntry SAVANNA_GOLEM = INSTANCE.register("savanna_golem_house", "golem_house", "savanna", "houses", 3);
    @NotNull
    private static final VillageEntry SNOWY_GOLEM = INSTANCE.register("snowy_golem_house", "golem_house", "snowy", "houses", 3);

    private VillageBuildings() {
    }

    @NotNull
    public final Map<String, List<VillageEntry>> getHouseEntries() {
        return houseEntries;
    }

    @NotNull
    public final VillageEntry getDESERT_GOLEM() {
        return DESERT_GOLEM;
    }

    @NotNull
    public final VillageEntry getPLAINS_GOLEM() {
        return PLAINS_GOLEM;
    }

    @NotNull
    public final VillageEntry getTAIGA_GOLEM() {
        return TAIGA_GOLEM;
    }

    @NotNull
    public final VillageEntry getSAVANNA_GOLEM() {
        return SAVANNA_GOLEM;
    }

    @NotNull
    public final VillageEntry getSNOWY_GOLEM() {
        return SNOWY_GOLEM;
    }

    public final void addVillageBuildings(@NotNull MinecraftServer server, boolean isLithostitchedLoaded) {
        boolean shouldAddBuildings;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (isLithostitchedLoaded) {
            RuinsOfGrowsseth.LOGGER.warn("Lithostitched library is loaded, RoG's village houses will also spawn in the Growsseth preset!", new Object[0]);
        }
        boolean bl = shouldAddBuildings = StructureConfig.golemHouseEnabled && (isLithostitchedLoaded || !GrowssethWorldPreset.isGrowssethPreset(server));
        if (!shouldAddBuildings) {
            return;
        }
        Object t = server.method_30611().method_33310(class_7924.field_41249).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        class_2378 templatePools = (class_2378)t;
        Object t2 = server.method_30611().method_33310(class_7924.field_41247).get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
        class_2378 processorLists = (class_2378)t2;
        KFunction addBuildingToPoolFunction2 = isLithostitchedLoaded ? (KFunction)new Function5<class_2378<class_3785>, class_2378<class_5497>, class_2960, class_2960, Integer, Unit>((Object)LithostitchedCompat.INSTANCE){

            public final void invoke(class_2378<class_3785> p0, class_2378<class_5497> p1, class_2960 p2, class_2960 p3, int p4) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                ((LithostitchedCompat)this.receiver).addBuildingToPool(p0, p1, p2, p3, p4);
            }
        } : (KFunction)new Function5<class_2378<class_3785>, class_2378<class_5497>, class_2960, class_2960, Integer, Unit>((Object)this){

            public final void invoke(class_2378<class_3785> p0, class_2378<class_5497> p1, class_2960 p2, class_2960 p3, int p4) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                ((VillageBuildings)this.receiver).addBuildingToPool(p0, p1, p2, p3, p4);
            }
        };
        List<VillageEntry> list = houseEntries.get(CATEGORY_GOLEM_HOUSE);
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VillageEntry entry = (VillageEntry)element$iv;
            boolean bl2 = false;
            if (RuinsOfGrowsseth.Companion.getModCompat().isImprovedVillagePlacementLoaded()) {
                entry.setWeight(entry.getWeight() * 2);
            }
            ((Function5)addBuildingToPoolFunction2).invoke((Object)templatePools, (Object)processorLists, (Object)entry.getParentPool(), (Object)entry.getNormalTemplate(), (Object)entry.getWeight());
            ((Function5)addBuildingToPoolFunction2).invoke((Object)templatePools, (Object)processorLists, (Object)entry.getParentZombiePool(), (Object)entry.getZombieTemplate(), (Object)entry.getWeight());
        }
    }

    public static /* synthetic */ void addVillageBuildings$default(VillageBuildings villageBuildings, MinecraftServer minecraftServer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        villageBuildings.addVillageBuildings(minecraftServer, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBuildingToPool(@NotNull class_2378<class_3785> templatePoolRegistry, @NotNull class_2378<class_5497> processorListRegistry, @NotNull class_2960 poolId, @NotNull class_2960 poolPieceId, int weight) {
        void it;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(templatePoolRegistry, (String)"templatePoolRegistry");
        Intrinsics.checkNotNullParameter(processorListRegistry, (String)"processorListRegistry");
        Intrinsics.checkNotNullParameter((Object)poolId, (String)"poolId");
        Intrinsics.checkNotNullParameter((Object)poolPieceId, (String)"poolPieceId");
        Object object = templatePoolRegistry.method_31140(class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)poolId));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(...)");
        class_3785 pool = (class_3785)object;
        class_5188 piece = (class_5188)class_3781.method_30425((String)poolPieceId.toString()).apply(class_3785.class_3786.field_16687);
        for (int i = 0; i < weight; ++i) {
            pool.field_16680.add((Object)piece);
        }
        ArrayList arrayList2 = arrayList = new ArrayList(pool.field_16864);
        class_3785 class_37852 = pool;
        boolean bl = false;
        it.add(new Pair((Object)piece, (Object)weight));
        class_37852.field_16864 = arrayList;
    }

    private final VillageEntry register(String name, String category, String kind, String pool, int weight) {
        List list;
        VillageEntry villageEntry;
        String prefix = "village";
        String templateName = prefix + "/" + kind + "/" + name;
        String templateNameZombie = prefix + "/" + kind + "/" + name + "_zombie";
        String poolName = StringsKt.replace$default((String)(prefix + "/" + name), (String)"house", (String)"houses", (boolean)false, (int)4, null);
        String poolNameZombie = StringsKt.replace$default((String)(prefix + "/" + name + "_zombie"), (String)"house", (String)"houses", (boolean)false, (int)4, null);
        class_2960 class_29602 = class_2960.method_60655((String)"minecraft", (String)(prefix + "/" + kind + "/" + pool));
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"fromNamespaceAndPath(...)");
        class_2960 class_29603 = class_2960.method_60655((String)"minecraft", (String)(prefix + "/" + kind + "/zombie/" + pool));
        Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"fromNamespaceAndPath(...)");
        VillageEntry it = villageEntry = new VillageEntry(kind, class_29602, class_29603, UtilsKt.resLoc(poolName), UtilsKt.resLoc(poolNameZombie), UtilsKt.resLoc(templateName), UtilsKt.resLoc(templateNameZombie), weight);
        boolean bl = false;
        Map<String, List<VillageEntry>> $this$getOrPut$iv = houseEntries;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(category);
        if (value$iv == null) {
            boolean bl2 = false;
            boolean $i$f$register$lambda$2$stub_for_inlining = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(category, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        list.add((VillageEntry)it);
        return villageEntry;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0010\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0010\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0010\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J`\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b \u0010\u0019J\u0010\u0010!\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010\u0012R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010$\u001a\u0004\b&\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010$\u001a\u0004\b'\u0010\u0012R\u0017\u0010\b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b(\u0010\u0012R\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010$\u001a\u0004\b)\u0010\u0012R\u0017\u0010\n\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010$\u001a\u0004\b*\u0010\u0012R\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010+\u001a\u0004\b,\u0010\u0019\"\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "", "", "kind", "Lnet/minecraft/class_2960;", "parentPool", "parentZombiePool", "normalPool", "zombiePool", "normalTemplate", "zombieTemplate", "", "weight", "<init>", "(Ljava/lang/String;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;I)V", "component1", "()Ljava/lang/String;", "component2", "()Lnet/minecraft/class_2960;", "component3", "component4", "component5", "component6", "component7", "component8", "()I", "copy", "(Ljava/lang/String;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;I)Lcom/ruslan/growsseth/structure/VillageBuildings$VillageEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getKind", "Lnet/minecraft/class_2960;", "getParentPool", "getParentZombiePool", "getNormalPool", "getZombiePool", "getNormalTemplate", "getZombieTemplate", "I", "getWeight", "setWeight", "(I)V", "ruins-of-growsseth"})
    public static final class VillageEntry {
        @NotNull
        private final String kind;
        @NotNull
        private final class_2960 parentPool;
        @NotNull
        private final class_2960 parentZombiePool;
        @NotNull
        private final class_2960 normalPool;
        @NotNull
        private final class_2960 zombiePool;
        @NotNull
        private final class_2960 normalTemplate;
        @NotNull
        private final class_2960 zombieTemplate;
        private int weight;

        public VillageEntry(@NotNull String kind, @NotNull class_2960 parentPool, @NotNull class_2960 parentZombiePool, @NotNull class_2960 normalPool, @NotNull class_2960 zombiePool, @NotNull class_2960 normalTemplate, @NotNull class_2960 zombieTemplate, int weight) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)parentPool, (String)"parentPool");
            Intrinsics.checkNotNullParameter((Object)parentZombiePool, (String)"parentZombiePool");
            Intrinsics.checkNotNullParameter((Object)normalPool, (String)"normalPool");
            Intrinsics.checkNotNullParameter((Object)zombiePool, (String)"zombiePool");
            Intrinsics.checkNotNullParameter((Object)normalTemplate, (String)"normalTemplate");
            Intrinsics.checkNotNullParameter((Object)zombieTemplate, (String)"zombieTemplate");
            this.kind = kind;
            this.parentPool = parentPool;
            this.parentZombiePool = parentZombiePool;
            this.normalPool = normalPool;
            this.zombiePool = zombiePool;
            this.normalTemplate = normalTemplate;
            this.zombieTemplate = zombieTemplate;
            this.weight = weight;
        }

        @NotNull
        public final String getKind() {
            return this.kind;
        }

        @NotNull
        public final class_2960 getParentPool() {
            return this.parentPool;
        }

        @NotNull
        public final class_2960 getParentZombiePool() {
            return this.parentZombiePool;
        }

        @NotNull
        public final class_2960 getNormalPool() {
            return this.normalPool;
        }

        @NotNull
        public final class_2960 getZombiePool() {
            return this.zombiePool;
        }

        @NotNull
        public final class_2960 getNormalTemplate() {
            return this.normalTemplate;
        }

        @NotNull
        public final class_2960 getZombieTemplate() {
            return this.zombieTemplate;
        }

        public final int getWeight() {
            return this.weight;
        }

        public final void setWeight(int n) {
            this.weight = n;
        }

        @NotNull
        public final String component1() {
            return this.kind;
        }

        @NotNull
        public final class_2960 component2() {
            return this.parentPool;
        }

        @NotNull
        public final class_2960 component3() {
            return this.parentZombiePool;
        }

        @NotNull
        public final class_2960 component4() {
            return this.normalPool;
        }

        @NotNull
        public final class_2960 component5() {
            return this.zombiePool;
        }

        @NotNull
        public final class_2960 component6() {
            return this.normalTemplate;
        }

        @NotNull
        public final class_2960 component7() {
            return this.zombieTemplate;
        }

        public final int component8() {
            return this.weight;
        }

        @NotNull
        public final VillageEntry copy(@NotNull String kind, @NotNull class_2960 parentPool, @NotNull class_2960 parentZombiePool, @NotNull class_2960 normalPool, @NotNull class_2960 zombiePool, @NotNull class_2960 normalTemplate, @NotNull class_2960 zombieTemplate, int weight) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)parentPool, (String)"parentPool");
            Intrinsics.checkNotNullParameter((Object)parentZombiePool, (String)"parentZombiePool");
            Intrinsics.checkNotNullParameter((Object)normalPool, (String)"normalPool");
            Intrinsics.checkNotNullParameter((Object)zombiePool, (String)"zombiePool");
            Intrinsics.checkNotNullParameter((Object)normalTemplate, (String)"normalTemplate");
            Intrinsics.checkNotNullParameter((Object)zombieTemplate, (String)"zombieTemplate");
            return new VillageEntry(kind, parentPool, parentZombiePool, normalPool, zombiePool, normalTemplate, zombieTemplate, weight);
        }

        public static /* synthetic */ VillageEntry copy$default(VillageEntry villageEntry, String string, class_2960 class_29602, class_2960 class_29603, class_2960 class_29604, class_2960 class_29605, class_2960 class_29606, class_2960 class_29607, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = villageEntry.kind;
            }
            if ((n2 & 2) != 0) {
                class_29602 = villageEntry.parentPool;
            }
            if ((n2 & 4) != 0) {
                class_29603 = villageEntry.parentZombiePool;
            }
            if ((n2 & 8) != 0) {
                class_29604 = villageEntry.normalPool;
            }
            if ((n2 & 0x10) != 0) {
                class_29605 = villageEntry.zombiePool;
            }
            if ((n2 & 0x20) != 0) {
                class_29606 = villageEntry.normalTemplate;
            }
            if ((n2 & 0x40) != 0) {
                class_29607 = villageEntry.zombieTemplate;
            }
            if ((n2 & 0x80) != 0) {
                n = villageEntry.weight;
            }
            return villageEntry.copy(string, class_29602, class_29603, class_29604, class_29605, class_29606, class_29607, n);
        }

        @NotNull
        public String toString() {
            return "VillageEntry(kind=" + this.kind + ", parentPool=" + this.parentPool + ", parentZombiePool=" + this.parentZombiePool + ", normalPool=" + this.normalPool + ", zombiePool=" + this.zombiePool + ", normalTemplate=" + this.normalTemplate + ", zombieTemplate=" + this.zombieTemplate + ", weight=" + this.weight + ")";
        }

        public int hashCode() {
            int result = this.kind.hashCode();
            result = result * 31 + this.parentPool.hashCode();
            result = result * 31 + this.parentZombiePool.hashCode();
            result = result * 31 + this.normalPool.hashCode();
            result = result * 31 + this.zombiePool.hashCode();
            result = result * 31 + this.normalTemplate.hashCode();
            result = result * 31 + this.zombieTemplate.hashCode();
            result = result * 31 + Integer.hashCode(this.weight);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VillageEntry)) {
                return false;
            }
            VillageEntry villageEntry = (VillageEntry)other;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)villageEntry.kind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentPool, (Object)villageEntry.parentPool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentZombiePool, (Object)villageEntry.parentZombiePool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normalPool, (Object)villageEntry.normalPool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.zombiePool, (Object)villageEntry.zombiePool)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normalTemplate, (Object)villageEntry.normalTemplate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.zombieTemplate, (Object)villageEntry.zombieTemplate)) {
                return false;
            }
            return this.weight == villageEntry.weight;
        }
    }
}

