/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010%\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010)\u001a\u00020#2\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*J#\u0010/\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020#0+2\u0006\u0010.\u001a\u00020-\u00a2\u0006\u0004\b/\u00100J#\u00102\u001a\b\u0012\u0004\u0012\u00020#0+2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00101\u001a\u00020'\u00a2\u0006\u0004\b2\u00103\u00a8\u00065"}, d2={"Lcom/ruslan/growsseth/utils/DecryptUtil;", "", "<init>", "()V", "", "password", "Ljava/io/File;", "file", "", "generateRandomKeyWithPassword", "(Ljava/lang/String;Ljava/io/File;)V", "Ljavax/crypto/SecretKey;", "key", "inputFile", "outputFile", "encryptFile", "(Ljavax/crypto/SecretKey;Ljava/io/File;Ljava/io/File;)V", "Ljava/io/InputStream;", "inputStream", "Ljavax/crypto/CipherInputStream;", "decryptInputStream", "(Ljavax/crypto/SecretKey;Ljava/io/InputStream;)Ljavax/crypto/CipherInputStream;", "readKey", "(Ljava/io/File;Ljava/lang/String;)Ljavax/crypto/SecretKey;", "(Ljava/io/InputStream;Ljava/lang/String;)Ljavax/crypto/SecretKey;", "Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;", "encryptedKey", "writeKey", "(Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;Ljava/io/File;)V", "generateRandomKey", "()Ljavax/crypto/SecretKey;", "encryptKey", "(Ljavax/crypto/SecretKey;Ljava/lang/String;)Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;", "decryptKey", "(Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;Ljava/lang/String;)Ljavax/crypto/SecretKey;", "", "salt", "deriveKeyFromPassword", "(Ljava/lang/String;[B)Ljavax/crypto/SecretKey;", "", "length", "generateRandomBytes", "(I)[B", "", "arrays", "Ljava/io/OutputStream;", "outputStream", "writeBytesRoundRobin", "(Ljava/util/List;Ljava/io/OutputStream;)V", "numArrays", "readBytesRoundRobin", "(Ljava/io/InputStream;I)Ljava/util/List;", "EncryptedKey", "ruins-of-growsseth"})
@SourceDebugExtension(value={"SMAP\nDecryptUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptUtil.kt\ncom/ruslan/growsseth/utils/DecryptUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1#2:191\n1557#3:192\n1628#3,3:193\n1557#3:196\n1628#3,3:197\n1279#3,2:200\n1293#3,4:202\n1557#3:206\n1628#3,3:207\n1053#3:210\n1557#3:211\n1628#3,3:212\n*S KotlinDebug\n*F\n+ 1 DecryptUtil.kt\ncom/ruslan/growsseth/utils/DecryptUtil\n*L\n119#1:192\n119#1:193,3\n160#1:196\n160#1:197,3\n161#1:200,2\n161#1:202,4\n163#1:206\n163#1:207,3\n188#1:210\n188#1:211\n188#1:212,3\n*E\n"})
public final class DecryptUtil {
    @NotNull
    public static final DecryptUtil INSTANCE = new DecryptUtil();

    private DecryptUtil() {
    }

    public final void generateRandomKeyWithPassword(@NotNull String password, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SecretKey randomKey = this.generateRandomKey();
        EncryptedKey encryptedKey = this.encryptKey(randomKey, password);
        this.writeKey(encryptedKey, file);
    }

    public final void encryptFile(@NotNull SecretKey key, @NotNull File inputFile, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] inputBytes = FilesKt.readBytes((File)inputFile);
        byte[] outputBytes = cipher.doFinal(inputBytes);
        Intrinsics.checkNotNull((Object)outputBytes);
        FilesKt.writeBytes((File)outputFile, (byte[])outputBytes);
    }

    @NotNull
    public final CipherInputStream decryptInputStream(@NotNull SecretKey key, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        return new CipherInputStream(inputStream, cipher);
    }

    @NotNull
    public final SecretKey readKey(@NotNull File file, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.readKey(new FileInputStream(file), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SecretKey readKey(@NotNull InputStream inputStream, @NotNull String password) {
        EncryptedKey encryptedKey;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            encryptedKey = EncryptedKey.Companion.read(inputStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        EncryptedKey encryptedKey2 = encryptedKey;
        return this.decryptKey(encryptedKey2, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeKey(EncryptedKey encryptedKey, File file) {
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            encryptedKey.write(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final SecretKey generateRandomKey() {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        SecretKey secretKey = keyGen.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
        return secretKey;
    }

    private final EncryptedKey encryptKey(SecretKey key, String password) {
        byte[] salt = this.generateRandomBytes(16);
        byte[] iv = this.generateRandomBytes(12);
        SecretKey passwordKey = this.deriveKeyFromPassword(password, salt);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)passwordKey, gcmSpec);
        byte[] encryptedKey = cipher.doFinal(key.getEncoded());
        Intrinsics.checkNotNull((Object)encryptedKey);
        return new EncryptedKey(encryptedKey, salt, iv);
    }

    private final SecretKey decryptKey(EncryptedKey encryptedKey, String password) {
        SecretKey passwordKey = this.deriveKeyFromPassword(password, encryptedKey.getSalt());
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, encryptedKey.getIv());
        cipher.init(2, (Key)passwordKey, gcmSpec);
        byte[] decryptedKeyBytes = cipher.doFinal(encryptedKey.getEncryptedKey());
        return new SecretKeySpec(decryptedKeyBytes, "AES");
    }

    private final SecretKey deriveKeyFromPassword(String password, byte[] salt) {
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        KeySpec spec = new PBEKeySpec(cArray, salt, 65536, 256);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        byte[] keyBytes = factory.generateSecret(spec).getEncoded();
        return new SecretKeySpec(keyBytes, "AES");
    }

    private final byte[] generateRandomBytes(int length) {
        byte[] bytes = new byte[length];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBytesRoundRobin(@NotNull List<byte[]> arrays, @NotNull OutputStream outputStream) {
        int i;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Iterable iterable = arrays;
        int n = 0;
        for (Object t : iterable) {
            void it;
            byte[] byArray = (byte[])t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((void)it).length;
            n = n2 + n3;
        }
        int outArrayLength = n;
        byte[] outArray = new byte[outArrayLength];
        Map arrayEndings = new LinkedHashMap();
        Iterable $this$map$iv = arrays;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(0);
        }
        List arrayIndices = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int currentArray = 0;
        for (i = 0; i < outArrayLength; ++i) {
            byte[] array = null;
            int idx = 0;
            do {
                array = arrays.get(currentArray);
                idx = ((Number)arrayIndices.get(currentArray)).intValue();
                if (idx < array.length) continue;
                currentArray = (currentArray + 1) % arrays.size();
            } while (idx >= array.length);
            outArray[i] = array[idx];
            if (++idx >= array.length) {
                Integer n4 = currentArray;
                Integer n5 = i;
                arrayEndings.put(n4, n5);
            }
            arrayIndices.set(currentArray, idx);
            currentArray = (currentArray + 1) % arrays.size();
        }
        int n6 = arrays.size();
        for (i = 0; i < n6; ++i) {
            Object v = arrayEndings.get(i);
            Intrinsics.checkNotNull(v);
            outputStream.write(((Number)v).intValue());
        }
        outputStream.write(outArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<byte[]> readBytesRoundRobin(@NotNull InputStream inputStream, int numArrays) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        byte[] array;
        void $this$mapTo$iv$iv22;
        int n;
        int n2;
        Object object;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        List arrayEndings = new ArrayList();
        int n3 = 0;
        while (n3 < numArrays) {
            int it = n3++;
            boolean bl = false;
            int length = inputStream.read();
            arrayEndings.add(length);
        }
        byte[] scrambledArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        Map arrays = new LinkedHashMap();
        Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)numArrays);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv3.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n4 = item$iv$iv = ((IntIterator)iterator).nextInt();
            object = destination$iv$iv;
            n2 = 0;
            object.add(new byte[scrambledArray.length]);
        }
        List arrayHolders = (List)destination$iv$iv;
        Iterable $this$associateWith$iv = (Iterable)RangesKt.until((int)0, (int)numArrays);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            n2 = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            object = result$iv;
            n = 0;
            Boolean bl = false;
            object.put(t, bl);
        }
        Map arrayDone = MapsKt.toMutableMap((Map)result$iv);
        Iterable $this$map$iv3 = (Iterable)RangesKt.until((int)0, (int)numArrays);
        boolean $i$f$map2 = false;
        $this$associateWithTo$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator element$iv$iv = $this$mapTo$iv$iv22.iterator();
        while (element$iv$iv.hasNext()) {
            int item$iv$iv;
            n = item$iv$iv = ((IntIterator)element$iv$iv).nextInt();
            object = destination$iv$iv2;
            boolean $i$a$-map-DecryptUtil$readBytesRoundRobin$arrayIndices$22 = false;
            object.add(0);
        }
        List arrayIndices = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        int currentArray = 0;
        int $this$mapTo$iv$iv22 = scrambledArray.length;
        for (int i = 0; i < $this$mapTo$iv$iv22; ++i) {
            while (true) {
                Object v = arrayDone.get(currentArray);
                Intrinsics.checkNotNull(v);
                if (!((Boolean)v).booleanValue()) break;
                currentArray = (currentArray + 1) % numArrays;
            }
            array = (byte[])arrayHolders.get(currentArray);
            int idx = ((Number)arrayIndices.get(currentArray)).intValue();
            array[idx] = scrambledArray[i];
            if (((Number)arrayEndings.get(currentArray)).intValue() == i) {
                int size = idx + 1;
                Integer it = currentArray;
                arrayDone.put(it, true);
                Map map = arrays;
                it = currentArray;
                int $i$a$-map-DecryptUtil$readBytesRoundRobin$arrayIndices$22 = 0;
                byte[] byArray = new byte[size];
                while ($i$a$-map-DecryptUtil$readBytesRoundRobin$arrayIndices$22 < size) {
                    int n5 = $i$a$-map-DecryptUtil$readBytesRoundRobin$arrayIndices$22++;
                    byArray[n5] = ((byte[])arrayHolders.get(currentArray))[n5];
                }
                byte[] $i$a$-map-DecryptUtil$readBytesRoundRobin$arrayIndices$22 = byArray;
                map.put(it, $i$a$-map-DecryptUtil$readBytesRoundRobin$arrayIndices$22);
            }
            List size = arrayIndices;
            int n6 = currentArray;
            int it = ((Number)size.get(n6)).intValue();
            size.set(n6, it + 1);
            currentArray = (currentArray + 1) % numArrays;
        }
        if (arrays.keySet().size() != numArrays) {
            throw new IllegalStateException("Something went wrong, got " + arrays.keySet().size() + " arrays instead of " + numArrays);
        }
        Iterable $this$sortedBy$iv = arrays.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        });
        boolean $i$f$map3 = false;
        array = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry $i$a$-map-DecryptUtil$readBytesRoundRobin$arrayIndices$22 = (Map.Entry)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            object.add((byte[])it.getValue());
        }
        return (List)destination$iv$iv3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000eJ.\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001f\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b \u0010\u000e\u00a8\u0006\""}, d2={"Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;", "", "", "encryptedKey", "salt", "iv", "<init>", "([B[B[B)V", "Ljava/io/OutputStream;", "outputStream", "", "write", "(Ljava/io/OutputStream;)V", "component1", "()[B", "component2", "component3", "copy", "([B[B[B)Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "[B", "getEncryptedKey", "getSalt", "getIv", "Companion", "ruins-of-growsseth"})
    public static final class EncryptedKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] encryptedKey;
        @NotNull
        private final byte[] salt;
        @NotNull
        private final byte[] iv;

        public EncryptedKey(@NotNull byte[] encryptedKey, @NotNull byte[] salt, @NotNull byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)encryptedKey, (String)"encryptedKey");
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            this.encryptedKey = encryptedKey;
            this.salt = salt;
            this.iv = iv;
        }

        @NotNull
        public final byte[] getEncryptedKey() {
            return this.encryptedKey;
        }

        @NotNull
        public final byte[] getSalt() {
            return this.salt;
        }

        @NotNull
        public final byte[] getIv() {
            return this.iv;
        }

        public final void write(@NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            byte[][] byArrayArray = new byte[][]{this.encryptedKey, this.salt, this.iv};
            INSTANCE.writeBytesRoundRobin(CollectionsKt.listOf((Object[])((Object[])byArrayArray)), outputStream);
        }

        @NotNull
        public final byte[] component1() {
            return this.encryptedKey;
        }

        @NotNull
        public final byte[] component2() {
            return this.salt;
        }

        @NotNull
        public final byte[] component3() {
            return this.iv;
        }

        @NotNull
        public final EncryptedKey copy(@NotNull byte[] encryptedKey, @NotNull byte[] salt, @NotNull byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)encryptedKey, (String)"encryptedKey");
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            return new EncryptedKey(encryptedKey, salt, iv);
        }

        public static /* synthetic */ EncryptedKey copy$default(EncryptedKey encryptedKey, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, Object object) {
            if ((n & 1) != 0) {
                byArray = encryptedKey.encryptedKey;
            }
            if ((n & 2) != 0) {
                byArray2 = encryptedKey.salt;
            }
            if ((n & 4) != 0) {
                byArray3 = encryptedKey.iv;
            }
            return encryptedKey.copy(byArray, byArray2, byArray3);
        }

        @NotNull
        public String toString() {
            return "EncryptedKey(encryptedKey=" + Arrays.toString(this.encryptedKey) + ", salt=" + Arrays.toString(this.salt) + ", iv=" + Arrays.toString(this.iv) + ")";
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.encryptedKey);
            result = result * 31 + Arrays.hashCode(this.salt);
            result = result * 31 + Arrays.hashCode(this.iv);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EncryptedKey)) {
                return false;
            }
            EncryptedKey encryptedKey = (EncryptedKey)other;
            if (!Intrinsics.areEqual((Object)this.encryptedKey, (Object)encryptedKey.encryptedKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.salt, (Object)encryptedKey.salt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.iv, (Object)encryptedKey.iv);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey$Companion;", "", "<init>", "()V", "Ljava/io/InputStream;", "inputStream", "Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;", "read", "(Ljava/io/InputStream;)Lcom/ruslan/growsseth/utils/DecryptUtil$EncryptedKey;", "ruins-of-growsseth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final EncryptedKey read(@NotNull InputStream inputStream) {
                Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                List<byte[]> arrays = INSTANCE.readBytesRoundRobin(inputStream, 3);
                return new EncryptedKey(arrays.get(0), arrays.get(1), arrays.get(2));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

