/*
 * Decompiled with CFR 0.152.
 */
package com.ruslan.growsseth.worldgen.worldpreset;

import com.filloax.fxlib.api.FxLibServices;
import com.filloax.fxlib.api.networking.NetworkingUtilsKt;
import com.filloax.fxlib.api.structure.FixedStructureGeneration;
import com.mojang.datafixers.util.Either;
import com.ruslan.growsseth.config.WorldPresetConfig;
import com.ruslan.growsseth.network.PlacesInfoPacket;
import com.ruslan.growsseth.utils.UtilsKt;
import com.ruslan.growsseth.worldgen.GrowssethModBiomeSources;
import com.ruslan.growsseth.worldgen.GrowssethModWorldPresets;
import com.ruslan.growsseth.worldgen.worldpreset.LocationNotifListener;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.class_1966;
import net.minecraft.class_2169;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5425;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7134;
import net.minecraft.class_7145;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_8197;
import net.minecraft.class_8198;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\b\u0010\u0010J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\b\u0010\u0013J#\u0010\u0018\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001c\u001a\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001e\u0010\u0010J\u001b\u0010!\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001f\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010%\u001a\u00020$2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020#0\u001f\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset;", "", "<init>", "()V", "Lnet/minecraft/class_6880;", "Lnet/minecraft/class_7145;", "preset", "", "isGrowssethPreset", "(Lnet/minecraft/class_6880;)Z", "Lnet/minecraft/class_1966;", "biomeSource", "isGrowssethPresetFromOverworldBiomeSource", "(Lnet/minecraft/class_1966;)Z", "Lnet/minecraft/server/MinecraftServer;", "server", "(Lnet/minecraft/server/MinecraftServer;)Z", "Lnet/minecraft/class_5425;", "levelAcc", "(Lnet/minecraft/class_5425;)Z", "Lnet/minecraft/class_3195;", "structure", "Lnet/minecraft/class_3218;", "level", "shouldDisableStructure", "(Lnet/minecraft/class_6880;Lnet/minecraft/class_3218;)Z", "Lnet/minecraft/class_7059;", "structureSet", "shouldDisableStructureSet", "(Lnet/minecraft/class_6880;Lnet/minecraft/class_1966;)Z", "shouldDisableVillagePresets", "Lnet/minecraft/class_7891;", "ctx", "build", "(Lnet/minecraft/class_7891;)Lnet/minecraft/class_7145;", "Lnet/minecraft/class_8197;", "", "bootstrapNoiseBiomeSourcesSettings", "(Lnet/minecraft/class_7891;)V", "", "GROWSSETH_SEED", "Ljava/lang/String;", "Lcom/filloax/fxlib/api/structure/FixedStructureGeneration;", "fixedStructureGeneration", "Lcom/filloax/fxlib/api/structure/FixedStructureGeneration;", "Callbacks", "ruins-of-growsseth"})
public final class GrowssethWorldPreset {
    @NotNull
    public static final GrowssethWorldPreset INSTANCE = new GrowssethWorldPreset();
    @NotNull
    public static final String GROWSSETH_SEED = "MelminaVerde";
    @NotNull
    private static final FixedStructureGeneration fixedStructureGeneration = FxLibServices.INSTANCE.getFixedStructureGeneration();

    private GrowssethWorldPreset() {
    }

    @JvmStatic
    public static final boolean isGrowssethPreset(@Nullable class_6880<class_7145> preset) {
        class_5321 class_53212 = preset;
        return class_53212 != null && (class_53212 = class_53212.method_40230()) != null && (class_53212 = (class_5321)OptionalsKt.getOrNull(class_53212)) != null ? class_53212.equals(GrowssethModWorldPresets.GROWSSETH) : false;
    }

    @JvmStatic
    public static final boolean isGrowssethPresetFromOverworldBiomeSource(@NotNull class_1966 biomeSource) {
        Intrinsics.checkNotNullParameter((Object)biomeSource, (String)"biomeSource");
        if (biomeSource instanceof class_4766) {
            Either parameters = ((class_4766)biomeSource).field_34498;
            Object object = parameters.map(arg_0 -> GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource$lambda$1(GrowssethWorldPreset::isGrowssethPresetFromOverworldBiomeSource$lambda$0, arg_0), arg_0 -> GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource$lambda$3(GrowssethWorldPreset::isGrowssethPresetFromOverworldBiomeSource$lambda$2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map(...)");
            return (Boolean)object;
        }
        return false;
    }

    @JvmStatic
    public static final boolean isGrowssethPreset(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_1966 class_19662 = server.method_30002().method_14178().method_12129().method_12098();
        Intrinsics.checkNotNullExpressionValue((Object)class_19662, (String)"getBiomeSource(...)");
        return GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource(class_19662);
    }

    @JvmStatic
    public static final boolean isGrowssethPreset(@NotNull class_5425 levelAcc) {
        Intrinsics.checkNotNullParameter((Object)levelAcc, (String)"levelAcc");
        MinecraftServer minecraftServer = levelAcc.method_8410().method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        return GrowssethWorldPreset.isGrowssethPreset(minecraftServer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldDisableStructure(@NotNull class_6880<class_3195> structure, @NotNull class_3218 level) {
        Intrinsics.checkNotNullParameter(structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!GrowssethWorldPreset.isGrowssethPreset((class_5425)level)) return false;
        Optional optional = structure.method_40230();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
        class_5321 class_53212 = (class_5321)OptionalsKt.getOrNull((Optional)optional);
        if (!Intrinsics.areEqual((Object)(class_53212 != null && (class_53212 = class_53212.method_29177()) != null ? class_53212.method_12836() : null), (Object)"growsseth")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldDisableStructureSet(@NotNull class_6880<class_7059> structureSet, @NotNull class_1966 biomeSource) {
        Intrinsics.checkNotNullParameter(structureSet, (String)"structureSet");
        Intrinsics.checkNotNullParameter((Object)biomeSource, (String)"biomeSource");
        Optional optional = structureSet.method_40230();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
        class_5321 class_53212 = (class_5321)OptionalsKt.getOrNull((Optional)optional);
        class_2960 setLocation = class_53212 != null ? class_53212.method_29177() : null;
        if (!GrowssethWorldPreset.isGrowssethPresetFromOverworldBiomeSource(biomeSource)) return false;
        class_2960 class_29602 = setLocation;
        if (Intrinsics.areEqual((Object)(class_29602 != null ? class_29602.method_12836() : null), (Object)"growsseth")) return true;
        if (!WorldPresetConfig.disableTrialChambers) return false;
        if (!Intrinsics.areEqual((Object)setLocation, (Object)UtilsKt.resLocVanilla("trial_chambers"))) return false;
        return true;
    }

    public final boolean shouldDisableVillagePresets(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return GrowssethWorldPreset.isGrowssethPreset(server);
    }

    @NotNull
    public final class_7145 build(@NotNull class_7891<class_7145> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_7871 noiseSettings = ctx.method_46799(class_7924.field_41243);
        class_7871 biomes = ctx.method_46799(class_7924.field_41236);
        class_7871 multiNoiseBiomeSourceParameterLists = ctx.method_46799(class_7924.field_43089);
        class_7871 dimTypes = ctx.method_46799(class_7924.field_41241);
        class_6880.class_6883 overworldType = dimTypes.method_46747(class_7134.field_37666);
        class_6880.class_6883 netherType = dimTypes.method_46747(class_7134.field_37667);
        class_6880.class_6883 endType = dimTypes.method_46747(class_7134.field_37668);
        class_6880.class_6883 overworldBiomeParameters = multiNoiseBiomeSourceParameterLists.method_46747(GrowssethModBiomeSources.GROWSSETH_OVERWORLD_SETTINGS);
        class_6880.class_6883 overworldNoiseSettings = noiseSettings.method_46747(class_5284.field_26355);
        class_5363 overworldStem = new class_5363((class_6880)overworldType, (class_2794)new class_3754((class_1966)class_4766.method_49503((class_6880)((class_6880)overworldBiomeParameters)), (class_6880)overworldNoiseSettings));
        class_6880.class_6883 netherBiomeParameters = multiNoiseBiomeSourceParameterLists.method_46747(class_8198.field_42991);
        class_6880.class_6883 netherNoiseSettings = noiseSettings.method_46747(class_5284.field_26357);
        class_5363 netherStem = new class_5363((class_6880)netherType, (class_2794)new class_3754((class_1966)class_4766.method_49503((class_6880)((class_6880)netherBiomeParameters)), (class_6880)netherNoiseSettings));
        class_6880.class_6883 endNoiseSettings = noiseSettings.method_46747(class_5284.field_26358);
        class_5363 endStem = new class_5363((class_6880)endType, (class_2794)new class_3754((class_1966)class_2169.method_46680((class_7871)biomes), (class_6880)endNoiseSettings));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)class_5363.field_25412, (Object)overworldStem), TuplesKt.to((Object)class_5363.field_25413, (Object)netherStem), TuplesKt.to((Object)class_5363.field_25414, (Object)endStem)};
        return new class_7145(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    public final void bootstrapNoiseBiomeSourcesSettings(@NotNull class_7891<class_8197> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_7871 biomes = ctx.method_46799(class_7924.field_41236);
        ctx.method_46838(GrowssethModBiomeSources.GROWSSETH_OVERWORLD_SETTINGS, (Object)new class_8197(class_8197.class_5305.field_34499, biomes));
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$0(class_6544.class_6547 it) {
        return false;
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$2(class_6880 parametersHolder) {
        Optional optional = parametersHolder.method_40230();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"unwrapKey(...)");
        return Intrinsics.areEqual((Object)OptionalsKt.getOrNull((Optional)optional), GrowssethModBiomeSources.GROWSSETH_OVERWORLD_SETTINGS);
    }

    private static final Boolean isGrowssethPresetFromOverworldBiomeSource$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset$Callbacks;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "onServerStarted", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/class_3222;", "player", "onServerPlayerJoin", "(Lnet/minecraft/class_3222;Lnet/minecraft/server/MinecraftServer;)V", "ruins-of-growsseth"})
    @SourceDebugExtension(value={"SMAP\nGrowssethWorldPreset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowssethWorldPreset.kt\ncom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset$Callbacks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1863#2,2:148\n*S KotlinDebug\n*F\n+ 1 GrowssethWorldPreset.kt\ncom/ruslan/growsseth/worldgen/worldpreset/GrowssethWorldPreset$Callbacks\n*L\n41#1:148,2\n*E\n"})
    public static final class Callbacks {
        @NotNull
        public static final Callbacks INSTANCE = new Callbacks();

        private Callbacks() {
        }

        public final void onServerStarted(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (GrowssethWorldPreset.isGrowssethPreset(server)) {
                List<WorldPresetConfig.StructureInWorldConfig> list = WorldPresetConfig.getAll();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAll(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WorldPresetConfig.StructureInWorldConfig cfg = (WorldPresetConfig.StructureInWorldConfig)element$iv;
                    boolean bl = false;
                    FixedStructureGeneration fixedStructureGeneration = fixedStructureGeneration;
                    class_3218 class_32182 = server.method_30002();
                    Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"overworld(...)");
                    String string = cfg.structureId + "_grworldgen";
                    class_2338 class_23382 = new class_2338(cfg.x, cfg.y, cfg.z);
                    class_2960 class_29602 = cfg.structureId();
                    Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"structureId(...)");
                    class_2470 class_24702 = cfg.rotation;
                    Intrinsics.checkNotNullExpressionValue((Object)class_24702, (String)"rotation");
                    FixedStructureGeneration.DefaultImpls.register$default((FixedStructureGeneration)fixedStructureGeneration, (class_3218)class_32182, (String)string, (class_2338)class_23382, (class_2960)class_29602, (class_2470)class_24702, (boolean)false, (int)32, null);
                }
            }
        }

        public final void onServerPlayerJoin(@NotNull class_3222 player, @NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (GrowssethWorldPreset.isGrowssethPreset(server)) {
                if (LocationNotifListener.Companion.getLoaded()) {
                    NetworkingUtilsKt.sendPacket$default((class_3222)player, (class_8710)new PlacesInfoPacket(LocationNotifListener.Companion.getLOCALISED_PLACES_DATA()), null, (int)2, null);
                } else {
                    throw new Exception("Location notification listener not loaded!");
                }
            }
        }
    }
}

