/*
 * Decompiled with CFR 0.152.
 */
package clgd.enchanting_table;

import it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedSet;
import java.util.Set;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9290;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.NotNull;

public class EnchantingScreenHandler
extends class_1707 {
    public static final int MAX_BOOKSHELVES = 18;
    private static final int ENCHANTING_ITEM_SLOT = 11;
    private static final int LAPIS_SLOT = 13;
    private static final int BOOKSHELF_SLOT = 15;
    private static final List<Integer> OUTPUT_SLOTS = new ArrayList<Integer>(List.of(28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43));
    private static final class_1799 emptyEnchantSlot = new class_1799((class_1935)class_1802.field_8529, 1);
    private static final class_3414 enchantFailSound = class_3417.field_14833;
    private final int bookshelves;
    private final class_1277 inventory;
    private final class_5455 manager;
    private final class_1657 player;

    public EnchantingScreenHandler(int syncId, class_1661 playerInventory, class_1937 world, class_2338 pos) {
        super(class_3917.field_17327, syncId, playerInventory, (class_1263)new class_1277(54), 6);
        this.bookshelves = this.getBookshelves(world, pos);
        this.manager = world.method_30349();
        this.player = playerInventory.field_7546;
        this.inventory = (class_1277)this.method_7629();
        class_1799 filler = new class_1799((class_1935)class_1802.field_8871, 1);
        filler.method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)""));
        filler.method_57379(class_9334.field_56400, (Object)new class_10712(true, (SequencedSet)ReferenceSortedSets.emptySet()));
        for (int i = 0; i < 54; ++i) {
            if (i == 11 || i == 13 || i == 15) continue;
            this.inventory.method_5447(i, filler.method_7972());
        }
        class_1799 b = new class_1799((class_1935)class_1802.field_8536, Math.max(this.bookshelves, 1));
        b.method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)("Available Bookshelves: " + this.bookshelves)));
        this.inventory.method_5447(15, b);
        for (int slot : OUTPUT_SLOTS) {
            this.inventory.method_5447(slot, emptyEnchantSlot.method_7972());
        }
    }

    private int getBookshelves(class_1937 world, class_2338 pos) {
        int z;
        int x;
        class_6862 powerTransmitter = class_3481.field_44473;
        class_6862 powerProvider = class_3481.field_44472;
        int[][] cardinalDirections = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};
        int[][] diagonalDirections = new int[][]{{1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        int bookshelves = 0;
        for (int[] dir : cardinalDirections) {
            x = dir[0];
            z = dir[1];
            if (world.method_8320(pos.method_10069(x, 0, z)).method_26164(powerTransmitter) && world.method_8320(pos.method_10069(x * 2, 0, z * 2)).method_26164(powerProvider)) {
                ++bookshelves;
            }
            if (!world.method_8320(pos.method_10069(x, 1, z)).method_26164(powerTransmitter) || !world.method_8320(pos.method_10069(x * 2, 1, z * 2)).method_26164(powerProvider)) continue;
            ++bookshelves;
        }
        for (int[] dir : diagonalDirections) {
            x = dir[0];
            z = dir[1];
            if (world.method_8320(pos.method_10069(x, 0, z)).method_26164(powerTransmitter)) {
                if (world.method_8320(pos.method_10069(x * 2, 0, z)).method_26164(powerProvider)) {
                    ++bookshelves;
                }
                if (world.method_8320(pos.method_10069(x, 0, z * 2)).method_26164(powerProvider)) {
                    ++bookshelves;
                }
                if (world.method_8320(pos.method_10069(x * 2, 0, z * 2)).method_26164(powerProvider)) {
                    ++bookshelves;
                }
            }
            if (!world.method_8320(pos.method_10069(x, 1, z)).method_26164(powerTransmitter)) continue;
            if (world.method_8320(pos.method_10069(x * 2, 1, z)).method_26164(powerProvider)) {
                ++bookshelves;
            }
            if (world.method_8320(pos.method_10069(x, 1, z * 2)).method_26164(powerProvider)) {
                ++bookshelves;
            }
            if (!world.method_8320(pos.method_10069(x * 2, 1, z * 2)).method_26164(powerProvider)) continue;
            ++bookshelves;
        }
        return bookshelves;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (slotIndex < 0) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        if (OUTPUT_SLOTS.contains(slotIndex)) {
            this.processEnchantSelection(slotIndex);
        }
        if (slotIndex < 54 && slotIndex != 11 && slotIndex != 13) {
            return;
        }
        if (actionType == class_1713.field_7794) {
            this.processQuickMove(slotIndex, button, actionType, player);
            return;
        }
        if (actionType == class_1713.field_7790 || actionType == class_1713.field_7791) {
            this.processPickup(slotIndex, button, actionType, player);
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    private void processPickup(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (slotIndex != 11 && slotIndex != 13) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        class_1799 cursorStack = this.method_34255();
        if (cursorStack.method_7960()) {
            super.method_7593(slotIndex, button, actionType, player);
            this.fillEnchantmentSlots();
            return;
        }
        if (slotIndex == 11 && cursorStack.method_31573(class_3489.field_48310)) {
            super.method_7593(slotIndex, button, actionType, player);
            this.fillEnchantmentSlots();
            return;
        }
        if (slotIndex == 13 && cursorStack.method_31574(class_1802.field_8759)) {
            super.method_7593(slotIndex, button, actionType, player);
            this.fillEnchantmentSlots();
        }
    }

    private void processQuickMove(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        int max;
        if (slotIndex == 11 || slotIndex == 13) {
            super.method_7593(slotIndex, button, actionType, player);
            this.fillEnchantmentSlots();
            return;
        }
        class_1799 enchantStackBefore = this.inventory.method_5438(11).method_7972();
        class_1799 lapisStackBefore = this.inventory.method_5438(13).method_7972();
        if (!enchantStackBefore.method_7960() && !lapisStackBefore.method_7960()) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
        if (!enchantStackBefore.method_7960()) {
            class_1799 lapisStackAfter = this.inventory.method_5438(13).method_7972();
            if (lapisStackAfter.method_31574(class_1802.field_8759)) {
                this.fillEnchantmentSlots();
                return;
            }
            player.method_7270(lapisStackAfter);
            this.inventory.method_5447(13, class_1799.field_8037.method_7972());
            return;
        }
        class_1799 enchantStackAfter = this.inventory.method_5438(11).method_7972();
        if (enchantStackAfter.method_31573(class_3489.field_48310)) {
            this.fillEnchantmentSlots();
            return;
        }
        if (!enchantStackAfter.method_31574(class_1802.field_8759)) {
            player.method_7270(enchantStackAfter);
            this.inventory.method_5447(11, class_1799.field_8037.method_7972());
            this.fillEnchantmentSlots();
            return;
        }
        if (lapisStackBefore.method_7960()) {
            this.inventory.method_5447(13, enchantStackAfter);
            this.inventory.method_5447(11, class_1799.field_8037.method_7972());
            this.fillEnchantmentSlots();
            return;
        }
        if (!class_1799.method_31577((class_1799)lapisStackBefore, (class_1799)enchantStackAfter)) {
            player.method_7270(enchantStackAfter);
            this.inventory.method_5447(11, class_1799.field_8037.method_7972());
            this.fillEnchantmentSlots();
            return;
        }
        int total = lapisStackBefore.method_7947() + enchantStackAfter.method_7947();
        if (total > (max = Math.min(lapisStackBefore.method_7914(), total))) {
            lapisStackBefore.method_7939(max);
            enchantStackAfter.method_7939(total - max);
        } else {
            lapisStackBefore.method_7939(total);
            enchantStackAfter.method_7939(0);
        }
        player.method_7270(enchantStackAfter);
        this.inventory.method_5447(11, class_1799.field_8037.method_7972());
        this.fillEnchantmentSlots();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        player.method_7270(this.inventory.method_5438(11));
        player.method_7270(this.inventory.method_5438(13));
    }

    private void processEnchantSelection(int slot) {
        class_1799 lapisStack;
        if (this.inventory.method_5438(slot).method_31574(class_1802.field_8529)) {
            return;
        }
        int index = OUTPUT_SLOTS.indexOf(slot);
        class_1799 enchantStack = this.inventory.method_5438(11);
        List<class_6880<class_1887>> enchantments = this.getAvailableEnchantments(enchantStack);
        class_6880<class_1887> applyEnchant = enchantments.get(index);
        int enchantLevel = 1;
        Set itemEnchants = enchantStack.method_58657().method_57534();
        if (itemEnchants.contains(applyEnchant)) {
            enchantLevel += enchantStack.method_58657().method_57536(applyEnchant);
        }
        int lapis = (lapisStack = this.inventory.method_5438(13)).method_7960() ? 0 : lapisStack.method_7947();
        int requiredLevels = this.getRequiredLevels((class_1887)applyEnchant.comp_349(), enchantLevel);
        int requiredBooks = this.getRequiredBooks((class_1887)applyEnchant.comp_349(), enchantLevel);
        int requiredLapis = this.getRequiredLapis((class_1887)applyEnchant.comp_349(), enchantLevel);
        if (enchantLevel > ((class_1887)applyEnchant.comp_349()).method_8183()) {
            this.player.method_17356(enchantFailSound, class_3419.field_61058, 0.5f, 0.5f);
            return;
        }
        if (this.bookshelves < requiredBooks) {
            this.player.method_17356(enchantFailSound, class_3419.field_61058, 0.5f, 0.5f);
            return;
        }
        if (this.player.field_7520 < requiredLevels) {
            this.player.method_17356(enchantFailSound, class_3419.field_61058, 0.5f, 0.5f);
            return;
        }
        if (lapis < requiredLapis) {
            this.player.method_17356(enchantFailSound, class_3419.field_61058, 0.5f, 0.5f);
            return;
        }
        if (!lapisStack.method_7960()) {
            lapisStack.method_7934(requiredLapis);
            this.inventory.method_5447(13, lapisStack);
        }
        this.player.method_7316(-requiredLevels);
        class_9304 enchants = (class_9304)enchantStack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        class_9304.class_9305 builder = new class_9304.class_9305(enchants);
        builder.method_57550(applyEnchant, enchantLevel);
        enchantStack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
        this.player.method_17356(class_3417.field_15119, class_3419.field_61058, 1.0f, 1.0f);
        this.fillEnchantmentSlots();
    }

    private void fillEnchantmentSlots() {
        class_1799 enchantStack = this.inventory.method_5438(11);
        if (enchantStack.method_7960()) {
            for (int slot : OUTPUT_SLOTS) {
                this.inventory.method_5447(slot, emptyEnchantSlot.method_7972());
            }
            return;
        }
        List<class_6880<class_1887>> enchantments = this.getAvailableEnchantments(enchantStack);
        Set itemEnchantments = enchantStack.method_58657().method_57534();
        for (int i = 0; i < enchantments.size(); ++i) {
            class_1799 lapisStack;
            class_6880<class_1887> registryEntry = enchantments.get(i);
            class_1887 enchant = (class_1887)registryEntry.comp_349();
            int enchantLevel = 1;
            if (itemEnchantments.contains(registryEntry)) {
                enchantLevel += enchantStack.method_58657().method_57536(registryEntry);
            }
            boolean isCompatible = true;
            for (class_6880 itemEnchant : itemEnchantments) {
                if (!((class_1887)itemEnchant.comp_349()).comp_2688().method_40241(registryEntry)) continue;
                isCompatible = ((class_1887)itemEnchant.comp_349()).equals((Object)enchant);
                break;
            }
            int lapis = (lapisStack = this.inventory.method_5438(13)).method_7960() ? 0 : lapisStack.method_7947();
            int requiredlevels = this.getRequiredLevels(enchant, enchantLevel);
            int requiredbooks = this.getRequiredBooks(enchant, enchantLevel);
            int requiredlapis = this.getRequiredLapis(enchant, enchantLevel);
            class_1799 enchantedBook = new class_1799((class_1935)class_1802.field_8598, 1);
            enchantedBook.method_7978(registryEntry, Math.min(enchantLevel, enchant.method_8183()));
            enchantedBook.method_57379(class_9334.field_56400, (Object)class_10712.field_56318.method_67215(class_9334.field_49643, true));
            enchantedBook.method_57379(class_9334.field_50239, (Object)class_1887.method_8179(registryEntry, (int)Math.min(enchantLevel, enchant.method_8183())).method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
            if (enchantLevel > enchant.method_8183()) {
                enchantedBook.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)"Max Level").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1061)))));
            } else if (!isCompatible) {
                enchantedBook.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)"Incompatible").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1061)))));
            } else {
                class_2583 levelStyle = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(this.player.field_7520 >= requiredlevels ? class_124.field_1060 : class_124.field_1054);
                class_2583 bookshelfStyle = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(this.bookshelves >= requiredbooks ? class_124.field_1060 : class_124.field_1054);
                class_2583 lapisStyle = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(lapis >= requiredbooks ? class_124.field_1060 : class_124.field_1054);
                enchantedBook.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43469((String)"container.enchant.level.many", (Object[])new Object[]{requiredlevels}).method_10862(levelStyle), class_2561.method_43470((String)(requiredbooks + " ")).method_10852((class_2561)class_2561.method_43471((String)"block.minecraft.bookshelf")).method_10862(bookshelfStyle), class_2561.method_43469((String)"container.enchant.lapis.many", (Object[])new Object[]{requiredlapis}).method_10862(lapisStyle))));
            }
            this.inventory.method_5447(OUTPUT_SLOTS.get(i).intValue(), enchantedBook);
        }
    }

    private List<class_6880<class_1887>> getAvailableEnchantments(@NotNull class_1799 item) {
        ArrayList<class_6880<class_1887>> enchantmentList = new ArrayList<class_6880<class_1887>>();
        this.manager.method_46759(class_7924.field_41265).ifPresent(enchantments -> {
            for (class_6880 enchant : enchantments.method_42017().toList()) {
                if (!enchant.method_40220(class_9636.field_51547) || !((class_1887)enchant.comp_349()).method_8192(item)) continue;
                enchantmentList.add(enchant);
            }
        });
        return enchantmentList;
    }

    private int getRequiredLapis(class_1887 enchant, int level) {
        return level;
    }

    private int getRequiredBooks(@NotNull class_1887 enchant, int level) {
        int baseCost = enchant.method_58446();
        int costPerLevel = Math.min((1 + enchant.method_8182(2) - enchant.method_8182(1)) / 2, (18 - baseCost) / enchant.method_8183());
        return baseCost + (level - 1) * costPerLevel;
    }

    private int getRequiredLevels(@NotNull class_1887 enchant, int level) {
        int baseCost = (enchant.method_58446() + enchant.method_8182(1)) / 2;
        int costPerLevel = (1 + enchant.method_8182(2) - enchant.method_8182(1)) / 2;
        return baseCost + (level - 1) * costPerLevel;
    }

    static {
        emptyEnchantSlot.method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)""));
        emptyEnchantSlot.method_57379(class_9334.field_56400, (Object)new class_10712(true, (SequencedSet)ReferenceSortedSets.emptySet()));
    }
}

