/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.block.power.entity;

import cz.blackdragoncz.lostdepths.block.entity.base.BaseEnergyContainerBlockEntity;
import cz.blackdragoncz.lostdepths.block.power.entity.NurostarCableBlockEntity;
import cz.blackdragoncz.lostdepths.energy.PowerCable;
import cz.blackdragoncz.lostdepths.energy.SyncedEnergyStorage;
import cz.blackdragoncz.lostdepths.init.LostdepthsModBlockEntities;
import cz.blackdragoncz.lostdepths.init.LostdepthsModItems;
import cz.blackdragoncz.lostdepths.util.NothingNullByDefault;
import cz.blackdragoncz.lostdepths.world.inventory.NurostarGeneratorMenu;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class NurostarGeneratorBlockEntity
extends BaseEnergyContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    public static final ItemStack FIRST_SLOT = new ItemStack((ItemLike)LostdepthsModItems.INFUSED_CRYSTAL.get());
    public static final ItemStack SECOND_SLOT = new ItemStack((ItemLike)Items.f_42451_);
    private static final ItemStack THIRD_WASTE_SLOT = new ItemStack((ItemLike)LostdepthsModItems.CELESTIAL_REDSTONE.get());
    private static final int MaxCapacity = 100000;
    private static final int MaxExtract = 800;
    private static final int EnergyPerConsume = 50000;
    private static final int ConsumeTickTime = 2;
    private static final int EnergyPerWaste = 80000;
    private int tickCounter = 0;
    private int usedEnergy = 0;

    public NurostarGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LostdepthsModBlockEntities.NUROSTAR_GENRATOR.get(), pos, state);
    }

    public boolean updateTick() {
        ++this.tickCounter;
        if (this.tickCounter == 2) {
            this.tickCounter = 0;
            return true;
        }
        return false;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        if (compound.m_128441_("currentWaste")) {
            this.usedEnergy = compound.m_128451_("usedEnergy");
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("usedEnergy", this.usedEnergy);
    }

    @Override
    protected SyncedEnergyStorage createEnergyStorage() {
        return new SyncedEnergyStorage((BlockEntity)this, 100000, 50000, 800);
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, NurostarGeneratorBlockEntity blockEntity) {
        IEnergyStorage energyStorage;
        LazyOptional energyOpt;
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.updateTick()) {
            ItemStack firstSlot = (ItemStack)blockEntity.getItems().get(0);
            ItemStack secondSlot = (ItemStack)blockEntity.getItems().get(1);
            ItemStack wasteSlot = (ItemStack)blockEntity.getItems().get(2);
            if (!firstSlot.m_41619_() && !secondSlot.m_41619_() && blockEntity.energyStorage.receiveEnergy(50000, true) == 50000) {
                firstSlot.m_41764_(firstSlot.m_41613_() - 1);
                secondSlot.m_41764_(secondSlot.m_41613_() - 1);
                blockEntity.m_6836_(0, firstSlot);
                blockEntity.m_6836_(1, secondSlot);
                blockEntity.energyStorage.receiveEnergy(50000, false);
            }
            if (wasteSlot.m_41613_() < wasteSlot.m_41741_() && blockEntity.usedEnergy >= 80000) {
                blockEntity.usedEnergy -= 80000;
                if (wasteSlot.m_41720_() != THIRD_WASTE_SLOT.m_41720_()) {
                    blockEntity.m_6836_(2, new ItemStack((ItemLike)THIRD_WASTE_SLOT.m_41720_(), 1));
                } else {
                    wasteSlot.m_41764_(wasteSlot.m_41613_() + 1);
                    blockEntity.m_6836_(2, wasteSlot);
                }
            }
        }
        ArrayList<BlockEntity> energyEntities = new ArrayList<BlockEntity>();
        for (ItemStack direction : Direction.values()) {
            BlockEntity entity2 = level.m_7702_(blockPos.m_121945_((Direction)direction));
            if (entity2 == null) continue;
            if (entity2 instanceof NurostarCableBlockEntity) {
                NurostarCableBlockEntity cableEntity = (NurostarCableBlockEntity)entity2;
                PowerCable cable = cableEntity.getThisCable();
                if (cable == null) continue;
                cable.collectEnergy(energyEntities);
                continue;
            }
            if (entity2 instanceof NurostarGeneratorBlockEntity || !(energyOpt = entity2.getCapability(ForgeCapabilities.ENERGY)).isPresent() || !(energyStorage = (IEnergyStorage)energyOpt.orElse(null)).canReceive() || energyEntities.contains(entity2)) continue;
            energyEntities.add(entity2);
        }
        energyEntities.removeIf(entity -> entity instanceof NurostarGeneratorBlockEntity);
        if (energyEntities.isEmpty()) {
            return;
        }
        int energyReceiversCount = energyEntities.size();
        int energyAllocated = blockEntity.energyStorage.extractEnergy(800, true);
        int energyPerReceiver = energyAllocated / energyReceiversCount;
        int consumedEnergy = 0;
        for (BlockEntity energyEntity : energyEntities) {
            if (energyEntity instanceof NurostarGeneratorBlockEntity || !(energyOpt = energyEntity.getCapability(ForgeCapabilities.ENERGY)).isPresent()) continue;
            energyStorage = (IEnergyStorage)energyOpt.orElse(null);
            consumedEnergy += energyStorage.receiveEnergy(energyPerReceiver, false);
        }
        if (consumedEnergy == 0) {
            return;
        }
        blockEntity.usedEnergy += consumedEnergy;
        blockEntity.energyStorage.extractEnergy(consumedEnergy, false);
    }

    public Component m_5446_() {
        return this.m_6820_();
    }

    protected Component m_6820_() {
        return Component.m_237113_((String)"Nurostar Generator");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new NurostarGeneratorMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    public int m_6643_() {
        return 3;
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.UP) {
            return new int[]{0, 1};
        }
        return new int[]{2};
    }

    public boolean m_7155_(int i, ItemStack stack, @Nullable Direction dir) {
        if (i == 0 && stack.m_41720_() == FIRST_SLOT.m_41720_() && dir == Direction.UP) {
            return true;
        }
        return i == 1 && stack.m_41720_() == SECOND_SLOT.m_41720_() && dir == Direction.UP;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction dir) {
        return stack.m_41720_() == THIRD_WASTE_SLOT.m_41720_();
    }

    public boolean m_7013_(int i, ItemStack stack) {
        if (i == 0 && stack.m_41720_() == FIRST_SLOT.m_41720_()) {
            return true;
        }
        return i == 1 && stack.m_41720_() == SECOND_SLOT.m_41720_();
    }

    @Override
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

