/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.client;

import cz.blackdragoncz.lostdepths.LostdepthsMod;
import cz.blackdragoncz.lostdepths.client.renderer.block.AlloyWorkstationRenderer;
import cz.blackdragoncz.lostdepths.client.renderer.block.GalacticWorkstationRenderer;
import cz.blackdragoncz.lostdepths.client.renderer.block.MetaCollectorBlockEntityRenderer;
import cz.blackdragoncz.lostdepths.init.LostdepthsModBlockEntities;
import cz.blackdragoncz.lostdepths.init.LostdepthsModItems;
import cz.blackdragoncz.lostdepths.util.ICustomHoldPose;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientSide {
    public static final ClientSide INSTANCE = new ClientSide();
    private static int elapsedTicks = 0;
    private static int securityClearance = 0;
    private static char groupClearance = (char)48;
    private static int clearanceTime = 600;
    private static ResourceLocation JEI = LostdepthsMod.rl("textures/gui/jei_handler.png");

    public void setup() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerEntityRenderers);
        MinecraftForge.EVENT_BUS.addListener(this::renderPlayer);
        MinecraftForge.EVENT_BUS.addListener(this::renderOverlay);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(this::onClientTick);
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.type != TickEvent.Type.CLIENT || event.side != LogicalSide.CLIENT) {
            return;
        }
        ++elapsedTicks;
        if (clearanceTime > 0) {
            --clearanceTime;
        } else {
            securityClearance = 0;
        }
    }

    public static void setSecurityClearance(int clearance, char groupclearance) {
        securityClearance = clearance;
        groupClearance = groupclearance;
        clearanceTime = 600;
    }

    private Item getSecurityClearance(int clearance, char groupClearance) {
        return switch (groupClearance) {
            case 'a' -> {
                switch (clearance) {
                    case 1: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_1.get();
                    }
                    case 2: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_2.get();
                    }
                    case 3: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_3.get();
                    }
                    case 4: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_4.get();
                    }
                    case 5: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_5.get();
                    }
                    case 6: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_6.get();
                    }
                }
                yield null;
            }
            case 'b' -> {
                switch (clearance) {
                    case 1: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_A.get();
                    }
                    case 2: {
                        yield (Item)LostdepthsModItems.SECURITY_PASS_A.get();
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    public void renderOverlay(RenderGuiEvent.Post event) {
        GuiGraphics g = event.getGuiGraphics();
        if (securityClearance == 0) {
            return;
        }
        Item clearanceItem = this.getSecurityClearance(securityClearance, groupClearance);
        if (clearanceItem == null) {
            return;
        }
        int screenPositionCenterX = g.m_280182_() - g.m_280182_() / 4;
        int barWidth = 98;
        int barHeight = 9;
        int segmentWidth = 14;
        int segmentCount = barWidth / segmentWidth;
        float timePercent = (float)clearanceTime / 600.0f;
        int currentSegmentCount = (int)Math.ceil(timePercent * (float)segmentCount);
        int barLeftPos = screenPositionCenterX - barWidth / 2;
        int barRightPos = screenPositionCenterX + barWidth / 2;
        g.m_280163_(JEI, barLeftPos, g.m_280206_() - barHeight - 1, 154.0f, 227.0f, barWidth, barHeight, 256, 256);
        g.m_280163_(JEI, barLeftPos, g.m_280206_() - barHeight - 1, 154.0f, 239.0f, currentSegmentCount * segmentWidth, barHeight, 256, 256);
        g.m_280163_(JEI, barLeftPos - 7, g.m_280206_() - 11, 135.0f, 237.0f, 7, 11, 256, 256);
        g.m_280163_(JEI, barRightPos, g.m_280206_() - 11, 145.0f, 237.0f, 7, 11, 256, 256);
        g.m_280480_(new ItemStack((ItemLike)clearanceItem), screenPositionCenterX - 8, g.m_280206_() - 11 - 8 - 8);
    }

    public static int getElapsedTicks() {
        return elapsedTicks;
    }

    public void renderPlayer(RenderPlayerEvent.Pre event) {
        if (this.isCustomHoldPose(event.getEntity(), InteractionHand.MAIN_HAND)) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
        }
        if (this.isCustomHoldPose(event.getEntity(), InteractionHand.OFF_HAND)) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102815_ = HumanoidModel.ArmPose.SPYGLASS;
        }
    }

    private boolean isCustomHoldPose(Player player, InteractionHand hand) {
        return player.m_21120_(hand).m_41720_() instanceof ICustomHoldPose;
    }

    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)LostdepthsModBlockEntities.GALACTIC_WORKSTATION.get()), GalacticWorkstationRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)LostdepthsModBlockEntities.ALLOY_WORKSTATION.get()), AlloyWorkstationRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)LostdepthsModBlockEntities.INFUSED_SIGN.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)LostdepthsModBlockEntities.INFUSED_HANGING_SIGN.get()), HangingSignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)LostdepthsModBlockEntities.META_COLLECTOR.get()), MetaCollectorBlockEntityRenderer::new);
    }
}

