/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.client.jei;

import com.mojang.blaze3d.platform.InputConstants;
import cz.blackdragoncz.lostdepths.client.gui.AllGuiTextures;
import cz.blackdragoncz.lostdepths.client.gui.IGuiWrapper;
import cz.blackdragoncz.lostdepths.client.gui.element.GuiElement;
import cz.blackdragoncz.lostdepths.client.gui.element.IProgressInfoHandler;
import cz.blackdragoncz.lostdepths.client.jei.IRecipeViewerRecipeType;
import cz.blackdragoncz.lostdepths.client.jei.LostDepthsJEI;
import cz.blackdragoncz.lostdepths.client.jei.NOOPDrawable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class BaseRecipeCategory<RECIPE>
extends AbstractContainerEventHandler
implements IRecipeCategory<RECIPE>,
IGuiWrapper {
    private static final IDrawable BASIC_SLOT = BaseRecipeCategory.asDrawable(AllGuiTextures.JEI_SLOT);
    private static final IDrawable CHANCE_SLOT = BaseRecipeCategory.asDrawable(AllGuiTextures.JEI_CHANCE_SLOT);
    private final List<GuiElement> guiElements = new ArrayList<GuiElement>();
    private final Component component;
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final RecipeType<RECIPE> recipeType;
    private final IDrawable icon;
    private final int xOffset;
    private final int yOffset;
    @Nullable
    private ITickTimer timer;

    protected static IDrawable createIcon(IGuiHelper helper, IRecipeViewerRecipeType<?> recipeType) {
        ItemStack stack = recipeType.iconStack();
        if (stack.m_41619_()) {
            ResourceLocation icon = recipeType.icon();
            if (icon == null) {
                throw new IllegalStateException("Expected recipe type to have either an icon stack or an icon location");
            }
            return helper.drawableBuilder(icon, 0, 0, 18, 18).setTextureSize(18, 18).build();
        }
        return helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    protected BaseRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<RECIPE> recipeType) {
        this(helper, LostDepthsJEI.recipeType(recipeType), recipeType.getTextComponent(), BaseRecipeCategory.createIcon(helper, recipeType), recipeType.xOffset(), recipeType.yOffset(), recipeType.width(), recipeType.height());
    }

    protected BaseRecipeCategory(IGuiHelper helper, RecipeType<RECIPE> recipeType, Component component, IDrawable icon, int xOffset, int yOffset, int width, int height) {
        this.recipeType = recipeType;
        this.component = component;
        this.guiHelper = helper;
        this.icon = icon;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.background = new NOOPDrawable(width, height);
    }

    public boolean handleInput(RECIPE recipe, double mouseX, double mouseY, InputConstants.Key input) {
        return switch (input.m_84868_()) {
            default -> throw new IncompatibleClassChangeError();
            case InputConstants.Type.KEYSYM -> this.m_7933_(input.m_84873_(), -1, 0);
            case InputConstants.Type.SCANCODE -> this.m_7933_(-1, input.m_84873_(), 0);
            case InputConstants.Type.MOUSE -> this.m_6375_(mouseX, mouseY, input.m_84873_());
        };
    }

    @Override
    public int getGuiLeft() {
        return this.xOffset;
    }

    @Override
    public int getGuiTop() {
        return this.yOffset;
    }

    @Override
    public int getXSize() {
        return this.background.getWidth();
    }

    @Override
    public int getYSize() {
        return this.background.getHeight();
    }

    @Override
    public Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    public RecipeType<RECIPE> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.component;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.guiElements;
    }

    protected IProgressInfoHandler getSimpleProgressTimer() {
        if (this.timer == null) {
            this.timer = this.guiHelper.createTickTimer(20, 20, false);
        }
        return () -> (double)this.timer.getValue() / 20.0;
    }

    public static IDrawable getRenderedSlot() {
        return BASIC_SLOT;
    }

    public static IDrawable getRenderedSlot(float chance) {
        if (chance == 1.0f) {
            return BASIC_SLOT;
        }
        return CHANCE_SLOT;
    }

    protected static IDrawable asDrawable(final AllGuiTextures texture) {
        return new IDrawable(){

            public int getWidth() {
                return texture.width;
            }

            public int getHeight() {
                return texture.height;
            }

            public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
                texture.render(graphics, xOffset, yOffset);
            }
        };
    }
}

