/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.entity.projectile;

import cz.blackdragoncz.lostdepths.util.BasicTeleporter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public abstract class EntityFluxBall
extends ThrowableProjectile {
    private ResourceKey<Level> dim;
    private double teleportX;
    private double teleportY;
    private double teleportZ;

    public EntityFluxBall(EntityType<? extends EntityFluxBall> type, Level world) {
        super(type, world);
    }

    public EntityFluxBall(Level world, LivingEntity entityLiving) {
        super(EntityType.f_20477_, entityLiving, world);
    }

    public EntityFluxBall(Level world, double x, double y, double z) {
        super(EntityType.f_20477_, x, y, z, world);
    }

    public void setFlux(ResourceKey<Level> dim, double x, double y, double z) {
        this.dim = dim;
        this.teleportX = x;
        this.teleportY = y;
        this.teleportZ = z;
    }

    protected void m_5790_(EntityHitResult result) {
        if (!this.m_9236_().f_46443_) {
            if (this.m_19749_() != null && result.m_82443_() != this.m_19749_() && result.m_82443_() instanceof Player) {
                Entity hitEntity = result.m_82443_();
                if (hitEntity.m_9236_().m_46472_() != this.dim) {
                    ServerLevel level = hitEntity.m_20194_().m_129880_(this.dim);
                    if (level == null) {
                        this.m_142687_(Entity.RemovalReason.KILLED);
                        return;
                    }
                    BasicTeleporter basicTeleporter = new BasicTeleporter(level, this.teleportX, this.teleportY, this.teleportZ);
                    hitEntity.changeDimension(level, (ITeleporter)basicTeleporter);
                } else {
                    hitEntity.m_6021_(this.teleportX, this.teleportY, this.teleportZ);
                }
                this.m_5496_(SoundEvents.f_12553_, 3.0f, 1.0f);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected float m_7139_() {
        return 0.05f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() - 0.25, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
    }
}

