/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.util;

import cz.blackdragoncz.lostdepths.client.CustomRayTraceResult;
import cz.blackdragoncz.lostdepths.util.EntityImmaterial;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface ICustomRaytrace {
    public static final Predicate<Entity> ANTI_IMMATERIAL = entity -> !(entity instanceof EntityImmaterial);

    default public CustomRayTraceResult simpleBlockTrace(Level world, LivingEntity entityFrom, int distance) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, (Entity)entityFrom, distance, null, 0, 1, false, null, 1, 1, 0.3f, null));
    }

    default public CustomRayTraceResult forwardTrace(Level world, Entity entityFrom, int distance) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, entityFrom, distance, null, 0, 0, true, null, 1, 1, 0.3f, null));
    }

    default public CustomRayTraceResult immaterialTrace(Level world, LivingEntity entityFrom, int distance) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, (Entity)entityFrom, distance, null, 0, 2, false, null, 1, 1, 0.3f, null));
    }

    default public CustomRayTraceResult entityTrace(Level world, LivingEntity entityFrom, int distance, Class<? extends Entity> entityclass) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, (Entity)entityFrom, distance, null, 0, 1, false, entityclass, 1, 1, 0.3f, ANTI_IMMATERIAL));
    }

    default public CustomRayTraceResult entitiesTrace(Level world, LivingEntity entityFrom, int distance, Class<? extends Entity> entityclass, int count) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, (Entity)entityFrom, distance, null, 0, 1, false, entityclass, count, 1, 0.3f, ANTI_IMMATERIAL));
    }

    default public CustomRayTraceResult standardFXTrace(Level world, LivingEntity entityFrom, int distance, ParticleOptions trailFX, Class<? extends Entity> stopEntityType) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, (Entity)entityFrom, distance, trailFX, 3, 1, false, stopEntityType, 1, 1, 0.3f, ANTI_IMMATERIAL));
    }

    default public CustomRayTraceResult forcedDistanceTrace(Level world, Entity entityFrom, int distance) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, entityFrom, distance, null, 0, 1, true, null, 1, 1, 0.3f, null));
    }

    default public CustomRayTraceResult complexTrace(Level world, LivingEntity entityFrom, int distance, ParticleOptions trailFX, int trailDelay, int blockType, boolean forceResult, Class<? extends Entity> stopEntityType, int lookYOffset, float expand) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, (Entity)entityFrom, distance, trailFX, trailDelay, blockType, forceResult, stopEntityType, 1, lookYOffset, expand, ANTI_IMMATERIAL));
    }

    default public CustomRayTraceResult predicateTrace(Level world, LivingEntity entityFrom, int distance, ParticleOptions trailFX, int trailDelay, int blockType, boolean forceResult, Class<? extends Entity> stopEntityType, int lookYOffset, float expand, Predicate<Entity> entityPredicate) {
        return (CustomRayTraceResult)((Object)this.doRayTrace(world, (Entity)entityFrom, distance, trailFX, trailDelay, blockType, forceResult, stopEntityType, 1, lookYOffset, expand, entityPredicate));
    }

    default public ICustomRaytrace doRayTrace(Level world, Entity entityFrom, int distance, ParticleOptions trailFX, int trailDelay, int stopBlock, boolean forceResult, Class<? extends Entity> stopEntityType, int maxEntity, int lookYOffset, float inaccuracy, Predicate<Entity> entityPredicate) {
        Vec3 vec = entityFrom.m_20154_();
        Vec3 modifiedLookPosition = lookYOffset != 0 ? new Vec3(entityFrom.m_20185_(), entityFrom.m_20186_() + 1.5, entityFrom.m_20189_()) : new Vec3(entityFrom.m_20185_(), entityFrom.m_20186_(), entityFrom.m_20189_());
        CustomRayTraceResult result = new CustomRayTraceResult();
        for (int i = 0; i <= distance; ++i) {
            Vec3 nextPos = modifiedLookPosition.m_82520_(vec.f_82479_ * (double)i, vec.f_82480_ * (double)i, vec.f_82481_ * (double)i);
            AABB blockBox = new AABB(nextPos.f_82479_ - 0.1, nextPos.f_82480_ - 0.1, nextPos.f_82481_ - 0.1, nextPos.f_82479_ + 0.1, nextPos.f_82480_ + 0.1, nextPos.f_82481_ + 0.1).m_82400_((double)inaccuracy);
            if (trailFX != null && i >= trailDelay && !world.f_46443_) {
                Vec3 centerVec = new Vec3(blockBox.f_82288_ + (blockBox.f_82291_ - blockBox.f_82288_) * 0.5, blockBox.f_82289_ + (blockBox.f_82292_ - blockBox.f_82289_) * 0.5, blockBox.f_82290_ + (blockBox.f_82293_ - blockBox.f_82290_) * 0.5);
                ((ServerLevel)world).m_8767_(trailFX, centerVec.f_82479_, centerVec.f_82480_, centerVec.f_82481_, 3, 0.0, 0.0, 0.0, 0.0);
            }
            if (stopEntityType != null) {
                for (Entity nearEntity : world.m_45976_(stopEntityType, blockBox)) {
                    if (nearEntity.m_20148_().equals(entityFrom.m_20148_()) || entityPredicate != null && !entityPredicate.test(nearEntity)) continue;
                    result.addResultEntity(nearEntity);
                    if (maxEntity <= 0 || result.getResultEntities().size() < maxEntity) continue;
                    result.setResultPos(nextPos);
                    return (ICustomRaytrace)((Object)result);
                }
            }
            BlockPos nextBlockPos = new BlockPos((Vec3i)new BlockPos((int)Math.floor(nextPos.f_82479_), (int)Math.floor(nextPos.f_82480_), (int)Math.floor(nextPos.f_82481_)));
            BlockState stateResult = world.m_8055_(nextBlockPos);
            FluidState fluidStateResult = world.m_6425_(nextBlockPos);
            if (stopBlock <= 0 || world.m_46859_(nextBlockPos) || !stateResult.m_280296_() && !fluidStateResult.m_76170_() && stopBlock != 2) continue;
            Vec3 referencePos = modifiedLookPosition.m_82520_(vec.f_82479_ * (double)(i - 1), vec.f_82480_ * (double)(i - 1), vec.f_82481_ * (double)(i - 1));
            result.setResultPos(referencePos);
            result.setGrabbedVector(nextPos);
            return (ICustomRaytrace)((Object)result);
        }
        if (forceResult) {
            Vec3 forcedVec = modifiedLookPosition.m_82520_(vec.f_82479_ * (double)distance, vec.f_82480_ * (double)distance, vec.f_82481_ * (double)distance);
            result.setResultPos(forcedVec);
            return (ICustomRaytrace)((Object)result);
        }
        return result.isModified() ? (ICustomRaytrace)((Object)result) : null;
    }
}

