/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.world.inventory;

import cz.blackdragoncz.lostdepths.client.gui.ContainerWrapper;
import cz.blackdragoncz.lostdepths.recipe.LDShapedRecipe;
import cz.blackdragoncz.lostdepths.util.IEnergyAccessor;
import cz.blackdragoncz.lostdepths.world.inventory.CustomResultSlot;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkstationMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    protected final Player player;
    protected final Level level;
    protected final ContainerLevelAccess access;
    protected final BlockEntity blockEntity;
    protected CraftingContainer craftingContainer;
    protected ContainerWrapper containerWrapper;
    protected final int slotCount;
    protected final RecipeType<LDShapedRecipe> recipeType;
    protected final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    protected final ResultContainer resultContainer = new ResultContainer();
    protected final IEnergyAccessor energyAccessor;
    protected final int requiredEnergyToCraft;

    protected AbstractWorkstationMenu(@Nullable MenuType<?> menuType, int slotCount, RecipeType<LDShapedRecipe> recipeType, int id, Inventory inv, FriendlyByteBuf extraData, int requiredEnergyToCraft) {
        super(menuType, id);
        IEnergyAccessor ea;
        BlockEntity blockEntity;
        this.player = inv.f_35978_;
        this.requiredEnergyToCraft = requiredEnergyToCraft;
        this.level = this.player.m_9236_();
        this.slotCount = slotCount;
        this.recipeType = recipeType;
        BlockPos pos = extraData.m_130135_();
        this.access = ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)pos);
        this.blockEntity = this.level.m_7702_(pos);
        if (this.blockEntity instanceof CraftingContainer) {
            this.craftingContainer = (CraftingContainer)this.blockEntity;
        }
        this.energyAccessor = (blockEntity = this.blockEntity) instanceof IEnergyAccessor ? (ea = (IEnergyAccessor)blockEntity) : null;
        this.containerWrapper = new ContainerWrapper((Container)this.craftingContainer){

            @Override
            public void m_6596_() {
                super.m_6596_();
                AbstractWorkstationMenu.this.m_6199_(this);
            }
        };
    }

    public abstract CustomResultSlot<LDShapedRecipe> getResultSlot();

    public void m_6199_(Container container) {
        this.access.m_39292_((level, blockPos) -> {
            if (!level.f_46443_) {
                ItemStack resultItem;
                ServerPlayer serverplayer = (ServerPlayer)this.player;
                Optional foundRecipe = level.m_7465_().m_44015_(this.recipeType, (Container)this.craftingContainer, level);
                ItemStack stack = ItemStack.f_41583_;
                if (foundRecipe.isPresent() && (resultItem = ((LDShapedRecipe)foundRecipe.get()).assemble(this.craftingContainer, level.m_9598_())).m_246617_(level.m_246046_())) {
                    stack = resultItem;
                }
                this.resultContainer.m_6836_(0, stack);
                this.m_150404_(0, stack);
                serverplayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, stack));
            }
        });
    }

    public boolean hasFoundRecipe() {
        return this.getResultSlot().m_6657_();
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.slotCount - 1) {
                if (!this.m_38903_(itemstack1, this.slotCount - 1, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (!this.m_38903_(itemstack1, 0, this.slotCount - 1, false)) {
                if (index < this.slotCount - 1 + 27 ? !this.m_38903_(itemstack1, this.slotCount - 1 + 27, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, this.slotCount - 1, this.slotCount - 1 + 27, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.f_38839_.get(i);
                if (slot.m_5857_(itemstack = slot.m_7993_()) && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_5852_(itemstack);
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_5852_(itemstack);
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(stack)) {
                    if (stack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(stack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public boolean m_6875_(Player player) {
        return AbstractContainerMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public IEnergyAccessor getEnergyAccessor() {
        return this.energyAccessor;
    }

    public int getRequiredEnergyToCraft() {
        return this.requiredEnergyToCraft;
    }
}

