/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.block.entity;

import cz.blackdragoncz.lostdepths.energy.SyncedEnergyStorage;
import cz.blackdragoncz.lostdepths.init.LostDepthsModRecipeType;
import cz.blackdragoncz.lostdepths.init.LostdepthsModSounds;
import cz.blackdragoncz.lostdepths.recipe.CompressingRecipe;
import cz.blackdragoncz.lostdepths.world.inventory.CompressorGUIMenu;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompressorBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final List<LostDepthsModRecipeType<CraftingContainer, CompressingRecipe>> recipeTypes;
    private final int craftTickTime;
    private final int requiredStackSize;
    private final int energyCost;
    private CompressingRecipe currentRecipe;
    private int currentCraftTime = 0;
    private Item lastUsedRecipeItem;
    private boolean canProcess = false;
    public boolean tickRecipeCheck = true;
    private EnergyStorage energyStorage;

    protected AbstractCompressorBlockEntity(List<LostDepthsModRecipeType<CraftingContainer, CompressingRecipe>> recipeTypes, int craftTickTime, int requiredStackSize, int energyStorageCapacity, int energyCost, int maxEnergyTransfer, BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.recipeTypes = recipeTypes;
        this.requiredStackSize = requiredStackSize;
        this.craftTickTime = craftTickTime;
        this.energyCost = energyCost;
        if (energyStorageCapacity > 0 && energyCost > 0) {
            this.energyStorage = new SyncedEnergyStorage((BlockEntity)this, energyStorageCapacity, maxEnergyTransfer);
        }
    }

    protected AbstractCompressorBlockEntity(List<LostDepthsModRecipeType<CraftingContainer, CompressingRecipe>> recipeTypes, int craftTickTime, int requiredStackSize, BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        this(recipeTypes, craftTickTime, requiredStackSize, 0, 0, 0, blockEntityType, blockPos, blockState);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        if (!this.m_59631_(compound)) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
        if (compound.m_128441_("energyStorage") && this.energyStorage != null) {
            this.energyStorage.deserializeNBT(compound.m_128423_("energyStorage"));
        }
        this.currentCraftTime = compound.m_128451_("currentTickTime");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        }
        if (this.energyStorage != null) {
            compound.m_128365_("energyStorage", this.energyStorage.serializeNBT());
        }
        compound.m_128405_("currentTickTime", this.currentCraftTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        return index != 1 && this.findRecipe(stack) != null;
    }

    public int[] m_7071_(Direction direction) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.stacks = list;
    }

    @NotNull
    public AbstractContainerMenu m_6555_(int id, @NotNull Inventory inventory) {
        return new CompressorGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[facing.ordinal()].cast();
        }
        if (this.energyStorage != null && !this.f_58859_ && capability == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public CompressingRecipe findRecipe(ItemStack stack) {
        for (LostDepthsModRecipeType<CraftingContainer, CompressingRecipe> recipeType : this.recipeTypes) {
            List recipes = this.f_58857_.m_7465_().m_44013_(recipeType);
            for (CompressingRecipe recipe : recipes) {
                if (recipe.getInput().m_41720_() != stack.m_41720_()) continue;
                return recipe;
            }
        }
        return null;
    }

    private void tryInitializeRecipe(ItemStack stack) {
        if (stack.m_41613_() < this.requiredStackSize) {
            this.canProcess = false;
            return;
        }
        if (this.currentRecipe == null || stack.m_41720_() != this.lastUsedRecipeItem) {
            this.currentRecipe = this.findRecipe(stack);
            this.lastUsedRecipeItem = stack.m_41720_();
            this.currentCraftTime = 0;
        }
        if (this.currentRecipe != null) {
            this.canProcess = true;
        }
    }

    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        if (index == 0) {
            this.tryInitializeRecipe(stack);
        }
    }

    public int getCraftTickTime() {
        return this.craftTickTime;
    }

    public int getCurrentCraftTime() {
        return this.currentCraftTime;
    }

    public void setCurrentCraftTime(int currentCraftTime) {
        this.currentCraftTime = currentCraftTime;
    }

    public void incrementCurrentCraftTime() {
        ++this.currentCraftTime;
    }

    public int getRequiredStackSize() {
        return this.requiredStackSize;
    }

    public CompressingRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public void markForRecipeCheck() {
        this.tickRecipeCheck = true;
    }

    private boolean canFitOutput() {
        ItemStack stack = this.m_8020_(1);
        return stack.m_41613_() + this.requiredStackSize <= stack.m_41741_();
    }

    private boolean checkCompatOutput() {
        ItemStack outputStack = this.m_8020_(1);
        if (outputStack.m_41619_()) {
            return true;
        }
        return this.currentRecipe.getOutput().m_41720_() == outputStack.m_41720_();
    }

    public boolean haveEnergy() {
        return this.energyStorage == null || this.energyStorage.getEnergyStored() >= this.energyCost;
    }

    public boolean canProcess() {
        return this.canProcess && this.canFitOutput() && this.checkCompatOutput();
    }

    private void playFinishSound(Level level, BlockPos blockPos) {
        level.m_5594_(null, blockPos, (SoundEvent)LostdepthsModSounds.MANUFACTURE_MACHINE.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, AbstractCompressorBlockEntity blockEntity) {
        if (blockEntity.tickRecipeCheck) {
            blockEntity.tickRecipeCheck = false;
            blockEntity.tryInitializeRecipe(blockEntity.m_8020_(0));
        }
        boolean changed = false;
        CompressingRecipe recipe = blockEntity.getCurrentRecipe();
        if (recipe != null && blockEntity.canProcess()) {
            if (blockEntity.haveEnergy()) {
                blockEntity.incrementCurrentCraftTime();
                EnergyStorage energyStorage = blockEntity.getEnergyStorage();
                if (energyStorage != null) {
                    energyStorage.extractEnergy(blockEntity.getEnergyCost(), false);
                }
            }
            if (blockEntity.getCurrentCraftTime() >= blockEntity.getCraftTickTime()) {
                blockEntity.setCurrentCraftTime(0);
                blockEntity.playFinishSound(level, blockPos);
                ItemStack itemStack = blockEntity.m_8020_(0).m_41777_();
                itemStack.m_41774_(blockEntity.getRequiredStackSize());
                blockEntity.m_6836_(0, itemStack);
                itemStack = new ItemStack((ItemLike)recipe.getOutput().m_41720_(), blockEntity.m_8020_(1).m_41613_() + 1);
                blockEntity.m_6836_(1, itemStack);
            }
            changed = true;
        } else if (blockEntity.getCurrentCraftTime() != 0) {
            blockEntity.setCurrentCraftTime(0);
            changed = true;
        }
        if (changed) {
            level.m_7260_(blockPos, blockState, blockState, 3);
        }
    }
}

