/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.block.power.entity;

import cz.blackdragoncz.lostdepths.block.power.PowerManager;
import cz.blackdragoncz.lostdepths.energy.ICableInterface;
import cz.blackdragoncz.lostdepths.energy.PowerCable;
import cz.blackdragoncz.lostdepths.init.LostdepthsModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class NurostarCableBlockEntity
extends BlockEntity
implements ICableInterface {
    private PowerCable thisCable;

    public NurostarCableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LostdepthsModBlockEntities.NUROSTAR_CABLE.get(), pos, state);
    }

    public void updateEnergySides() {
        this.thisCable.clearForgeEnergies();
        this.thisCable.clearSideCables();
        for (Direction dir : Direction.values()) {
            IEnergyStorage energyStorage;
            BlockEntity sideEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
            if (sideEntity == null) continue;
            if (sideEntity instanceof NurostarCableBlockEntity) {
                NurostarCableBlockEntity sideCableEntity = (NurostarCableBlockEntity)sideEntity;
                this.thisCable.setSideCable(dir, sideCableEntity);
                continue;
            }
            LazyOptional energyCapOpt = sideEntity.getCapability(ForgeCapabilities.ENERGY);
            if (!energyCapOpt.isPresent() || !(energyStorage = (IEnergyStorage)energyCapOpt.orElse(null)).canReceive()) continue;
            this.thisCable.addForgeEnergy(sideEntity);
        }
    }

    public PowerCable getThisCable() {
        return this.thisCable;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.m_58898_()) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.thisCable = PowerManager.INSTANCE.addCable(this);
        this.updateEnergySides();
    }

    public void onChunkUnloaded() {
        if (this.m_58898_() & !this.f_58857_.m_5776_()) {
            PowerManager.INSTANCE.removeCable(this);
        }
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        super.m_7651_();
        PowerManager.INSTANCE.removeCable(this);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void syncData(ServerPlayer player) {
        player.f_8906_.m_9829_(this.m_58483_());
    }

    public void syncData() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        LevelChunk chunk = this.f_58857_.m_46745_(this.m_58899_());
        ((ServerChunkCache)this.f_58857_.m_7726_()).f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_9829_(this.m_58483_()));
    }

    @Override
    public PowerCable getPowerCable() {
        return this.thisCable;
    }
}

