/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.client.jei.machines;

import cz.blackdragoncz.lostdepths.LostdepthsMod;
import cz.blackdragoncz.lostdepths.client.jei.BaseRecipeCategory;
import cz.blackdragoncz.lostdepths.client.jei.IRecipeViewerRecipeType;
import cz.blackdragoncz.lostdepths.recipe.CompressingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GenericCompressorRecipeCategory
extends BaseRecipeCategory<CompressingRecipe> {
    private final int neededStackSize;
    private final boolean requiresPower;
    private final int arrowWidth = 24;
    private final int arrowHeight = 17;
    private final IDrawable slot;
    protected final IDrawable arrowBg;
    protected final IDrawable powerIcon;
    protected final IDrawableAnimated arrow;

    public GenericCompressorRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<CompressingRecipe> recipeType, int neededStackSize, boolean requiresPower) {
        super(helper, recipeType);
        this.neededStackSize = neededStackSize;
        this.requiresPower = requiresPower;
        this.slot = helper.getSlotDrawable();
        this.arrowBg = helper.drawableBuilder(new ResourceLocation("textures/gui/container/furnace.png"), 80, 35, 24, 17).build();
        this.arrow = helper.drawableBuilder(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.powerIcon = helper.drawableBuilder(LostdepthsMod.rl("textures/gui/jei_handler.png"), 224, 96, 15, 14).build();
    }

    public void draw(CompressingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.slot.draw(guiGraphics, 35, 1);
        this.slot.draw(guiGraphics, 95, 1);
        int w = this.getBackground().getWidth();
        int h = this.getBackground().getHeight();
        this.arrowBg.draw(guiGraphics, w / 2 - 12 + 1, h / 2 - 8 + 1);
        this.arrow.draw(guiGraphics, w / 2 - 12, h / 2 - 8);
        if (this.requiresPower) {
            this.powerIcon.draw(guiGraphics, 8, h / 2 - 7);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompressingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 2).addItemStack(new ItemStack((ItemLike)recipe.getInput().m_41720_(), this.neededStackSize));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 2).addItemStack(recipe.getOutput());
    }
}

