/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.energy;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.EnergyStorage;

public class SyncedEnergyStorage
extends EnergyStorage {
    private final BlockEntity blockEntity;

    public SyncedEnergyStorage(BlockEntity blockEntity, int capacity) {
        super(capacity);
        this.blockEntity = blockEntity;
    }

    public SyncedEnergyStorage(BlockEntity blockEntity, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.blockEntity = blockEntity;
    }

    public SyncedEnergyStorage(BlockEntity blockEntity, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.blockEntity = blockEntity;
    }

    public SyncedEnergyStorage(BlockEntity blockEntity, int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
        this.blockEntity = blockEntity;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int val = super.receiveEnergy(maxReceive, simulate);
        if (!simulate && maxReceive != 0) {
            this.updateClients();
        }
        return val;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int val = super.extractEnergy(maxExtract, simulate);
        if (!simulate && maxExtract != 0) {
            this.updateClients();
        }
        return val;
    }

    private void updateClients() {
        Level level = this.blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos blockPos = this.blockEntity.m_58899_();
        BlockState state = level.m_8055_(blockPos);
        this.blockEntity.m_6596_();
        this.blockEntity.m_58904_().m_7260_(blockPos, state, state, 2);
    }
}

