/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.item.tool;

import cz.blackdragoncz.lostdepths.init.LostdepthsModSounds;
import cz.blackdragoncz.lostdepths.util.BasicTeleporter;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class Fluxocron
extends Item {
    public Fluxocron() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    private void teleport(ItemStack stack, Player player, Level level, double x, double y, double z) {
        BasicTeleporter basicTeleporter;
        int i;
        ListTag listTag;
        CompoundTag entityList = stack.m_41698_("EntityList");
        if (entityList.m_128441_("MobList")) {
            listTag = (ListTag)entityList.m_128423_("MobList");
            for (i = 0; i < listTag.size(); ++i) {
                ServerLevel l;
                UUID entityUUID = NbtUtils.m_129233_((Tag)listTag.get(i));
                Entity entity = null;
                Iterator iterator = player.m_20194_().m_129785_().iterator();
                while (iterator.hasNext() && (entity = (l = (ServerLevel)iterator.next()).m_8791_(entityUUID)) == null) {
                }
                if (entity == null) continue;
                if (entity.m_9236_() == level) {
                    entity.m_6021_(x, y, z);
                    continue;
                }
                basicTeleporter = new BasicTeleporter((ServerLevel)player.m_9236_(), x, y, z);
                entity.changeDimension((ServerLevel)player.m_9236_(), (ITeleporter)basicTeleporter);
            }
        }
        if (entityList.m_128441_("PlayerList")) {
            listTag = (ListTag)entityList.m_128423_("PlayerList");
            for (i = 0; i < listTag.size(); ++i) {
                UUID playerUUID = NbtUtils.m_129233_((Tag)listTag.get(i));
                ServerPlayer playerToPort = player.m_20194_().m_6846_().m_11259_(playerUUID);
                if (playerToPort == null) continue;
                if (playerToPort.m_9236_() == level) {
                    playerToPort.m_6021_(x, y, z);
                } else {
                    basicTeleporter = new BasicTeleporter((ServerLevel)player.m_9236_(), x, y, z);
                    playerToPort.changeDimension((ServerLevel)player.m_9236_(), (ITeleporter)basicTeleporter);
                }
                player.m_6330_(SoundEvents.f_11852_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41782_()) {
            stack.m_41784_().m_128405_("mode_style", 0);
        }
        if (player.m_6047_()) {
            int newMode = stack.m_41784_().m_128451_("mode_style") + 1;
            if (newMode >= FluxocronMode.values().length) {
                newMode = 0;
            }
            stack.m_41784_().m_128405_("mode_style", newMode);
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a76Mode Switched: " + FluxocronMode.values()[newMode].getName())), true);
            }
        } else {
            FluxocronMode mode = FluxocronMode.values()[stack.m_41784_().m_128451_("mode_style")];
            switch (mode) {
                case MarkLocation: {
                    stack.m_41784_().m_128347_("flux_pos_x", player.m_20185_());
                    stack.m_41784_().m_128347_("flux_pos_y", player.m_20186_());
                    stack.m_41784_().m_128347_("flux_pos_z", player.m_20189_());
                    stack.m_41784_().m_128359_("flux_dimension", level.m_46472_().m_135782_().toString());
                    if (level.f_46443_) break;
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a75Coordinate marked for fluxation."), true);
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)LostdepthsModSounds.FLUX_MARK.get(), SoundSource.MASTER, 2.0f, 1.0f);
                    break;
                }
                case MarkEntity: {
                    break;
                }
                case TeleportToYou: {
                    if (!level.f_46443_) {
                        this.teleport(stack, player, level, player.m_20185_(), player.m_20186_(), player.m_20189_());
                    }
                    player.m_36335_().m_41524_(((ItemStack)ar.m_19095_()).m_41720_(), 10);
                    break;
                }
                case TeleportToMarkedLocation: {
                    if (!level.f_46443_) {
                        if (stack.m_41784_().m_128441_("flux_dimension")) {
                            double goX = stack.m_41784_().m_128459_("flux_pos_x");
                            double goY = stack.m_41784_().m_128459_("flux_pos_y");
                            double goZ = stack.m_41784_().m_128459_("flux_pos_z");
                            this.teleport(stack, player, level, goX, goY, goZ);
                        } else {
                            player.m_5661_((Component)Component.m_237113_((String)"\u00a74Position not set!"), true);
                        }
                    }
                    player.m_36335_().m_41524_(((ItemStack)ar.m_19095_()).m_41720_(), 10);
                    break;
                }
                case Clear: {
                    stack.m_41749_("EntityList");
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a75Fluxocron cleared"), true);
                }
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand hand) {
        IntArrayTag uuidTag;
        ListTag listTag;
        FluxocronMode mode;
        if (!stack.m_41782_()) {
            stack.m_41784_().m_128405_("mode_style", 0);
        }
        if ((mode = FluxocronMode.values()[stack.m_41784_().m_128451_("mode_style")]) != FluxocronMode.MarkEntity) {
            return InteractionResult.PASS;
        }
        CompoundTag entitiesTag = stack.m_41698_("EntityList");
        if (interactionTarget instanceof Mob) {
            Mob interactionMob = (Mob)interactionTarget;
            interactionMob.m_21530_();
            if (entitiesTag.m_128441_("MobList")) {
                listTag = (ListTag)entitiesTag.m_128423_("MobList");
                if (listTag.contains((Object)(uuidTag = NbtUtils.m_129226_((UUID)interactionMob.m_20148_())))) {
                    return InteractionResult.PASS;
                }
                listTag.add((Object)uuidTag);
            } else {
                listTag = new ListTag();
                listTag.add((Object)NbtUtils.m_129226_((UUID)interactionMob.m_20148_()));
                entitiesTag.m_128365_("MobList", (Tag)listTag);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a75Mob added to Fluxocron"), true);
        }
        if (interactionTarget instanceof Player) {
            Player interactionPlayer = (Player)interactionTarget;
            if (entitiesTag.m_128441_("PlayerList")) {
                listTag = (ListTag)entitiesTag.m_128423_("PlayerList");
                if (!listTag.contains((Object)(uuidTag = NbtUtils.m_129226_((UUID)interactionPlayer.m_20148_())))) {
                    listTag.add((Object)uuidTag);
                }
            } else {
                listTag = new ListTag();
                listTag.add((Object)NbtUtils.m_129226_((UUID)interactionPlayer.m_20148_()));
                entitiesTag.m_128365_("PlayerList", (Tag)listTag);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a75Player added to Fluxocron"), true);
        }
        player.m_21008_(hand, stack);
        player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)LostdepthsModSounds.FLUX_MARK.get(), SoundSource.MASTER, 2.0f, 1.0f);
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        list.add((Component)Component.m_237113_((String)"\u00a75Mass Teleports Entities To Your/Marked Position"));
        if (stack.m_41782_()) {
            int playerCount;
            FluxocronMode style = FluxocronMode.values()[stack.m_41784_().m_128451_("mode_style")];
            list.add((Component)Component.m_237113_((String)("\u00a7dMode: " + style.getName())));
            if (stack.m_41783_().m_128441_("flux_dimension")) {
                list.add((Component)Component.m_237113_((String)"\u00a72Flux Marked:"));
                ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(stack.m_41783_().m_128461_("flux_dimension")));
                list.add((Component)Component.m_237113_((String)"\u00a72Dimension: ").m_7220_((Component)Component.m_237115_((String)("\u00a72" + dim.m_135782_().m_214298_()))));
                list.add((Component)Component.m_237113_((String)("\u00a72X: " + stack.m_41783_().m_128451_("flux_pos_x"))));
                list.add((Component)Component.m_237113_((String)("\u00a72Y: " + stack.m_41783_().m_128451_("flux_pos_y"))));
                list.add((Component)Component.m_237113_((String)("\u00a72Z: " + stack.m_41783_().m_128451_("flux_pos_z"))));
            } else {
                list.add((Component)Component.m_237113_((String)"\u00a7cNO FLUX LOCATION SET"));
            }
            CompoundTag entitiesTag = stack.m_41698_("EntityList");
            int mobCount = entitiesTag.m_128441_("MobList") ? ((ListTag)entitiesTag.m_128423_("MobList")).size() : 0;
            int n = playerCount = entitiesTag.m_128441_("PlayerList") ? ((ListTag)entitiesTag.m_128423_("PlayerList")).size() : 0;
            if (mobCount > 0 || playerCount > 0) {
                list.add((Component)Component.m_237113_((String)" "));
                list.add((Component)Component.m_237113_((String)"\u00a72Entities added:"));
                if (mobCount > 0) {
                    list.add((Component)Component.m_237113_((String)(" \u00a72Mobs: " + mobCount)));
                }
                if (playerCount > 0) {
                    list.add((Component)Component.m_237113_((String)(" \u00a72Players: " + playerCount)));
                }
            }
        }
    }

    public static enum FluxocronMode {
        MarkLocation("Mark Location"),
        MarkEntity("Mark Entity"),
        TeleportToYou("Teleport To You"),
        TeleportToMarkedLocation("Teleport To Marked Location"),
        Clear("Clear everything");

        private final String name;

        private FluxocronMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

