/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.network;

import cz.blackdragoncz.lostdepths.LostdepthsMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LostdepthsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LostdepthsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.x = message.data.x;
                    variables.y = message.data.y;
                    variables.z = message.data.z;
                    variables.modidShieldTimer = message.data.modidShieldTimer;
                    variables.dragonDown = message.data.dragonDown;
                    variables.dragonUp = message.data.dragonUp;
                    variables.flux_x = message.data.flux_x;
                    variables.flux_y = message.data.flux_y;
                    variables.flux_z = message.data.flux_z;
                    variables.flux_dim = message.data.flux_dim;
                    variables.flux_set = message.data.flux_set;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;
        public double modidShieldTimer = 0.0;
        public boolean dragonDown = false;
        public boolean dragonUp = false;
        public double flux_x = 0.0;
        public double flux_y = 0.0;
        public double flux_z = 0.0;
        public String flux_dim = "\"\"";
        public boolean flux_set = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                LostdepthsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("x", this.x);
            nbt.m_128347_("y", this.y);
            nbt.m_128347_("z", this.z);
            nbt.m_128347_("modidShieldTimer", this.modidShieldTimer);
            nbt.m_128379_("dragonDown", this.dragonDown);
            nbt.m_128379_("dragonUp", this.dragonUp);
            nbt.m_128347_("flux_x", this.flux_x);
            nbt.m_128347_("flux_y", this.flux_y);
            nbt.m_128347_("flux_z", this.flux_z);
            nbt.m_128359_("flux_dim", this.flux_dim);
            nbt.m_128379_("flux_set", this.flux_set);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.x = nbt.m_128459_("x");
            this.y = nbt.m_128459_("y");
            this.z = nbt.m_128459_("z");
            this.modidShieldTimer = nbt.m_128459_("modidShieldTimer");
            this.dragonDown = nbt.m_128471_("dragonDown");
            this.dragonUp = nbt.m_128471_("dragonUp");
            this.flux_x = nbt.m_128459_("flux_x");
            this.flux_y = nbt.m_128459_("flux_y");
            this.flux_z = nbt.m_128459_("flux_z");
            this.flux_dim = nbt.m_128461_("flux_dim");
            this.flux_set = nbt.m_128471_("flux_set");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("lostdepths", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.x = original.x;
            clone.y = original.y;
            clone.z = original.z;
            clone.modidShieldTimer = original.modidShieldTimer;
            clone.dragonDown = original.dragonDown;
            clone.dragonUp = original.dragonUp;
            clone.flux_x = original.flux_x;
            clone.flux_y = original.flux_y;
            clone.flux_z = original.flux_z;
            clone.flux_dim = original.flux_dim;
            clone.flux_set = original.flux_set;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

