/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cz.blackdragoncz.lostdepths.util.Pair;
import java.util.Random;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ProcessingOutput {
    private static final Gson GSON = new Gson();
    public static final ProcessingOutput EMPTY = new ProcessingOutput(ItemStack.f_41583_, 1.0f);
    private static final Random r = new Random();
    private final ItemStack stack;
    private final float chance;
    private Pair<ResourceLocation, Integer> compatDatagenOutput;

    public ProcessingOutput(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public ProcessingOutput(Pair<ResourceLocation, Integer> item, float chance) {
        this.stack = ItemStack.f_41583_;
        this.compatDatagenOutput = item;
        this.chance = chance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack rollOutput() {
        int outputAmount = this.stack.m_41613_();
        for (int roll = 0; roll < this.stack.m_41613_(); ++roll) {
            if (!(r.nextFloat() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack out = this.stack.m_41777_();
        out.m_41764_(outputAmount);
        return out;
    }

    public JsonElement serialize() {
        int count;
        JsonObject json = new JsonObject();
        ResourceLocation resourceLocation = this.compatDatagenOutput == null ? ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()) : this.compatDatagenOutput.getFirst();
        json.addProperty("item", resourceLocation.toString());
        int n = count = this.compatDatagenOutput == null ? this.stack.m_41613_() : this.compatDatagenOutput.getSecond().intValue();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.m_41782_()) {
            json.add("nbt", JsonParser.parseString((String)this.stack.m_41783_().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ProcessingOutput deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("ProcessingOutput must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        float chance = GsonHelper.m_13900_((JsonObject)json, (String)"chance") ? GsonHelper.m_13915_((JsonObject)json, (String)"chance") : 1.0f;
        ItemStack itemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.m_41751_(TagParser.m_129359_((String)(element.isJsonObject() ? GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ProcessingOutput(itemstack, chance);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.getStack());
        buf.writeFloat(this.getChance());
    }

    public static ProcessingOutput read(FriendlyByteBuf buf) {
        return new ProcessingOutput(buf.m_130267_(), buf.readFloat());
    }
}

