/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.block.power;

import cz.blackdragoncz.lostdepths.block.base.Block6WayConnections;
import cz.blackdragoncz.lostdepths.block.power.entity.NurostarCableBlockEntity;
import cz.blackdragoncz.lostdepths.init.LostdepthsModBlockEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class NurostarCableBlock
extends Block6WayConnections
implements SimpleWaterloggedBlock,
EntityBlock {
    private static final VoxelShape CABLE = NurostarCableBlock.m_49796_((double)5.25, (double)5.25, (double)5.25, (double)10.75, (double)10.75, (double)10.75);
    private static final VoxelShape[] MULTIPART = new VoxelShape[]{NurostarCableBlock.m_49796_((double)5.25, (double)5.25, (double)0.0, (double)10.75, (double)10.75, (double)6.0), NurostarCableBlock.m_49796_((double)10.75, (double)5.25, (double)5.25, (double)16.0, (double)10.75, (double)10.75), NurostarCableBlock.m_49796_((double)5.25, (double)5.25, (double)10.75, (double)10.75, (double)10.75, (double)16.0), NurostarCableBlock.m_49796_((double)0.0, (double)5.25, (double)5.25, (double)5.25, (double)10.75, (double)10.75), NurostarCableBlock.m_49796_((double)5.25, (double)10.75, (double)5.25, (double)10.75, (double)16.0, (double)10.75), NurostarCableBlock.m_49796_((double)5.25, (double)0.0, (double)5.25, (double)10.75, (double)6.0, (double)10.75)};

    public NurostarCableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(3.0f, 4.0f), 4.0f, 4.0f, 4.0f);
    }

    @Override
    public boolean canConnectTo(Level world, BlockPos currentPos, Direction neighborDirection) {
        BlockPos neighborPos = currentPos.m_121945_(neighborDirection);
        BlockState neighborState = world.m_8055_(neighborPos);
        BlockState ownState = world.m_8055_(currentPos);
        return this.isValidConnection(neighborState, ownState, world, currentPos, neighborDirection, neighborPos);
    }

    private boolean isValidConnection(BlockState neighborState, BlockState ownState, Level world, BlockPos currentPos, Direction neighborDirection, BlockPos neighborPos) {
        Block nb = neighborState.m_60734_();
        if (nb instanceof NurostarCableBlock) {
            return true;
        }
        return this.canConnectEnergy(world, currentPos, neighborDirection);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
        if (!world.f_46443_) {
            for (Direction face : Direction.values()) {
                state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, face)));
            }
            world.m_46597_(pos, state);
            world.m_141902_(pos, (BlockEntityType)LostdepthsModBlockEntities.NUROSTAR_CABLE.get()).ifPresent(NurostarCableBlockEntity::updateEnergySides);
        }
        super.m_6861_(state, world, pos, block, neighbor, flag);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape = CABLE;
        if (blockGetter instanceof Level) {
            Level world = (Level)blockGetter;
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue() || this.canConnectEnergy(world, pos, Direction.NORTH)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[0]);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue() || this.canConnectEnergy(world, pos, Direction.EAST)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[1]);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() || this.canConnectEnergy(world, pos, Direction.SOUTH)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[2]);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue() || this.canConnectEnergy(world, pos, Direction.WEST)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[3]);
            }
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue() || this.canConnectEnergy(world, pos, Direction.UP)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[4]);
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue() || this.canConnectEnergy(world, pos, Direction.DOWN)) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)MULTIPART[5]);
            }
        }
        return voxelShape;
    }

    public boolean canConnectEnergy(Level world, BlockPos pos, Direction direction) {
        BlockEntity tile = world.m_7702_(pos.m_121945_(direction));
        if (tile == null) {
            return false;
        }
        return tile.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static Optional<Direction> getHitSide(Vec3 hit, BlockPos pos) {
        double x = hit.f_82479_ - (double)pos.m_123341_();
        double y = hit.f_82480_ - (double)pos.m_123342_();
        double z = hit.f_82481_ - (double)pos.m_123343_();
        if (x > 0.0 && x < 0.4) {
            return Optional.of(Direction.WEST);
        }
        if (x > 0.6 && x < 1.0) {
            return Optional.of(Direction.EAST);
        }
        if (z > 0.0 && z < 0.4) {
            return Optional.of(Direction.NORTH);
        }
        if (z > 0.6 && z < 1.0) {
            return Optional.of(Direction.SOUTH);
        }
        if (y > 0.6 && y < 1.0) {
            return Optional.of(Direction.UP);
        }
        if (y > 0.0 && y < 0.4) {
            return Optional.of(Direction.DOWN);
        }
        return Optional.empty();
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.BLOCKED;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new NurostarCableBlockEntity(blockPos, blockState);
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        super.m_8133_(pState, pLevel, pPos, pId, pParam);
        BlockEntity $$5 = pLevel.m_7702_(pPos);
        return $$5 == null ? false : $$5.m_7531_(pId, pParam);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity $$3 = pLevel.m_7702_(pPos);
        return $$3 instanceof MenuProvider ? (MenuProvider)$$3 : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> pServerType, BlockEntityType<E> pClientType, BlockEntityTicker<? super E> pTicker) {
        return pClientType == pServerType ? pTicker : null;
    }
}

