/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.block.security;

import cz.blackdragoncz.lostdepths.client.ClientSide;
import cz.blackdragoncz.lostdepths.item.security.SecurityPassItem;
import cz.blackdragoncz.lostdepths.util.SecurityClearanceSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SecurityClearanceBlock
extends Block {
    private final int requiredClearance;
    private final char groupClearance;

    public SecurityClearanceBlock(int requiredClearance, char groupClearance) {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(-1.0f, 3600000.0f).m_278166_(PushReaction.BLOCK));
        this.requiredClearance = requiredClearance;
        this.groupClearance = groupClearance;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.BLOCKED;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        Item item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (item instanceof SecurityPassItem) {
            SecurityPassItem securityPass = (SecurityPassItem)item;
            if (this.requiredClearance <= securityPass.getClearance() && this.groupClearance == securityPass.getGroupClearance()) {
                if (!world.m_5776_()) {
                    world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lostdepths:security_gate_clear"))), SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    world.m_7785_((double)x, (double)y, (double)z, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lostdepths:security_gate_clear"))), SoundSource.MASTER, 1.0f, 1.0f, false);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SecurityClearanceSystem.giveClearance(serverPlayer, this.requiredClearance, this.groupClearance);
                } else {
                    ClientSide.setSecurityClearance(this.requiredClearance, this.groupClearance);
                }
            } else if (!world.m_5776_()) {
                world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lostdepths:gate_error"))), SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                world.m_7785_((double)x, (double)y, (double)z, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lostdepths:gate_error"))), SoundSource.MASTER, 1.0f, 1.0f, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

