/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.energy;

import cz.blackdragoncz.lostdepths.energy.ICableInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PowerCable {
    private BlockEntity entity;
    private List<BlockEntity> forgeEnergies = new ArrayList<BlockEntity>();
    private Map<Direction, ICableInterface> sideCables = new HashMap<Direction, ICableInterface>();

    public PowerCable(BlockEntity entity) {
        this.entity = entity;
    }

    public BlockEntity getEntity() {
        return this.entity;
    }

    public void removeCable(BlockEntity cableEntity) {
        this.sideCables.entrySet().removeIf(entry -> ((ICableInterface)entry.getValue()).getPowerCable() != null && ((ICableInterface)entry.getValue()).getPowerCable().getEntity() == cableEntity);
    }

    public void clearForgeEnergies() {
        this.forgeEnergies.clear();
    }

    public void clearSideCables() {
        this.sideCables.clear();
    }

    public void setSideCable(Direction direction, ICableInterface cable) {
        this.sideCables.put(direction, cable);
    }

    public Map<Direction, ICableInterface> getSideCables() {
        return this.sideCables;
    }

    public List<BlockEntity> getForgeEnergies() {
        return this.forgeEnergies;
    }

    public void addForgeEnergy(BlockEntity forgeEnergy) {
        this.forgeEnergies.add(forgeEnergy);
    }

    public void removeForgeEnergy(BlockEntity forgeEnergy) {
        this.forgeEnergies.remove(forgeEnergy);
    }

    public void collectEnergy(List<BlockEntity> energyEntities) {
        ArrayList<PowerCable> checkedCables = new ArrayList<PowerCable>();
        checkedCables.add(this);
        LinkedList<PowerCable> queue = new LinkedList<PowerCable>();
        queue.add(this);
        while (!queue.isEmpty()) {
            PowerCable cable = (PowerCable)queue.poll();
            if (!checkedCables.contains(cable)) {
                checkedCables.add(cable);
            }
            for (ICableInterface cableInterface : cable.getSideCables().values()) {
                PowerCable sideCable = cableInterface.getPowerCable();
                if (sideCable == null || checkedCables.contains(sideCable)) continue;
                queue.add(sideCable);
            }
            for (BlockEntity energyEntity : cable.getForgeEnergies()) {
                if (energyEntities.contains(energyEntity)) continue;
                energyEntities.add(energyEntity);
            }
        }
    }
}

