/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.procedures.item;

import cz.blackdragoncz.lostdepths.init.LostdepthsModDamageTypes;
import cz.blackdragoncz.lostdepths.init.LostdepthsModItems;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class TheDestroyerSwordFunctionality {
    private static final TagKey<EntityType<?>> MUTATED_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("lostdepths", "mutated"));

    public static void execute(Entity entity, Entity sourceEntity) {
        ItemStack held;
        if (entity == null || sourceEntity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sourceEntity;
            v0 = living.m_21205_();
        } else {
            v0 = held = ItemStack.f_41583_;
        }
        if (held.m_41619_() || held.m_41720_() != LostdepthsModItems.THE_DESTROYER.get()) {
            return;
        }
        boolean isMutated = target.m_6095_().m_204039_(MUTATED_TAG);
        double fraction = isMutated ? 0.6 : 0.8;
        float amount = TheDestroyerSwordFunctionality.computeTrueDamage(target, fraction);
        if (amount <= 0.0f) {
            return;
        }
        DamageSource source = TheDestroyerSwordFunctionality.createDestroyerDamageSource(target, sourceEntity);
        target.m_6469_(source, amount);
    }

    private static float computeTrueDamage(LivingEntity target, double fraction) {
        float maxHP = Math.max(1.0f, target.m_21233_());
        double damage = Math.max(1.0, Math.min(10000.0, (double)maxHP * fraction));
        return (float)damage;
    }

    private static DamageSource createDestroyerDamageSource(LivingEntity target, Entity attacker) {
        RegistryAccess access = target.m_9236_().m_9598_();
        Registry damageTypeRegistry = access.m_175515_(Registries.f_268580_);
        Holder.Reference holder = Optional.ofNullable(damageTypeRegistry.m_203636_(LostdepthsModDamageTypes.TRUE_DAMAGE).orElse(null)).orElseGet(() -> damageTypeRegistry.m_246971_(DamageTypes.f_268433_));
        return new DamageSource((Holder)holder, attacker){

            public Component m_6157_(LivingEntity victim) {
                String key = "death.attack.destroyer";
                if (this.m_7639_() == null && this.m_7640_() == null) {
                    return victim.m_21232_() != null ? Component.m_237110_((String)(key + ".player"), (Object[])new Object[]{victim.m_5446_(), victim.m_21232_().m_5446_()}) : Component.m_237110_((String)key, (Object[])new Object[]{victim.m_5446_()});
                }
                Component killerName = (this.m_7639_() == null ? this.m_7640_() : this.m_7639_()).m_5446_();
                ItemStack item = ItemStack.f_41583_;
                Entity entity = this.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    item = living.m_21205_();
                }
                return !item.m_41619_() && item.m_41788_() ? Component.m_237110_((String)(key + ".item"), (Object[])new Object[]{victim.m_5446_(), killerName, item.m_41611_()}) : Component.m_237110_((String)key, (Object[])new Object[]{victim.m_5446_(), killerName});
            }
        };
    }
}

