/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cz.blackdragoncz.lostdepths.init.LostDepthsModRecipeType;
import cz.blackdragoncz.lostdepths.init.LostdepthsModRecipeSerializers;
import cz.blackdragoncz.lostdepths.recipe.LDRecipe;
import cz.blackdragoncz.lostdepths.recipe.LDShapedRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaMaterializerRecipe
extends LDRecipe<RecipeWrapper> {
    private NonNullList<ItemStack> items;
    private ItemStack heldItem;
    private ItemStack result;

    public MetaMaterializerRecipe(ResourceLocation id, NonNullList<ItemStack> items, ItemStack heldItem, ItemStack result) {
        super(id);
        this.items = items;
        this.heldItem = heldItem;
        this.result = result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LostdepthsModRecipeSerializers.META_MATERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)LostDepthsModRecipeType.META_MATERIALIZER.get();
    }

    public boolean matches(@NotNull RecipeWrapper inv, @NotNull Level world) {
        return super.m_5818_(inv, world);
    }

    @Override
    public boolean m_142505_() {
        return false;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static class Serializer
    implements RecipeSerializer<MetaMaterializerRecipe> {
        public MetaMaterializerRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray items = json.getAsJsonArray("items");
            NonNullList ingredients = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
            for (int i = 0; i < 3; ++i) {
                ingredients.set(i, (Object)LDShapedRecipe.itemStackFromJson(items.get(i).getAsJsonObject()));
            }
            ItemStack heldItem = LDShapedRecipe.itemStackFromJson(json.get("held_item").getAsJsonObject());
            ItemStack result = LDShapedRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new MetaMaterializerRecipe(id, (NonNullList<ItemStack>)ingredients, heldItem, result);
        }

        @Nullable
        public MetaMaterializerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
            ingredients.replaceAll(ignored -> buf.m_130267_());
            ItemStack heldItem = buf.m_130267_();
            ItemStack result = buf.m_130267_();
            return new MetaMaterializerRecipe(id, (NonNullList<ItemStack>)ingredients, heldItem, result);
        }

        public void toNetwork(FriendlyByteBuf buf, MetaMaterializerRecipe recipe) {
            for (ItemStack ingredient : recipe.items) {
                buf.m_130055_(ingredient);
            }
            buf.m_130055_(recipe.heldItem);
            buf.m_130055_(recipe.result);
        }
    }
}

