/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cz.blackdragoncz.lostdepths.recipe.LDCraftingRecipe;
import cz.blackdragoncz.lostdepths.recipe.LDRecipe;
import cz.blackdragoncz.lostdepths.recipe.LDShapedRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleRecipe
extends LDCraftingRecipe {
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack result;

    public ModuleRecipe(ResourceLocation id, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id);
        this.recipeItems = recipeItems;
        this.result = result;
    }

    @Override
    public boolean m_142505_() {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        return ingredients.isEmpty() || ingredients.stream().filter(ingredient -> !ingredient.m_43947_()).anyMatch(ForgeHooks::hasNoElements);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            Ingredient ingredient = (Ingredient)this.recipeItems.get(i);
            if (ingredient.test(inv.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    @Override
    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return super.m_8004_(width, height);
    }

    public static class Serializer
    implements RecipeSerializer<ModuleRecipe> {
        private final IFactory<ModuleRecipe> factory;

        public Serializer(IFactory<ModuleRecipe> factory) {
            this.factory = factory;
        }

        @NotNull
        public ModuleRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            JsonArray items = json.getAsJsonArray("items");
            NonNullList ingredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            for (int i = 0; i < items.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_288218_((JsonElement)items.get(i), (boolean)false));
            }
            ItemStack itemstack = LDShapedRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return this.factory.create(recipeId, (NonNullList<Ingredient>)ingredients, itemstack);
        }

        @Nullable
        public ModuleRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList ingredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            ItemStack itemstack = pBuffer.m_130267_();
            return this.factory.create(pRecipeId, (NonNullList<Ingredient>)ingredients, itemstack);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, ModuleRecipe pRecipe) {
            for (Ingredient ingredient : pRecipe.recipeItems) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.result);
        }

        @FunctionalInterface
        public static interface IFactory<RECIPE extends LDRecipe> {
            public RECIPE create(ResourceLocation var1, NonNullList<Ingredient> var2, ItemStack var3);
        }
    }
}

