/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.world.entity.projectile;

import cz.blackdragoncz.lostdepths.init.LostdepthsModItems;
import cz.blackdragoncz.lostdepths.util.NothingNullByDefault;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ThrownDraconicTrident
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownDraconicTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private ItemStack tridentItem;
    private boolean dealtDamage;
    private boolean igniteEntity;
    public int clientSideReturnTridentTickCount;

    public ThrownDraconicTrident(Item item, EntityType<? extends ThrownDraconicTrident> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.tridentItem = new ItemStack((ItemLike)item);
    }

    public ThrownDraconicTrident(EntityType<? extends ThrownDraconicTrident> pEntityType, Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super(pEntityType, pShooter, pLevel);
        this.tridentItem = pStack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)pStack)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
    }

    public void setIgniteEntity(boolean igniteEntity) {
        this.igniteEntity = igniteEntity;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(EntityHitResult pResult) {
        SoundEvent soundevent = SoundEvents.f_12514_;
        float f1 = 1.0f;
        Entity entity = pResult.m_82443_();
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        float damageAmount = 8.0f;
        if (this.tridentItem.m_41720_() == LostdepthsModItems.DRACONIC_TRIDENT.get()) {
            damageAmount = 11.5f;
        } else if (this.tridentItem.m_41720_() == LostdepthsModItems.PRIME_DRACONIC_TRIDENT.get()) {
            damageAmount = 19.5f;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            damageAmount += EnchantmentHelper.m_44833_((ItemStack)this.tridentItem, (MobType)livingentity.m_6336_());
        }
        if (this.igniteEntity) {
            entity.m_20254_(5);
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                player.m_20095_();
                this.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (entity.m_6469_(damagesource, damageAmount) && entity instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity;
            if (entity1 instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
            }
            this.m_7761_(livingentity1);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(soundevent, f1, 1.0f);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public ItemStack m_7941_() {
        return this.tridentItem;
    }

    protected boolean m_142470_(@NotNull Player pPlayer) {
        return super.m_142470_(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && pPlayer.m_150109_().m_36054_(this.m_7941_());
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Trident", 10)) {
            this.tridentItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Trident"));
        }
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.tridentItem)));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Trident", (Tag)this.tridentItem.m_41739_(new CompoundTag()));
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

