/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.client.gui;

import cz.blackdragoncz.lostdepths.client.gui.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGuiWrapper
extends ContainerEventHandler {
    default public void displayTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, Component ... components) {
        this.displayTooltips(guiGraphics, mouseX, mouseY, List.of(components));
    }

    default public void displayTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, List<Component> components) {
        guiGraphics.m_280666_(this.getFont(), components, mouseX, mouseY);
    }

    @NotNull
    default public ItemStack getCarriedItem() {
        return ItemStack.f_41583_;
    }

    public int getGuiLeft();

    public int getGuiTop();

    public int getXSize();

    public int getYSize();

    default public boolean currentlyQuickCrafting() {
        return false;
    }

    public Font getFont();

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis) {
        this.renderItem(guiGraphics, stack, xAxis, yAxis, 1.0f);
    }

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.getFont(), null, false);
    }

    default public void renderItemTooltip(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis) {
        guiGraphics.m_280153_(this.getFont(), stack, xAxis, yAxis);
    }

    default public void renderItemTooltipWithExtra(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, List<Component> toAppend) {
        if (toAppend.isEmpty()) {
            this.renderItemTooltip(guiGraphics, stack, xAxis, yAxis);
        } else {
            ArrayList<Component> tooltip = new ArrayList<Component>(Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack));
            tooltip.addAll(toAppend);
            guiGraphics.renderTooltip(this.getFont(), tooltip, stack.m_150921_(), stack, xAxis, yAxis);
        }
    }

    default public void renderItemWithOverlay(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale, @Nullable String text) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.getFont(), text, true);
    }
}

