/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.client.renderer.block;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class BlockEntityRenderBase<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected static final Logger LOGGER = LogUtils.getLogger();

    protected AbstractTexture getTexture(ResourceLocation location) {
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        return manager.m_118506_(location);
    }

    protected void endIfNeeded(MultiBufferSource renderer, @Nullable RenderType renderType) {
        if (!Minecraft.m_91085_() && renderer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)renderer;
            if (renderType == null) {
                source.m_173043_();
            } else {
                source.m_109911_();
            }
        }
    }

    public static boolean isChunkLoaded(@Nullable LevelReader world, int chunkX, int chunkZ) {
        LevelAccessor accessor;
        ChunkSource chunkSource;
        if (world == null) {
            return false;
        }
        if (world instanceof LevelAccessor && (chunkSource = (accessor = (LevelAccessor)world).m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverChunkCache = (ServerChunkCache)chunkSource;
            CompletableFuture future = serverChunkCache.m_8431_(chunkX, chunkZ, ChunkStatus.f_62326_, false);
            return future.isDone() && future.getNow(ChunkHolder.f_139995_).left().isPresent();
        }
        return world.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false) != null;
    }

    public static boolean isChunkLoaded(@Nullable LevelReader world, @NotNull BlockPos pos) {
        return BlockEntityRenderBase.isChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isBlockLoaded(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !(level = (Level)reader).m_46739_(pos)) {
                return false;
            }
            return BlockEntityRenderBase.isChunkLoaded(reader, pos);
        }
        return true;
    }

    public static Optional<BlockState> getBlockState(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (!BlockEntityRenderBase.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        return Optional.of(world.m_8055_(pos));
    }

    public static float getRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 0.0f;
            case Direction.EAST -> 270.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            default -> 0.0f;
        };
    }
}

