/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.item.shield;

import cz.blackdragoncz.lostdepths.init.LostdepthsModDamageTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;

public class MirrorShield
extends Item {
    private static final String NO_REFLECTION = "lostdepths_no_reflection";

    public MirrorShield() {
        super(new Item.Properties().m_41487_(1));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingHurtEvent.class, this::onLivingHurt);
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        list.add((Component)Component.m_237113_((String)"\u00a7bWhen held in the offhand, reflect 100% of max health damage taken."));
    }

    private boolean isTrueDamage(DamageSource source, LivingEntity context) {
        Optional key = source.m_269150_().m_203543_();
        return key.isPresent() && ((ResourceKey)key.get()).equals(LostdepthsModDamageTypes.TRUE_DAMAGE);
    }

    private DamageSource createReflectSource(LivingEntity victim, boolean trueDamage) {
        Registry registry = victim.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
        Holder.Reference holder = trueDamage ? registry.m_246971_(LostdepthsModDamageTypes.TRUE_DAMAGE) : registry.m_246971_(DamageTypes.f_268440_);
        return new DamageSource((Holder)holder, (Entity)victim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withNoReflect(LivingEntity target, Runnable action) {
        CompoundTag tag = target.getPersistentData();
        boolean prev = tag.m_128471_(NO_REFLECTION);
        try {
            tag.m_128379_(NO_REFLECTION, true);
            action.run();
        }
        finally {
            if (!prev) {
                tag.m_128473_(NO_REFLECTION);
            } else {
                tag.m_128379_(NO_REFLECTION, true);
            }
        }
    }

    private void onLivingHurt(LivingHurtEvent event) {
        boolean shouldReflect;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity victim = event.getEntity();
        if (victim.m_21206_().m_41720_() != this) {
            return;
        }
        if (victim.getPersistentData().m_128471_(NO_REFLECTION)) {
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        boolean isTrueDamage = this.isTrueDamage(event.getSource(), victim);
        float incoming = event.getAmount();
        float victimMax = victim.m_21233_();
        boolean bl = shouldReflect = isTrueDamage || incoming >= victimMax;
        if (!shouldReflect) {
            return;
        }
        DamageSource reflectSource = this.createReflectSource(victim, isTrueDamage);
        MirrorShield.withNoReflect(livingAttacker, () -> livingAttacker.m_6469_(reflectSource, incoming));
    }
}

