/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.procedures.item;

import cz.blackdragoncz.lostdepths.init.LostdepthsModItems;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PortableBeaconFunctionality {
    private static final double RADIUS = 35.0;
    private static final int DURATION_TICKS = 200;
    private static final int REFRESH_BELOW_TICKS = 40;
    private static final Map<String, EffectSpec> ALLOWED_EFFECTS = Map.of("minecraft:speed", new EffectSpec(MobEffects.f_19596_, 1), "minecraft:fire_resistance", new EffectSpec(MobEffects.f_19607_, 1), "minecraft:invisibility", new EffectSpec(MobEffects.f_19609_, 1), "minecraft:jump_boost", new EffectSpec(MobEffects.f_19603_, 1), "minecraft:night_vision", new EffectSpec(MobEffects.f_19611_, 1), "minecraft:regeneration", new EffectSpec(MobEffects.f_19605_, 0), "minecraft:slow_falling", new EffectSpec(MobEffects.f_19591_, 1), "minecraft:strength", new EffectSpec(MobEffects.f_19600_, 1), "minecraft:water_breathing", new EffectSpec(MobEffects.f_19608_, 1), "minecraft:glowing", new EffectSpec(MobEffects.f_19619_, 1)).entrySet().stream().filter(event -> !((String)event.getKey()).isEmpty()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));

    public static void execute(Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        if (!PortableBeaconFunctionality.isHoldingPortableBeaconOffhand(entity)) {
            return;
        }
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        String allowedList = itemstack.m_41784_().m_128461_("potionListA");
        if (allowedList.isEmpty()) {
            return;
        }
        Vec3 center = entity.m_20182_();
        AABB box = new AABB(center.f_82479_ - 35.0, center.f_82480_ - 35.0, center.f_82481_ - 35.0, center.f_82479_ + 35.0, center.f_82480_ + 35.0, center.f_82481_ + 35.0);
        List targets = level.m_6443_(LivingEntity.class, box, e -> true);
        if (targets.isEmpty()) {
            return;
        }
        for (Map.Entry<String, EffectSpec> entry : ALLOWED_EFFECTS.entrySet()) {
            String effectId = entry.getKey();
            if (!allowedList.contains(effectId)) continue;
            EffectSpec spec = entry.getValue();
            PortableBeaconFunctionality.applyEffectToTargets(targets, spec.effect, spec.amplifier);
        }
    }

    private static boolean isHoldingPortableBeaconOffhand(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity liv = (LivingEntity)entity;
        ItemStack off = liv.m_21206_();
        return !off.m_41619_() && off.m_41720_() == LostdepthsModItems.PORTABLE_BEACON.get();
    }

    private static void applyEffectToTargets(List<LivingEntity> targets, MobEffect effect, int amplifier) {
        for (LivingEntity target : targets) {
            MobEffectInstance existing = target.m_21124_(effect);
            if (existing != null && existing.m_19557_() >= 40 && existing.m_19564_() >= amplifier) continue;
            target.m_7292_(new MobEffectInstance(effect, 200, amplifier, true, false));
        }
    }

    private record EffectSpec(MobEffect effect, int amplifier) {
    }
}

