/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.recipe;

import com.google.gson.JsonObject;
import cz.blackdragoncz.lostdepths.recipe.LDRecipe;
import cz.blackdragoncz.lostdepths.recipe.LDShapedRecipe;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LDShapedRecipeSerializer
implements RecipeSerializer<LDShapedRecipe> {
    private final IFactory<LDShapedRecipe> factory;

    public LDShapedRecipeSerializer(IFactory<LDShapedRecipe> factory) {
        this.factory = factory;
    }

    public LDShapedRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pJson) {
        Map<String, Ingredient> map = LDShapedRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"key"));
        String[] astring = LDShapedRecipe.shrink(LDShapedRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"pattern")));
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = LDShapedRecipe.dissolvePattern(astring, map, i, j);
        ItemStack itemstack = LDShapedRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
        return this.factory.create(pRecipeId, i, j, nonnulllist, itemstack);
    }

    @Nullable
    public LDShapedRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        int i = pBuffer.m_130242_();
        int j = pBuffer.m_130242_();
        NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
        nonnulllist.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
        ItemStack itemstack = pBuffer.m_130267_();
        return this.factory.create(pRecipeId, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, LDShapedRecipe pRecipe) {
        pBuffer.m_130130_(pRecipe.width);
        pBuffer.m_130130_(pRecipe.height);
        for (Ingredient ingredient : pRecipe.recipeItems) {
            ingredient.m_43923_(pBuffer);
        }
        pBuffer.m_130055_(pRecipe.result);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends LDRecipe> {
        public RECIPE create(ResourceLocation var1, int var2, int var3, NonNullList<Ingredient> var4, ItemStack var5);
    }
}

