/*
 * Decompiled with CFR 0.152.
 */
package cz.blackdragoncz.lostdepths.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class BasicTeleporter
implements ITeleporter {
    private final Long2ObjectMap<PortalPosition> destinationCoordinateCaChe = new Long2ObjectOpenHashMap(4096);
    private final ServerLevel world;
    private final double goToX;
    private final double goToY;
    private final double goToZ;
    private final boolean strict;

    public BasicTeleporter(ServerLevel world, double xpos, double ypos, double zpos) {
        this(world, xpos, ypos, zpos, false);
    }

    public BasicTeleporter(ServerLevel world, double xpos, double ypos, double zpos, boolean strictSet) {
        this.world = world;
        this.goToX = xpos;
        this.goToY = ypos;
        this.goToZ = zpos;
        this.strict = strictSet;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        return new PortalInfo(new Vec3(this.goToX, this.goToY, this.goToZ), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        return false;
    }

    public void tick(long worldTime) {
        if (worldTime % 100L == 0L) {
            long i = worldTime - 300L;
            ObjectIterator objectiterator = this.destinationCoordinateCaChe.values().iterator();
            while (objectiterator.hasNext()) {
                PortalPosition portalShape = (PortalPosition)objectiterator.next();
                if (portalShape != null && portalShape.lastUpdateTime >= i) continue;
                objectiterator.remove();
            }
        }
    }

    private static class PortalPosition {
        final BlockPos pos;
        final long lastUpdateTime;

        PortalPosition(BlockPos pos, Long lastUpdateTime) {
            this.pos = pos;
            this.lastUpdateTime = lastUpdateTime;
        }
    }
}

