/*
 * Decompiled with CFR 0.152.
 */
package com.ciobert.shutdown.scheduler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownScheduler
implements ModInitializer {
    public static final String MOD_ID = "shutdown-scheduler";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"shutdown-scheduler");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/shutdown_scheduler.json");
    private static Map<String, List<String>> shutdowns = new HashMap<String, List<String>>();
    private static int warningMinutes = 5;
    private static MinecraftServer server;
    private static ScheduledExecutorService scheduler;
    private static Set<String> triggeredToday;
    private static boolean shutdownInProgress;
    private static final String[] DAYS;

    public void onInitialize() {
        LOGGER.info("=== Inizializzazione Shutdown Scheduler ===");
        ShutdownScheduler.loadConfig();
        LOGGER.info("Configurazione caricata: {} shutdown programmati", (Object)shutdowns.values().stream().mapToInt(List::size).sum());
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            server = s;
            LOGGER.info("Server avviato, Shutdown Scheduler attivo!");
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"shutdownscheduler").requires(src -> src.method_9259(4))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"day", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (String d : DAYS) {
                builder.suggest(d);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"hour", (ArgumentType)IntegerArgumentType.integer((int)0, (int)23)).then(class_2170.method_9244((String)"minute", (ArgumentType)IntegerArgumentType.integer((int)0, (int)59)).executes(ctx -> {
            String day = StringArgumentType.getString((CommandContext)ctx, (String)"day").toLowerCase();
            int hour = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"hour");
            int minute = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minute");
            String time = String.format("%02d:%02d", hour, minute);
            LOGGER.info("=== COMANDO ADD ESEGUITO ===");
            LOGGER.info("Giorno: {}, Ora: {}", (Object)day, (Object)time);
            LOGGER.info("Map prima: {}", shutdowns);
            shutdowns.computeIfAbsent(day, k -> new ArrayList()).add(time);
            LOGGER.info("Map dopo: {}", shutdowns);
            ShutdownScheduler.saveConfig();
            LOGGER.info("Aggiunto shutdown: {} alle {}", (Object)day, (Object)time);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aAggiunto spegnimento per " + day + " alle " + time)), false);
            return 1;
        })))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"day", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (String d : DAYS) {
                builder.suggest(d);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"hour", (ArgumentType)IntegerArgumentType.integer((int)0, (int)23)).then(class_2170.method_9244((String)"minute", (ArgumentType)IntegerArgumentType.integer((int)0, (int)59)).executes(ctx -> {
            String day = StringArgumentType.getString((CommandContext)ctx, (String)"day").toLowerCase();
            int hour = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"hour");
            int minute = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minute");
            String time = String.format("%02d:%02d", hour, minute);
            List<String> times = shutdowns.get(day);
            if (times != null && times.remove(time)) {
                ShutdownScheduler.saveConfig();
                LOGGER.info("Rimosso shutdown: {} alle {}", (Object)day, (Object)time);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cRimosso spegnimento per " + day + " alle " + time)), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7eNon trovato nessuno spegnimento per " + day + " alle " + time)), false);
            }
            return 1;
        })))))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            LOGGER.info("=== COMANDO LIST ESEGUITO ===");
            LOGGER.info("Shutdowns map size: {}", (Object)shutdowns.size());
            LOGGER.info("Shutdowns map: {}", shutdowns);
            StringBuilder sb = new StringBuilder("\u00a7e=== Shutdown Programmati ===\n");
            sb.append("\u00a77(Totale giorni: ").append(shutdowns.size()).append(")\n");
            if (shutdowns.isEmpty()) {
                sb.append("\u00a7cNessuno shutdown programmato!");
                LOGGER.warn("Map degli shutdown \u00e8 VUOTA!");
            } else {
                LOGGER.info("Iterazione sui giorni...");
                for (String d : DAYS) {
                    List<String> times = shutdowns.get(d);
                    LOGGER.info("Giorno {}: {}", (Object)d, times);
                    if (times == null || times.isEmpty()) continue;
                    sb.append("\u00a7b").append(d).append("\u00a7f: ");
                    sb.append(String.join((CharSequence)", ", times)).append("\n");
                }
            }
            String message = sb.toString();
            LOGGER.info("Messaggio da inviare: {}", (Object)message);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)message), false);
            return 1;
        }))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
            ShutdownScheduler.loadConfig();
            triggeredToday.clear();
            shutdownInProgress = false;
            LOGGER.info("Configurazione ricaricata");
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aConfigurazione ricaricata."), false);
            return 1;
        }))).then(class_2170.method_9247((String)"test").executes(ctx -> {
            LocalDateTime now = LocalDateTime.now();
            String day = DAYS[now.getDayOfWeek().getValue() - 1];
            String time = now.format(DateTimeFormatter.ofPattern("HH:mm"));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7e=== Debug Info ===\n\u00a7fGiorno: \u00a7b" + day + "\n\u00a7fOra: \u00a7b" + time + "\n\u00a7fServer attivo: \u00a7b" + (server != null) + "\n\u00a7fShutdown in corso: \u00a7b" + shutdownInProgress + "\n\u00a7fTriggered oggi: \u00a7b" + triggeredToday.size())), false);
            return 1;
        }))).then(class_2170.method_9247((String)"force").then(class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).executes(ctx -> {
            int minutes = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minutes");
            ShutdownScheduler.scheduleShutdown(minutes);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aShutdown forzato tra " + minutes + " minuti")), false);
            return 1;
        })))));
        scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(() -> {
            try {
                ShutdownScheduler.checkScheduledShutdowns();
            }
            catch (Exception e) {
                LOGGER.error("Errore nel controllo degli shutdown programmati", (Throwable)e);
            }
        }, 0L, 30L, TimeUnit.SECONDS);
        LOGGER.info("=== Shutdown Scheduler caricato con successo! ===");
    }

    private static void checkScheduledShutdowns() {
        List times;
        if (server == null || shutdownInProgress) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        DayOfWeek today = now.getDayOfWeek();
        String day = DAYS[today.getValue() - 1];
        LocalTime currentTime = now.toLocalTime();
        if (currentTime.getHour() == 0 && currentTime.getMinute() == 0) {
            triggeredToday.clear();
            LOGGER.info("Reset trigger giornalieri");
        }
        if ((times = shutdowns.getOrDefault(day, Collections.emptyList())).isEmpty()) {
            return;
        }
        for (String scheduledTime : times) {
            String triggerKey = day + "_" + scheduledTime;
            if (triggeredToday.contains(triggerKey)) continue;
            try {
                LocalTime scheduled = LocalTime.parse(scheduledTime, DateTimeFormatter.ofPattern("HH:mm"));
                long minutesUntil = Duration.between(currentTime, scheduled).toMinutes();
                LOGGER.debug("Check: {} - Ora: {} - Programmato: {} - Minuti: {}", new Object[]{day, currentTime.format(DateTimeFormatter.ofPattern("HH:mm")), scheduledTime, minutesUntil});
                if (minutesUntil < 0L || minutesUntil > (long)warningMinutes) continue;
                triggeredToday.add(triggerKey);
                shutdownInProgress = true;
                LOGGER.info("=== SHUTDOWN ATTIVATO per {} alle {} (tra {} minuti) ===", new Object[]{day, scheduledTime, minutesUntil});
                ShutdownScheduler.scheduleShutdown(minutesUntil);
                break;
            }
            catch (Exception e) {
                LOGGER.error("Errore nel parsing del tempo: " + scheduledTime, (Throwable)e);
            }
        }
    }

    private static void scheduleShutdown(long minutesUntil) {
        LOGGER.info("Programmazione shutdown tra {} minuti", (Object)minutesUntil);
        server.execute(() -> server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a7c\u00a7l\u26a0 Il server si spegner\u00e0 tra " + minutesUntil + " minut" + (minutesUntil == 1L ? "o" : "i") + "!")), false));
        if (minutesUntil > 1L) {
            scheduler.schedule(() -> {
                LOGGER.info("Avviso: 1 minuto allo shutdown");
                server.execute(() -> server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a7e\u00a7l\u26a0 Il server si spegner\u00e0 tra 1 minuto!"), false));
            }, minutesUntil - 1L, TimeUnit.MINUTES);
        }
        scheduler.schedule(() -> {
            LOGGER.info("ESECUZIONE SHUTDOWN");
            server.execute(() -> {
                server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a74\u00a7l\u26a0 SPEGNIMENTO DEL SERVER IN CORSO..."), false);
                scheduler.schedule(() -> {
                    LOGGER.info("Stop del server...");
                    server.execute(() -> {
                        try {
                            server.method_3747(false);
                        }
                        catch (Exception e) {
                            LOGGER.error("Errore durante lo stop del server", (Throwable)e);
                            System.exit(0);
                        }
                    });
                }, 3L, TimeUnit.SECONDS);
            });
        }, minutesUntil, TimeUnit.MINUTES);
    }

    private static void loadConfig() {
        try {
            if (!CONFIG_FILE.exists()) {
                LOGGER.info("File di configurazione non trovato, creazione nuovo file...");
                CONFIG_FILE.getParentFile().mkdirs();
                shutdowns = new HashMap<String, List<String>>();
                warningMinutes = 5;
                ShutdownScheduler.saveConfig();
                return;
            }
            LOGGER.info("Caricamento configurazione da: {}", (Object)CONFIG_FILE.getAbsolutePath());
            FileReader reader = new FileReader(CONFIG_FILE);
            ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            reader.close();
            if (data != null) {
                if (data.shutdowns != null) {
                    shutdowns = data.shutdowns;
                    LOGGER.info("Caricati {} giorni con shutdown programmati", (Object)shutdowns.size());
                    shutdowns.forEach((day, times) -> LOGGER.info("  - {}: {}", day, times));
                } else {
                    shutdowns = new HashMap<String, List<String>>();
                    LOGGER.warn("Nessuno shutdown trovato nel config");
                }
                warningMinutes = data.warning_minutes;
                LOGGER.info("Warning minutes: {}", (Object)warningMinutes);
            } else {
                LOGGER.warn("Config data \u00e8 null!");
                shutdowns = new HashMap<String, List<String>>();
            }
        }
        catch (Exception e) {
            LOGGER.error("Errore nel caricamento della configurazione!", (Throwable)e);
            e.printStackTrace();
        }
    }

    private static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            FileWriter w = new FileWriter(CONFIG_FILE);
            ConfigData data = new ConfigData();
            data.shutdowns = shutdowns;
            data.warning_minutes = warningMinutes;
            GSON.toJson((Object)data, (Appendable)w);
            w.close();
            LOGGER.info("Configurazione salvata: {} shutdown", (Object)shutdowns.values().stream().mapToInt(List::size).sum());
        }
        catch (Exception e) {
            LOGGER.error("Errore nel salvataggio della configurazione!", (Throwable)e);
            e.printStackTrace();
        }
    }

    static {
        triggeredToday = new HashSet<String>();
        shutdownInProgress = false;
        DAYS = new String[]{"lunedi", "martedi", "mercoledi", "giovedi", "venerdi", "sabato", "domenica"};
    }

    private static class ConfigData {
        public Map<String, List<String>> shutdowns = new HashMap<String, List<String>>();
        public int warning_minutes = 5;

        private ConfigData() {
        }
    }
}

