package com.github.suninvr.virtualadditions;

import com.github.suninvr.virtualadditions.registry.*;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7696;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SuppressWarnings("unused")
public class VirtualAdditions implements ModInitializer {

	public static final String MODID = "virtual_additions";
	public static final String NAMESPACE = "virtual_additions";
	public static final String MODNAME = "Virtual Additions";
	public static class_7696 PREVIEW;
	private static boolean areBlocksInitialized = false;
	public static boolean isDataGenerationActive = false;
	public static boolean skipBrewingRecipeAssert = false;

	public static Logger LOGGER = LogManager.getLogger();

	public static boolean DEBUG;

    public static boolean areBlocksInitialized() {
		return areBlocksInitialized;
    }

	public static void setBlocksInitialized() {
		areBlocksInitialized = true;
	}

    public static boolean isFromMod(class_2960 id) {
		return id.method_12836().equals(NAMESPACE);
    }

    @Override
	public void onInitialize() {
		DEBUG = "true".equals(System.getenv("VIRTUAL_ADDITIONS_DEBUG"));
		LOGGER.log(Level.INFO, DEBUG ? "Virtual Additions is in debug mode!" : "Virtual Additions is now loading!");

		FabricLoader.getInstance().getModContainer(MODID).ifPresent(
				modContainer -> {
					ResourceManagerHelper.registerBuiltinResourcePack(idOf("preview"), modContainer, class_2561.method_43471("datapack.virtual_additions.preview"), ResourcePackActivationType.NORMAL);
					ResourceManagerHelper.registerBuiltinResourcePack(idOf("worldgen"), modContainer, class_2561.method_43471("datapack.virtual_additions.worldgen"), ResourcePackActivationType.NORMAL);
					ResourceManagerHelper.registerBuiltinResourcePack(idOf("enhancements_data"), modContainer, class_2561.method_43471("datapack.virtual_additions.enhancements"), ResourcePackActivationType.DEFAULT_ENABLED);
					ResourceManagerHelper.registerBuiltinResourcePack(idOf("enhancements_resources"), modContainer, class_2561.method_43471("datapack.virtual_additions.enhancements"), ResourcePackActivationType.DEFAULT_ENABLED);
				}
		);

        VAAdvancementCriteria.init();
        VAArmorTrimMaterials.init();
        VAArmorTrimPatterns.init();
		VABiomeKeys.init();
		VABlocks.init();
		VABlockEntityType.init();
		VABlockTags.init();
		VACallbacks.init();
		VADamageTypes.init();
		VADataComponentTypes.init();
		VADyeColors.init();
		VAEnchantmentEffects.init();
		VAEntityType.init();
		VAEntityTypeTags.init();
		VAEntityAttributes.init();
		VAFeatures.init();
		VAFluids.init();
		VAGameEventTags.init();
		VAGameRules.init();
		VAItems.init();
		VALootTables.init();
		VAItemGroups.init();
		VAItemTags.init();
		VAPackets.init();
		VAParticleTypes.init();
		VAPotions.init();
		VARecipeType.init();
		VARegistryAliases.init();
		VAScreenHandler.init();
		VASoundEvents.init();
		VAStatusEffects.init();
		VATrackedDataHandlerRegistry.init();
	}

	/**
	 * Returns a new ID for this mod.
	 * This will appear in game as "{@code NAMESPACE:id}"
	 *
	 * @param id The identifier's path.
	 * **/
	public static class_2960 idOf(String id) {
		return class_2960.method_60655(NAMESPACE, id);
	}
}
