package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1540;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5688;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class BalloonBulbPlantBlock extends class_2248 implements class_2256, class_5688 {
    public static final MapCodec<BalloonBulbPlantBlock> CODEC = method_54094(BalloonBulbPlantBlock::new);
    public static final class_2758 AGE = class_2741.field_12497;
    private static final class_265 SHAPE = class_2248.method_9541(3.0F, 4.0F, 3.0F, 13.0F, 16.0F, 13.0F);
    public BalloonBulbPlantBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664().method_11657(AGE, 0));
    }

    @Override
    protected MapCodec<? extends class_2248> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        world.method_64310(pos, this, 2);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AGE);
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        class_2680 aboveState = world.method_8320(pos.method_10084());
        int a = state.method_11654(AGE);
        return a < 3 && aboveState.method_27852(VABlocks.BALLOON_BULB) && aboveState.method_11654(BalloonBulbBlock.HEIGHT) > a;
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    @Override
    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        if (state.method_27852(this)) {
            int a = state.method_11654(AGE);
            if (a < 3) {
                class_2680 aboveState = world.method_8320(pos.method_10084());
                if (aboveState.method_27852(VABlocks.BALLOON_BULB) && aboveState.method_11654(BalloonBulbBlock.HEIGHT) > a) {
                    world.method_8501(pos, state.method_11657(AGE, a + 1));
                }
            }
        }
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return state.method_11654(AGE) < 3;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(2) == 1) method_9652(world, random, pos, state);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10084()).method_27852(VABlocks.BALLOON_BULB);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.method_8320(pos.method_10084()).method_27852(VABlocks.BALLOON_BULB)) {
            class_1540 fallingBlockEntity = class_1540.method_40005(world, pos, state);
        }
    }

    @Override
    public void method_10129(class_1937 world, class_2338 pos, class_1540 fallingBlockEntity) {
        class_2680 state = fallingBlockEntity.method_6962();
        this.method_9576(world, pos, state, null);
        if (world instanceof class_3218 serverWorld) class_2248.method_9610(state, serverWorld, pos, null);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_243 offset = state.method_26226(pos);
        return SHAPE.method_1096(offset.field_1352, 0, offset.field_1350);
    }
}
