package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.entity.ColoringStationBlockEntity;
import com.github.suninvr.virtualadditions.registry.VADyeColors;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3954;
import net.minecraft.class_3965;

public class ColoringStationBlock extends class_2237 implements class_3954 {
    public ColoringStationBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608()) {
            ColoringStationBlockEntity entity = world.method_8321(pos) instanceof ColoringStationBlockEntity b ? b : null;
            if (entity != null) player.method_17355(entity);
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (world.method_8321(pos) instanceof ColoringStationBlockEntity blockEntity) {
            List<class_1799> stacks = blockEntity.getDroppedStacks();
            stacks.forEach(itemStack -> {
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                itemEntity.method_6988();
                world.method_8649(itemEntity);
            });
        }

        return super.method_9576(world, pos, state, player);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ColoringStationBlockEntity(pos, state);
    }

    @Override
    public class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        return new ColoringStationInventory(state, world, pos);
    }

    static class ColoringStationInventory extends class_1277 implements class_1278 {
        private final class_2680 state;
        private final class_1936 world;
        private final class_2338 pos;
        private final ColoringStationBlockEntity entity;
        private boolean dirty;

        public ColoringStationInventory(class_2680 state, class_1936 world, class_2338 pos) {
            super(1);
            this.state = state;
            this.world = world;
            this.pos = pos;
            this.entity = (ColoringStationBlockEntity) world.method_8321(pos);
        }

        @Override
        public int method_5444() {
            return 1;
        }

        @Override
        public int[] method_5494(class_2350 side) {
            return new int[]{0};
        }

        @Override
        public void method_5431() {
            class_1799 itemStack = this.method_5438(0);
            if (!itemStack.method_7960() && itemStack.method_7909() instanceof class_1769 dyeItem) {
                this.entity.dyeContents.add(VADyeColors.getContents(dyeItem, 8));
                this.dirty = true;
                this.method_5441(0);
            }
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return !this.dirty && stack.method_7909() instanceof class_1769 dyeItem && entity.dyeContents.canAdd(VADyeColors.getContents(dyeItem, 8));
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return false;
        }
    }
}
