package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class CornCropBlock extends class_2302 {
    public static final MapCodec<CornCropBlock> CODEC = method_54094(CornCropBlock::new);
    public static final class_2754<Segment> SEGMENT = class_2754.method_11850("segment", Segment.class);
    private static final class_265 SHAPE_AGE_1;
    private static final class_265 SHAPE_AGE_2;
    private static final class_265 SHAPE_AGE_3;

    public CornCropBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664().method_11657(SEGMENT, Segment.BOTTOM));
    }

    @Override
    public MapCodec<? extends class_2302> method_53969() {
        return field_46329;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(SEGMENT);
        super.method_9515(builder);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_243 offset = state.method_26226(pos);
        return state.method_11654(SEGMENT).getShape(state.method_11654(field_10835)).method_1096(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184(world, pos)) world.method_22352(pos, true);
        super.method_9588(state, world, pos, random);
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        tickView.method_64310(pos, this, 1);
        return state;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_22335(pos, 0) >= 9) {
            int i = this.method_9829(state);
            if (i < this.method_9827()) {
                float f = method_9830(this, world, pos);
                if (random.method_43048((int)(25.0F / f) + 1) == 0) {
                    grow(world, state, pos);
                }
            }
        }
    }

    @Override
    protected class_1935 method_9832() {
        return VAItems.CORN_SEEDS;
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return isSpaceToGrow(world, state, pos) && super.method_9651(world, pos, state);
    }

    public void method_9826(class_1937 world, class_2338 pos, class_2680 state) {
        int i = Math.min(this.method_9829(state) + this.method_9831(world), this.getMaxAgeForSpace(world, pos, state));
        setAge(world, state, pos, i);
    }

    private int getMaxAgeForSpace(class_1937 world, class_2338 pos, class_2680 state) {
        if (!state.method_27852(VABlocks.CORN_CROP)) return 0;
        Segment segment = state.method_11654(SEGMENT);
        if (!(segment.equals(Segment.BOTTOM))) {
            class_2338 offsetPos = pos.method_10086(segment.getYOffset(Segment.BOTTOM));
            return getMaxAgeForSpace(world, offsetPos, world.method_8320(offsetPos));
        }
        if (canReplaceBlockState(world, pos.method_10084().method_10084())) return 7;
        if (canReplaceBlockState(world, pos.method_10084())) return 5;
        return 2;
    }

    private void grow(class_1937 world, class_2680 state, class_2338 pos) {
        if (!state.method_27852(this)) return;
        int age = state.method_11654(field_10835) + 1;
        setAge(world, state, pos, age);
    }

    private boolean isSpaceToGrow(class_4538 world, class_2680 state, class_2338 pos) {
        boolean bl = true;
        int age = state.method_11654(field_10835);
        Segment segment = state.method_11654(SEGMENT);
        if (segment.equals(Segment.BOTTOM) && age >= 2) bl = checkForState(world, pos, state, Segment.MIDDLE, true);
        if (!segment.equals(Segment.TOP) && age >= 5) bl = bl && checkForState(world, pos, state, Segment.TOP, true);
        return bl;
    }

    private void setAge(class_1937 world, class_2680 state, class_2338 pos, int age) {
        boolean growMiddle = age > 2;
        boolean growTop = age > 5;
        switch (state.method_11654(SEGMENT)) {
            case BOTTOM -> {
                boolean canGrow = true;
                if (growMiddle) canGrow = canReplaceBlockState(world, pos.method_10084());
                if (growTop) canGrow = canGrow && canReplaceBlockState(world, pos.method_10086(2));
                if (canGrow) {
                    world.method_8652(pos, this.bottomSegment(age), class_2248.field_31028);
                    if (growMiddle) world.method_8652(pos.method_10084(), this.middleSegment(age), class_2248.field_31028);
                    if (growTop) world.method_8652(pos.method_10086(2), this.topSegment(age), class_2248.field_31028);
                }
            }
            case MIDDLE -> {
                boolean canGrow = true;
                if (growTop) canGrow = canReplaceBlockState(world, pos.method_10084());
                if (canGrow) {
                    world.method_8652(pos.method_10074(), this.bottomSegment(age), class_2248.field_31028);
                    world.method_8652(pos, this.middleSegment(age), class_2248.field_31028);
                    if (growTop) world.method_8652(pos.method_10084(), this.topSegment(age), class_2248.field_31028);
                }
            }
            case TOP -> {
                world.method_8652(pos.method_10087(2), this.bottomSegment(age), class_2248.field_31028);
                world.method_8652(pos.method_10074(), this.middleSegment(age), class_2248.field_31028);
                world.method_8652(pos, this.topSegment(age), class_2248.field_31028);
            }
        }
    }

    private boolean checkForState(class_4538 world, class_2338 pos, class_2680 state, Segment checkSegment, boolean allowAir) {
        Segment segment = state.method_11654(SEGMENT);
        int offset = segment.getYOffset(checkSegment);
        class_2680 checkState = world.method_8320(pos.method_10079(class_2350.field_11036, offset));
        if (checkState.method_27852(VABlocks.CORN_CROP)) return checkState.method_11654(SEGMENT).equals(checkSegment) && checkState.method_11654(field_10835).equals(state.method_11654(field_10835));
        return allowAir && world.method_8320(pos.method_10079(class_2350.field_11036, offset)).method_26215();
    }


    public class_2680 topSegment(int age) {
        return this.stateOf(age, Segment.TOP);
    }
    public class_2680 middleSegment(int age) {
        return this.stateOf(age, Segment.MIDDLE);
    }
    public class_2680 bottomSegment(int age) {
        return this.stateOf(age, Segment.BOTTOM);
    }

    public class_2680 stateOf(int age, Segment segment) {
        return this.method_9828(age).method_11657(SEGMENT, segment);
    }
    
    private boolean canReplaceBlockState(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26215() || state.method_27852(VABlocks.SPOTLIGHT_LIGHT) || state.method_27852(this);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return switch (state.method_11654(SEGMENT)) {
            case TOP -> checkSegment(world, pos, state, class_2350.field_11033);
            case MIDDLE -> checkSegment(world, pos, state, class_2350.field_11033) && (state.method_11654(field_10835) <= 5 || checkSegment(world, pos, state, class_2350.field_11036));
            case BOTTOM -> ((world.method_22335(pos, 0) >= 8 || world.method_8311(pos)) && super.method_9558(state, world, pos)) && (state.method_11654(field_10835) <= 2 || checkSegment(world, pos, state, class_2350.field_11036));
        };
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(SEGMENT, Segment.BOTTOM);
    }

    private boolean checkSegment(class_4538 world, class_2338 pos, class_2680 state, class_2350 direction) {
        Segment segment = state.method_11654(SEGMENT);
        Segment expectedSegment = direction.equals(class_2350.field_11036) ? segment.aboveSegment() : segment.belowSegment();
        if (expectedSegment == null) return false;
        class_2680 offsetState = world.method_8320(pos.method_10093(direction));
        return offsetState.method_27852(this) && offsetState.method_11654(SEGMENT).equals(expectedSegment) && offsetState.method_11654(field_10835).equals(state.method_11654(field_10835));
    }

    public enum Segment implements class_3542 {
        TOP,
        MIDDLE,
        BOTTOM;

        @Override
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public class_265 getShape(int age) {
            age -= this.minAge();
            if (age < 1) return SHAPE_AGE_1;
            if (age > 1) return SHAPE_AGE_3;
            return SHAPE_AGE_2;
        }

        @Nullable
        public CornCropBlock.Segment aboveSegment() {
            return switch (this) {
                case TOP -> null;
                case MIDDLE -> TOP;
                case BOTTOM -> MIDDLE;
            };
        }

        @Nullable
        public CornCropBlock.Segment belowSegment() {
            return switch (this) {
                case TOP -> MIDDLE;
                case MIDDLE -> BOTTOM;
                case BOTTOM -> null;
            };
        }

        public int getYOffset(Segment expectedSegment) {
            return this.ordinal() - expectedSegment.ordinal();
        }

        public int minAge() {
            return switch (this) {
                case TOP -> 6;
                case MIDDLE -> 3;
                case BOTTOM -> 0;
            };
        }
    }

    static {
        SHAPE_AGE_1 = class_2248.method_9541(3, 0, 3, 13, 4, 13);
        SHAPE_AGE_2 = class_2248.method_9541(3, 0, 3, 13, 8, 13);
        SHAPE_AGE_3 = class_2248.method_9541(3, 0, 3, 13, 16, 13);
    }
}
