package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.entity.EntanglementDriveBlockEntity;
import com.github.suninvr.virtualadditions.registry.VABlockEntityType;
import com.github.suninvr.virtualadditions.screen.EntanglementDriveScreenHandler;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_747;
import net.minecraft.class_9904;
import net.minecraft.screen.*;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
public class EntanglementDriveBlock extends class_2237 implements class_3954 {
    public static final MapCodec<EntanglementDriveBlock> CODEC = method_54094(EntanglementDriveBlock::new);
    public static final class_2746 POWERED = class_2741.field_12484;
    private static final class_2561 TITLE;
    private static final class_265 SHAPE;

    public EntanglementDriveBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664()
                .method_11657(POWERED, false)
        );
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(POWERED);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        if (!world.method_8608()) {
            if(world.method_49803(pos)) world.method_8501(pos, state.method_11657(POWERED, true));
            else world.method_8501(pos, state.method_11657(POWERED, false));
        }
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = this.method_9564();
        if (ctx.method_8045().method_49803(ctx.method_8037())) state = state.method_11657(POWERED, true);
        return state;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EntanglementDriveBlockEntity(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608()) {
            EntanglementDriveBlockEntity entity = world.method_8321(pos) instanceof EntanglementDriveBlockEntity entanglementDriveBlockEntity ? entanglementDriveBlockEntity : null;
            if (entity == null) return class_1269.field_5812;
            player.method_17355(entity);
        }
        return class_1269.field_5812;
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return class_1703.method_7608( world.method_8321(pos) );
    }

    @Override
    public class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        return blockEntity != null ? blockEntity instanceof EntanglementDriveBlockEntity entanglementDriveBlockEntity ? entanglementDriveBlockEntity.getInventory() : null : null;
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, VABlockEntityType.ENTANGLEMENT_DRIVE, (EntanglementDriveBlockEntity::tick));
    }

    @Nullable
    @Override
    public class_3908 method_17454(class_2680 state, class_1937 world, class_2338 pos) {
        return new class_747(((syncId, inv, player) -> new EntanglementDriveScreenHandler(syncId, inv, class_3914.method_17392(world, pos), new class_3919(2))), TITLE);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    static {
        TITLE = class_2561.method_43471("container.virtual_additions.entanglement_drive");
        SHAPE = class_259.method_1084(
                class_2248.method_9541(2, 0,2, 14, 16, 14),
                class_2248.method_9541(1, 3,1, 15, 13, 15)
        );
    }

}
