package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.entity.MiniPortalBlockEntity;
import com.github.suninvr.virtualadditions.block.enums.MiniPortalState;
import com.github.suninvr.virtualadditions.interfaces.EntityInterface;
import com.github.suninvr.virtualadditions.registry.*;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import net.minecraft.class_9904;
import net.minecraft.item.*;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Consumer;

public class MiniPortalBlock extends class_2237 implements class_3737 {
    public static final MapCodec<MiniPortalBlock> CODEC = method_54094(MiniPortalBlock::new);
    private final class_265 SHAPE = method_66404(10, 3, 13);
    private final class_238 BOX = class_259.method_1077().method_1107();
    public static final class_2754<MiniPortalState> STATE = class_2754.method_11850("state", MiniPortalState.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public MiniPortalBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664()
                .method_11657(STATE, MiniPortalState.OPEN)
                .method_11657(WATERLOGGED, false)
        );
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(STATE, WATERLOGGED);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Override
    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (stack.method_7909() instanceof class_1769 dyeItem && world.method_8321(pos) instanceof MiniPortalBlockEntity entity && entity.setDyeColor(dyeItem.method_7802())) {
            stack.method_57008(1, player);
            world.method_45447(null, pos, class_3417.field_28391, class_3419.field_15245);
            return class_1269.field_5812;
        }
        if (stack.method_31574(class_1802.field_8574) && stack.method_57826(class_9334.field_49651) && stack.method_58694(class_9334.field_49651).method_57401(class_1847.field_8991)&& world.method_8321(pos) instanceof MiniPortalBlockEntity entity && entity.setDyeColor(null)) {
            player.method_6122(hand, class_5328.method_30012(stack, player, new class_1799(class_1802.field_8469)));
            player.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));
            world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0F, 1.0F);
            world.method_33596(null, class_5712.field_28166, pos);
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MiniPortalBlockEntity(pos, state);
    }

    @Override
    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_243 particlePos = pos.method_46558().method_49272(random, 1);
        if (world.method_8321(pos) instanceof MiniPortalBlockEntity miniPortalBlockEntity) world.method_8406(miniPortalBlockEntity.getParticleParameter(), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0, 0,0);
    }

    @Override
    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        if (state.method_11654(STATE).equals(MiniPortalState.POWERED)) return;
        Optional<class_2338> destination = getDestination(world, pos);
        if (destination.isPresent() && state.method_11654(STATE).canDepart) {
            MiniPortalBlockEntity blockEntity = (MiniPortalBlockEntity) world.method_8321(pos);
            class_2680 destState = world.method_8320(destination.get());
            if (!destState.method_27852(this)) return;
            if (destState.method_11654(STATE).canArrive && canTeleportEntity(entity)) {
                world.method_8501(pos, state.method_11657(STATE, MiniPortalState.COOLDOWN));
                world.method_8501(destination.get(), destState.method_11657(STATE, MiniPortalState.COOLDOWN));
                world.method_64310(pos, this, 20);
                world.method_64310(destination.get(), this, 20);
                teleportEntity(world, pos, destination.get(), entity, blockEntity.getParticleParameter());
            } else {
                world.method_8396(null, pos, VASoundEvents.BLOCK_MINI_PORTAL_FAIL, class_3419.field_15245, 1.0F, 1.6F);
                world.method_8501(pos, state.method_11657(STATE, MiniPortalState.BLOCKED));
                world.method_64310(pos, this, 20);
            }
        }
    }

    @Override
    protected boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(STATE).equals(MiniPortalState.COOLDOWN) ? 15 : 0;
    }

    protected boolean canTeleportEntity(class_1297 entity) {
        if (((EntityInterface)entity).virtualAdditions$hasUsedMiniPortalThisTick()) return false;
        return !(entity instanceof class_1309 livingEntity) || livingEntity.method_6112(VAStatusEffects.IOLITE_INTERFERENCE) == null;
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        if (state.method_11654(STATE).equals(MiniPortalState.POWERED)) return;
        int entityCount = getEntityCount(world, BOX.method_996(pos));
        if (entityCount > 0) {
            if (!state.method_11654(STATE).equals(MiniPortalState.BLOCKED)) world.method_8501(pos, state.method_11657(STATE, MiniPortalState.BLOCKED));
            world.method_64310(pos, this, 20);
        } else {
            world.method_8396(null, pos, VASoundEvents.BLOCK_MINI_PORTAL_RECHARGE, class_3419.field_15245, 1.0F, 1.6F);
            world.method_8501(pos, state.method_11657(STATE, MiniPortalState.OPEN));
        }
    }

    public void teleportEntity(class_1937 world, class_2338 origin, class_2338 destination, class_1297 entity, class_2394 particleEffect) {
        if (!world.method_8608() && world instanceof class_3218 serverWorld){
            if (destination == null) return;
            double squaredDistance = origin.method_10262(destination);
            double destX = (destination.method_10263() + (entity.method_23317() - origin.method_10263()));
            double destY = (destination.method_10264() + (entity.method_23318() - origin.method_10264()));
            double destZ = (destination.method_10260() + (entity.method_23321() - origin.method_10260()));
            entity.method_5859(destX, destY, destZ);
            ((EntityInterface)entity).virtualAdditions$setUsedMiniPortal();
            int i = (int) Math.clamp((entity.method_17681() * entity.method_17681() * entity.method_17682() * 20.0F), 5, 50);
            ((class_3218) world).method_65096(particleEffect, destX, destY, destZ, i, entity.method_17681() * 0.45, entity.method_17682() * 0.25, entity.method_17681() * 0.45, 0);
            world.method_33596(entity, class_5712.field_39446, origin);
            world.method_33596(entity, class_5712.field_39446, destination);
            world.method_8396(null, origin, VASoundEvents.BLOCK_MINI_PORTAL_DEPART, class_3419.field_15245, 1.0F, 1.0F);
            world.method_8396(null, destination, VASoundEvents.BLOCK_MINI_PORTAL_ARRIVE, class_3419.field_15245, 1.0F, 1.0F);
            if (serverWorld.method_64395().method_8355(VAGameRules.IOLITE_INTERFERENCE) && entity instanceof class_1309 livingEntity && !livingEntity.method_56992()) {
                int duration = 0;
                class_1293 effect = livingEntity.method_6112(VAStatusEffects.IOLITE_INTERFERENCE);
                if (effect != null) duration = effect.method_5584();
                duration = Math.min((int)Math.max(600 * Math.sqrt(squaredDistance) / 128, duration), Integer.MAX_VALUE);
                livingEntity.method_6092(new class_1293(VAStatusEffects.IOLITE_INTERFERENCE, duration, 0, false, true));
            }
            if (entity instanceof class_3222 player) {
                VAAdvancementCriteria.USE_TELEPORTER.method_9141(player);
            }
        }
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return VAItems.PORTAL_CORE.method_7854();
    }

    protected static int getEntityCount(class_1937 world, class_238 box) {
        return world.method_8390(class_1297.class, box, class_1301.field_6155).size();
    }

    protected static Optional<class_2338> getDestination(class_1937 world, class_2338 pos) {
        class_2338[] dest = {null};
        ifBlockEntity(world, pos, entity -> dest[0] = entity.getDestination());
        return Optional.ofNullable(dest[0]);
    }

    protected static void ifBlockEntity(class_1937 world, class_2338 pos, Consumer<MiniPortalBlockEntity> consumer) {
        world.method_35230(pos, VABlockEntityType.MINI_PORTAL).ifPresent(consumer);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return super.method_9605(ctx).method_11657(WATERLOGGED, fluidState.method_39360(class_3612.field_15910));
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        if (state.method_11654(WATERLOGGED)) world.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        if (world.method_49803(pos) && !state.method_11654(STATE).equals(MiniPortalState.POWERED)) {
            world.method_8501(pos, state.method_11657(STATE, MiniPortalState.POWERED));
        } else if (!world.method_49803(pos) && state.method_11654(STATE).equals(MiniPortalState.POWERED)) {
            world.method_8501(pos, state.method_11657(STATE, MiniPortalState.OPEN));
        }
    }

    @Override
    protected class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }
}
