package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.entity.SpotlightBlockEntity;
import com.github.suninvr.virtualadditions.block.entity.SpotlightLightBlockEntity;
import com.github.suninvr.virtualadditions.block.enums.LightStatus;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_10225;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("deprecation")
public class SpotlightLightBlock extends class_2237 implements class_3737 {
    public static final MapCodec<SpotlightLightBlock> CODEC = method_54094(SpotlightLightBlock::new);
    public static class_2746 WATERLOGGED = class_2741.field_12508;
    public static class_2746 LIT = class_2741.field_12548;
    public static class_2754<LightStatus> NORTH = class_2754.method_11850("north", LightStatus.class);
    public static class_2754<LightStatus> EAST = class_2754.method_11850("east", LightStatus.class);
    public static class_2754<LightStatus> SOUTH = class_2754.method_11850("south", LightStatus.class);
    public static class_2754<LightStatus> WEST = class_2754.method_11850("west", LightStatus.class);
    public static class_2754<LightStatus> UP = class_2754.method_11850("up", LightStatus.class);
    public static class_2754<LightStatus> DOWN = class_2754.method_11850("down", LightStatus.class);

    public SpotlightLightBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664()
                .method_11657(WATERLOGGED, false)
                .method_11657(LIT, false)
                .method_11657(NORTH, LightStatus.NONE)
                .method_11657(EAST, LightStatus.NONE)
                .method_11657(SOUTH, LightStatus.NONE)
                .method_11657(WEST, LightStatus.NONE)
                .method_11657(UP, LightStatus.NONE)
                .method_11657(DOWN, LightStatus.NONE)
        );
    }

    public static void updateSources(class_1936 world, class_2338 pos, class_2680 state) {
        if (!state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) return;
        SpotlightLightBlock.getSources(world, pos, state).forEach(pos2 -> world.method_64310(pos2, VABlocks.SPOTLIGHT, 1));
    }

    public static List<class_2338> getSources(class_1936 world, class_2338 pos, class_2680 state) {
        List<class_2338> posList = new ArrayList<>();
        for (class_2350 dir : class_2350.values()) if (state.method_11654(getDirectionProperty(dir)).hasLight()) posList.add(findSource(world, pos, dir));
        return posList;
    }

    protected static class_2338 findSource(class_1936 world, class_2338 pos, class_2350 dir) {
        int i = 0;
        class_2338 blockPos = class_2338.field_10980;
        while (i < 33) {
            i++;
            blockPos = pos.method_10079(dir, i);
            if (world.method_8321(blockPos) instanceof SpotlightBlockEntity spotlightBlockEntity && spotlightBlockEntity.getLightLocation().equals(pos)) return blockPos;
        }
        return blockPos;
    }

    protected static class_2754<LightStatus> getDirectionProperty(class_2350 dir) {
        return switch (dir) {
            case field_11033 -> DOWN;
            case field_11036 -> UP;
            case field_11043 -> NORTH;
            case field_11035 -> SOUTH;
            case field_11039 -> WEST;
            case field_11034 -> EAST;
        };
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return class_259.method_1073();
    }

    @Override
    protected boolean method_9579(class_2680 state) {
        return true;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Override
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0F;
    }

    @Nullable
    public static LightStatus getStatus(class_2680 state, class_2350 direction) {
        if (state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            return switch (direction) {
                case field_11043 -> state.method_11654(NORTH);
                case field_11034 -> state.method_11654(EAST);
                case field_11035 -> state.method_11654(SOUTH);
                case field_11039 -> state.method_11654(WEST);
                case field_11036 -> state.method_11654(UP);
                case field_11033 -> state.method_11654(DOWN);
            };
        }
        return null;
    }

    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        LightStatus north = getStatus(state, rotation.method_10503(class_2350.field_11035));
        LightStatus east = getStatus(state, rotation.method_10503(class_2350.field_11039));
        LightStatus south = getStatus(state, rotation.method_10503(class_2350.field_11043));
        LightStatus west = getStatus(state, rotation.method_10503(class_2350.field_11034));
        return state.method_11657(NORTH, north).method_11657(EAST, east).method_11657(SOUTH, south).method_11657(WEST, west);
    }

    @Override
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        LightStatus north = getStatus(state, mirror.method_10345(class_2350.field_11043).method_10503(class_2350.field_11043));
        LightStatus east = getStatus(state, mirror.method_10345(class_2350.field_11034).method_10503(class_2350.field_11034));
        LightStatus south = getStatus(state, mirror.method_10345(class_2350.field_11035).method_10503(class_2350.field_11035));
        LightStatus west = getStatus(state, mirror.method_10345(class_2350.field_11039).method_10503(class_2350.field_11039));
        return state.method_11657(NORTH, north).method_11657(EAST, east).method_11657(SOUTH, south).method_11657(WEST, west);
    }

    public static boolean isLit(class_2680 state) {
        if (state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            LightStatus status;
            for (class_2350 direction : class_2350.values()) {
                status = getStatus(state, direction);
                if (status == LightStatus.LIT) return true;
            }
        }
        return false;
    }

    public static boolean shouldRemove(class_2680 state) {
        if (state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            LightStatus status;
            for (class_2350 direction : class_2350.values()) { 
                status = getStatus(state, direction);
                if (status != LightStatus.NONE) return false;
            }
        }
        return true;
    }

    public static class_2680 getUpdatedLightState(class_2680 state) {
        if (!state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) return state;
        if (shouldRemove(state)) return state.method_11654(WATERLOGGED) ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
        return state.method_11657(LIT, isLit(state));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(WATERLOGGED).method_11667(LIT).method_11667(NORTH).method_11667(EAST).method_11667(SOUTH).method_11667(WEST).method_11667(UP).method_11667(DOWN);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (state.method_11654(WATERLOGGED)) tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        return state.method_11657(LIT, isLit(state));
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpotlightLightBlockEntity(pos, state);
    }
}
