package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.enums.SpringLotusState;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VAEntityTypeTags;
import com.github.suninvr.virtualadditions.registry.VAParticleTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1688;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class SpringLotusBlock extends class_2261 implements class_2256 {
    public static final MapCodec<SpringLotusBlock> CODEC = method_54094(SpringLotusBlock::new);
    public static final class_2758 COMPRESSION = class_2758.method_11867("compression", 0, 4);
    public static final class_2754<SpringLotusState> STATE = class_2754.method_11850("state", SpringLotusState.class);
    public static final class_265 SHAPE_0, SHAPE_1, SHAPE_2, SHAPE_3, SHAPE_4;

    public SpringLotusBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(COMPRESSION, 3).method_11657(STATE, SpringLotusState.IDLE));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(COMPRESSION, STATE);
    }

    @Override
    protected MapCodec<? extends class_2261> method_53969() {
        return field_46280;
    }

    @Override
    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, double fallDistance) {
        if (state.method_11654(COMPRESSION) > 3) {
            super.method_9554(world, state, pos, entity, fallDistance);
            return;
        }
        double d = fallDistance - 15.0;
        super.method_9554(world, state, pos, entity, d);
        if (world.method_8608()) return;
        if (d > entity.method_5850() && entity instanceof class_1309) {
            world.method_8501(pos, state.method_11657(COMPRESSION, 4).method_11657(STATE, SpringLotusState.OVER_COMPRESSED));
            world.method_8396(null, pos, class_3417.field_28579, class_3419.field_15245, 1, 0.8F);
            world.method_64310(pos, this, 1);
        } else if (state.method_11654(COMPRESSION) == 3 && fallDistance >= 0.5 && !entity.method_5864().method_20210(VAEntityTypeTags.IGNORES_SPRING_LOTUS) && !entity.method_5715()) {
            world.method_64310(pos, this, 1);
        }
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(STATE).equals(SpringLotusState.OVER_COMPRESSED)) {
            world.method_8501(pos, state.method_11657(STATE, SpringLotusState.IDLE));
            world.method_64310(pos, this, 99);
            return;
        }
        if (state.method_11654(STATE).equals(SpringLotusState.PUSHING)) {
            world.method_8501(pos, state.method_11657(STATE, SpringLotusState.IDLE));
            world.method_64310(pos, this, 35);
            return;
        }
        int compression = state.method_11654(COMPRESSION);
        if (compression < 3) {
            world.method_8501(pos, state.method_11657(COMPRESSION, compression + 1));
            if (compression < 2) world.method_64310(pos, this, 8);
            world.method_8396(null, pos, class_3417.field_28580, class_3419.field_15245, 1, 1.2F);
        } else if (compression > 3) {
            world.method_8501(pos, state.method_11657(COMPRESSION, compression - 1));
            world.method_8396(null, pos, class_3417.field_28580, class_3419.field_15245, 1, 1.2F);
        } else {
            spring(world, pos, state);
        }
    }

    private static void spring(class_3218 world, class_2338 pos, class_2680 state) {
        class_243 centerPos = pos.method_46558();
        world.method_8335(null, class_238.method_30048(centerPos, 1.0, 1.0, 1.0))
                .forEach(entity -> {
                    double d = getSpringPower(entity);
                    int r;
                    if ((r =world.method_49804(pos)) > 0) {
                        d *= (7.0 - Math.sqrt(r)) / 6.0;
                    }
                    class_243 velocity = entity.method_18798();
                    if (d < velocity.field_1351) return;
                    entity.method_18800(velocity.field_1352, d, velocity.field_1350);
                    entity.field_6037 = true;
                    if (entity instanceof class_3222 serverPlayerEntity) {
                        serverPlayerEntity.field_49989 = serverPlayerEntity.method_73189();
                        serverPlayerEntity.method_60984(true);
                    }
                }
        );
        world.method_8501(pos, state.method_11657(COMPRESSION, 0).method_11657(STATE, SpringLotusState.PUSHING));
        world.method_64310(pos, state.method_26204(), 5);
        world.method_8396(null, pos, class_3417.field_28579, class_3419.field_15245, 1, 1);
        world.method_14199(VAParticleTypes.SPRING_LOTUS_POLLEN, false, false, centerPos.method_10216(), centerPos.method_10214() + 1.0, centerPos.method_10215(), 25, 0.25, 0.25, 0.25, 0.25);
    }

    private static double getSpringPower(class_1297 entity) {
        double d = entity instanceof class_1688 ? 2.8 : 1.6;
        if (entity.method_5864().method_20210(VAEntityTypeTags.IGNORES_SPRING_LOTUS)) d *= 0.65;
        return d;
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return class_2256.method_67541(world, pos, state);
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    @Override
    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        class_2256.method_67539(world, pos, state).ifPresent(posx -> world.method_8501(posx, VABlocks.SMALL_SPRING_LOTUS.method_9564()));
    }

    @Override
    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return state.method_11654(STATE).equals(SpringLotusState.PUSHING) ? SHAPE_3 : super.method_9549(state, world, pos, context);
    }

    @Override
    protected class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(COMPRESSION)) {
            case 0 -> SHAPE_0;
            case 1 -> SHAPE_1;
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
            default -> throw new IllegalStateException("Unexpected value: " + state.method_11654(COMPRESSION));
        };
    }

    @Override
    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0F;
    }

    @Override
    protected boolean method_9579(class_2680 state) {
        return true;
    }

    @Override
    protected class_265 method_9571(class_2680 state) {
        return class_259.method_1073();
    }

    static {
        SHAPE_4 = class_2248.method_66404(16.0, 0.0, 4.0);
        SHAPE_3 = class_259.method_1084(class_2248.method_66404(16.0, 4.0, 8.0), class_2248.method_66404(14.0, 0.0, 8.0));
        SHAPE_2 = class_259.method_1084(class_2248.method_66404(16.0, 8.0, 12.0), class_2248.method_66404(12.0, 0.0, 12.0));
        SHAPE_1 = class_259.method_1084(class_2248.method_66404(16.0, 10.0, 14.0), class_2248.method_66404(10.0, 0.0, 14.0));
        SHAPE_0 = class_259.method_1084(class_2248.method_66404(16.0, 12.0, 16.0), class_2248.method_66404(8.0, 0.0, 16.0));
    }
}
