package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VASoundEvents;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiConsumer;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5712;

public class SteelTrapdoorBlock extends class_2533 {
    public static final MapCodec<SteelTrapdoorBlock> field_46478 = method_54094(SteelTrapdoorBlock::new);
    public static final class_2746 SHUTTER_OPEN = class_2746.method_11825("shutter_open");

    public SteelTrapdoorBlock(class_2251 settings) {
        super(VABlocks.STEEL_BLOCK_SET_TYPE, settings);
        this.method_9590(method_9595().method_11664().method_11657(field_11631, false).method_11657(field_11629, false).method_11657(SHUTTER_OPEN, false));
    }

    @Override
    public MapCodec<? extends class_2533> method_53969() {
        return field_46478;
    }

    @Override
    protected void method_55124(class_2680 state, class_3218 world, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> stackMerger) {
        if (explosion.method_55111() == class_1927.class_4179.field_47331 && !world.method_8608()) toggleShutter(world, state, pos, null);
        super.method_55124(state, world, pos, explosion, stackMerger);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        toggleShutter(world, state, pos, player);
        return class_1269.field_5812;
    }

    private static void toggleShutter(class_1937 world, class_2680 state, class_2338 pos, @Nullable class_1297 source) {
        state = state.method_28493(SHUTTER_OPEN);
        world.method_8652(pos, state, class_2248.field_31028 | class_2248.field_31030);
        playOpenCloseShutterSound(source, world, pos, state.method_11654(SHUTTER_OPEN));
        world.method_33596(source, state.method_11654(SHUTTER_OPEN) ? class_5712.field_28168 : class_5712.field_28169, pos);
    }

    private static void playOpenCloseShutterSound(@Nullable class_1297 entity, class_1937 world, class_2338 pos, boolean open) {
        world.method_8396(entity, pos, open ? VASoundEvents.BLOCK_STEEL_DOOR_SHUTTER_OPEN : VASoundEvents.BLOCK_STEEL_DOOR_SHUTTER_CLOSE, class_3419.field_15245, 0.4F, world.method_8409().method_43057() * 0.1F + 1.2F);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(SHUTTER_OPEN);
    }

}
