package com.github.suninvr.virtualadditions.block.entity;

import com.github.suninvr.virtualadditions.registry.VABlockEntityType;
import com.github.suninvr.virtualadditions.screen.ColoringStationScreenHandler;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;

public class ColoringStationBlockEntity extends class_2586 implements class_3908 {
    private static final class_2561 displayName = class_2561.method_43471("container.virtual_additions.coloring_station");
    public DyeContents dyeContents;
    protected final class_3913 propertyDelegate = new class_3913() {
        @Override
        public int method_17390(int index) {
            return switch (index) {
                case 0 -> ColoringStationBlockEntity.this.dyeContents.getR();
                case 1 -> ColoringStationBlockEntity.this.dyeContents.getG();
                case 2 -> ColoringStationBlockEntity.this.dyeContents.getB();
                case 3 -> ColoringStationBlockEntity.this.dyeContents.getY();
                case 4 -> ColoringStationBlockEntity.this.dyeContents.getK();
                case 5 -> ColoringStationBlockEntity.this.dyeContents.getW();
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        @Override
        public void method_17391(int index, int value) {
            switch (index) {
                case 0 -> ColoringStationBlockEntity.this.dyeContents.setR(value);
                case 1 -> ColoringStationBlockEntity.this.dyeContents.setG(value);
                case 2 -> ColoringStationBlockEntity.this.dyeContents.setB(value);
                case 3 -> ColoringStationBlockEntity.this.dyeContents.setY(value);
                case 4 -> ColoringStationBlockEntity.this.dyeContents.setK(value);
                case 5 -> ColoringStationBlockEntity.this.dyeContents.setW(value);
                default -> throw new IllegalStateException("Unexpected value: " + index);
            }
        }

        @Override
        public int method_17389() {
            return 6;
        }
    };

    public ColoringStationBlockEntity(class_2338 pos, class_2680 state) {
        super(VABlockEntityType.COLORING_STATION, pos, state);
        this.dyeContents = new DyeContents();
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.dyeContents = DyeContents.from(view);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        this.dyeContents.to(view);

    }

    public List<class_1799> getDroppedStacks() {
        return this.dyeContents.getDyeStacks();
    }

    @Override
    public class_2561 method_5476() {
        return displayName;
    }

    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ColoringStationScreenHandler(syncId, playerInventory, class_3914.method_17392(this.field_11863, this.field_11867), this.propertyDelegate);
    }

}
