package com.github.suninvr.virtualadditions.block.entity;

import com.github.suninvr.virtualadditions.block.SpotlightBlock;
import com.github.suninvr.virtualadditions.block.enums.LightStatus;
import com.github.suninvr.virtualadditions.registry.VABlockEntityType;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VAGameEventTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_6880;

public class SpotlightBlockEntity extends class_2586 implements class_5714.class_8513<SpotlightBlockEntity.Listener> {
    private class_2338 lightPos;
    private final Listener listener;
    private long lastUpdated;

    public SpotlightBlockEntity(class_2338 pos, class_2680 state) {
        super(VABlockEntityType.SPOTLIGHT, pos, state);
        this.lightPos = pos;
        this.listener = new Listener(pos);
        this.lastUpdated = -1;
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71468("light_pos", class_2338.field_25064, this.lightPos);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        view.method_71426("light_pos", class_2338.field_25064).ifPresent(pos -> this.lightPos = pos);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        SpotlightBlock.setLightState(this.field_11863, pos, oldState, LightStatus.NONE);
        super.method_66473(pos, oldState);
    }

    private boolean canUpdate(long time) {
        if (this.field_11863 == null) return false;
        boolean bl = (time != this.lastUpdated);
        if (bl) this.lastUpdated = time;
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        return bl && state.method_27852(VABlocks.SPOTLIGHT) && state.method_11654(SpotlightBlock.POWERED);
    }

    public class_2338 getLightLocation() {
        return this.lightPos;
    }

    public void setLightLocation(class_2338 pos) {
        this.lightPos = pos;
        this.method_5431();
    }

    @SuppressWarnings("ClassEscapesDefinedScope")
    @Override
    public Listener method_51358() {
        return this.listener;
    }

    protected class Listener implements class_5714 {
        private final class_5716 positionSource;

        public Listener(class_2338 pos) {
            this.positionSource = new class_5707(pos);
        }

        @Override
        public class_5716 method_32946() {
            return this.positionSource;
        }

        @Override
        public int method_32948() {
            return 16;
        }

        @Override
        public boolean method_32947(class_3218 world, class_6880<class_5712> event, class_5712.class_7397 emitter, class_243 emitterPos) {
            if (!event.method_40220(VAGameEventTags.NOTIFIES_SPOTLIGHT)) return false;
            if (!SpotlightBlockEntity.this.canUpdate(world.method_8510())) return false;
            class_243 pos = this.method_32946().method_32956(world).get();
            world.method_64310(class_2338.method_49638(pos), VABlocks.SPOTLIGHT, 1);
            return true;
        }
    }
}
