package com.github.suninvr.virtualadditions.block.entity;

import com.github.suninvr.virtualadditions.block.SpotlightLightBlock;
import com.github.suninvr.virtualadditions.registry.VABlockEntityType;
import com.github.suninvr.virtualadditions.registry.VAGameEventTags;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_6880;

@SuppressWarnings("ClassEscapesDefinedScope")
public class SpotlightLightBlockEntity extends class_2586 implements class_5714.class_8513<SpotlightLightBlockEntity.Listener> {
    private final Listener listener;
    private long lastUpdated;

    public SpotlightLightBlockEntity(class_2338 pos, class_2680 state) {
        super(VABlockEntityType.SPOTLIGHT_LIGHT, pos, state);
        this.listener = new SpotlightLightBlockEntity.Listener(pos);
        this.lastUpdated = -1;
    }

    private boolean canUpdate(long time) {
        boolean bl = (time != this.lastUpdated);
        if (bl) this.lastUpdated = time;
        return bl;
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        SpotlightLightBlock.updateSources(this.field_11863, pos, oldState);
        super.method_66473(pos, oldState);
    }

    @Override
    public Listener method_51358() {
        return this.listener;
    }

    protected class Listener implements class_5714 {
        private final class_5716 source;

        public Listener(class_2338 pos) {
            this.source = new class_5707(pos);
        }

        @Override
        public class_5716 method_32946() {
            return this.source;
        }

        @Override
        public int method_32948() {
            return 16;
        }

        @Override
        public boolean method_32947(class_3218 world, class_6880<class_5712> event, class_5712.class_7397 emitter, class_243 emitterPos) {
            if (!event.method_40220(VAGameEventTags.NOTIFIES_SPOTLIGHT)) return false;
            if (!SpotlightLightBlockEntity.this.canUpdate(world.method_8510())) return false;
            class_243 pos = this.method_32946().method_32956(world).get();
            class_2338 blockPos = class_2338.method_49638(pos);
            SpotlightLightBlock.updateSources(world, blockPos, world.method_8320(blockPos));
            return true;
        }
    }
}
