package com.github.suninvr.virtualadditions.client;

import com.github.suninvr.virtualadditions.client.particle.*;
import com.github.suninvr.virtualadditions.client.screen.ColoringStationScreen;
import com.github.suninvr.virtualadditions.client.screen.EntanglementDriveScreen;
import com.github.suninvr.virtualadditions.client.toast.RemoteNotifierToast;
import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.github.suninvr.virtualadditions.registry.VAPackets;
import com.github.suninvr.virtualadditions.registry.VAParticleTypes;
import com.github.suninvr.virtualadditions.registry.VAScreenHandler;
import com.github.suninvr.virtualadditions.screen.ColoringStationScreenHandler;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.class_10748;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3929;
import net.minecraft.class_687;
import net.minecraft.class_719;
import net.minecraft.class_8253;
import java.io.File;

public class VirtualAdditionsClient implements ClientModInitializer {

    @Override
    public void onInitializeClient() {
        VARenderLayers.init();
        VARenderers.init();

        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.ACID_SPLASH_EMITTER, AcidSplashEmitterParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.ACID_SPLASH, class_719.Factory::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.GREENCAP_SPORE, GreencapSporeParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.SCRAPE_STEEL, SteelScrapeFactory::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.SOULBLOOM_LEAVES, class_8253.class_10379::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.INTERFERENCE, PowerParticleFactory::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.SPECTRAL_POWER, PowerParticleFactory::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.COLORFUL_POWER, PowerParticleFactory.Color::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.SPECTRAL_FLAME, class_687.class_688::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.SMALL_SPECTRAL_FLAME, class_687.class_5613::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.SPRING_LOTUS_POLLEN, SpringLotusPollenParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.SOUL_FIREFLY, class_10748.class_10749::new);
        ParticleFactoryRegistry.getInstance().register(VAParticleTypes.STATIC_SCULK_CHARGE_POP, StaticSculkChargePopParticleFactory::new);

        class_3929.method_17542(VAScreenHandler.ENTANGLEMENT_DRIVE, EntanglementDriveScreen::new);
        class_3929.method_17542(VAScreenHandler.COLORING_STATION, ColoringStationScreen::new);

        ClientPlayNetworking.registerGlobalReceiver(VAPackets.REMOTE_NOTIFIER_S2C_ID, ((payload, context) -> {
            if (context != null) context.client().method_1566().method_1999(new RemoteNotifierToast(payload.STACK(), class_2561.method_30163(payload.TEXT())));
        }));

        ClientPlayNetworking.registerGlobalReceiver(VAPackets.COLORING_STATION_S2C_ID, (payload, context) -> {
            if (context != null) {
                if (context.client().field_1755 instanceof ColoringStationScreen coloringStationScreen) {
                    coloringStationScreen.method_17577().setRecipeData(payload.list());
                } else {
                    ColoringStationScreenHandler.recipeDataOnLoad = payload.list();
                }
            }
        });

        ClientPlayNetworking.registerGlobalReceiver(VAPackets.PLAYER_PROJECTION_S2C_ID, (payload, context) -> {
            class_1937 world = context.player().method_73183();
            if (world != null) {
                class_1297 entity = world.method_66347(payload.getEntityId());
                if (entity instanceof PlayerProjectionEntity playerProjectionEntity) {
                    if (payload.isRemoved()) {
                        playerProjectionEntity.method_5650(class_1297.class_5529.field_26999);
                        context.client().method_1504(context.client().field_1724);
                    } else {
                        playerProjectionEntity.setClientPlayer(context.client().field_1724);
                        context.client().method_1504(playerProjectionEntity);
                    }
                } else {
                    context.client().method_1504(context.client().field_1724);
                }
            }
        });
    }

}
