package com.github.suninvr.virtualadditions.client.render.entity;

import com.github.suninvr.virtualadditions.client.VARenderers;
import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import net.minecraft.class_11901;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5617;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings({"unchecked", "rawtypes"})
public class PlayerProjectionEntityRenderer<T extends PlayerProjectionEntity> extends class_922<PlayerProjectionEntity, PlayerProjectionEntityRenderState, PlayerProjectionEntityModel> {

    public PlayerProjectionEntityRenderer(class_5617.class_5618 context) {
        super(context, new PlayerProjectionEntityModel(context.method_32167(VARenderers.PLAYER_PROJECTION_LAYER)), 0.25F);
    }

    @Override
    public void updateRenderState(PlayerProjectionEntity livingEntity, PlayerProjectionEntityRenderState livingEntityRenderState, float f) {
        super.method_62355(livingEntity, livingEntityRenderState, f);
        livingEntityRenderState.field_53333 = true;
        livingEntityRenderState.field_53461 = false;
        if (livingEntity.getPlayer() instanceof class_11901 playerLike) {
            livingEntityRenderState.skinTextures = playerLike.method_52814();
            class_310 minecraftClient = class_310.method_1551();
            livingEntityRenderState.field_53461 = livingEntity.getPlayer().method_5767() && livingEntity.getPlayer().method_5756(minecraftClient.field_1724);
        }
    }

    @Override
    protected @Nullable class_2561 getDisplayName(PlayerProjectionEntity entity) {
        return super.method_62426(entity);
    }

    @Override
    protected boolean hasLabel(PlayerProjectionEntity entity, double d) {
        return super.method_4055(entity, d) && (entity.method_5733() || entity.method_16914() && entity == this.field_4676.field_4678);
    }

    @Override
    public class_2960 getTexture(PlayerProjectionEntityRenderState state) {
        return state.skinTextures.comp_1626().comp_3627();
    }

    @Override
    protected @Nullable class_1921 getRenderLayer(PlayerProjectionEntityRenderState state, boolean showBody, boolean translucent, boolean showOutline) {
        class_2960 identifier = this.getTexture(state);
        return class_1921.method_29379(identifier);
    }

    @Override
    protected int getBlockLight(PlayerProjectionEntity entity, class_2338 pos) {
        return 15;
    }

    @Override
    public PlayerProjectionEntityRenderState method_55269() {
        return new PlayerProjectionEntityRenderState();
    }
}
