package com.github.suninvr.virtualadditions.entity;

import com.github.suninvr.virtualadditions.registry.VAEntityType;
import com.github.suninvr.virtualadditions.registry.VAItems;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4153;
import net.minecraft.class_7477;
import net.minecraft.entity.*;
import java.util.Optional;

public class LightningBottleEntity extends class_3857 {
    public LightningBottleEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public LightningBottleEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(VAEntityType.LIGHTNING_BOTTLE, owner, world, stack);
    }

    public LightningBottleEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(VAEntityType.LIGHTNING_BOTTLE, x, y, z, world, stack);
    }

    @Override
    protected class_1792 method_16942() {
        return VAItems.LIGHTNING_BOTTLE;
    }

    protected double method_7490() {
        return 0.07;
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (this.method_73183() instanceof class_3218 serverWorld) {
            this.method_73183().method_20290(2002, this.method_24515(), 7860223);

            Optional<class_2338> lightningRodPos = serverWorld.method_19494()
                    .method_34712(
                            poiType -> poiType.method_40225(class_7477.field_39297),
                            blockPos -> blockPos.method_10264() == serverWorld.method_8624(class_2902.class_2903.field_13202, blockPos.method_10263(), blockPos.method_10260()) - 1,
                            class_2338.method_49638(hitResult.method_17784()), 12, class_4153.class_4155.field_18489
                    );
            if (lightningRodPos.isPresent()) {
                this.summonLightningBolt(class_243.method_24955(lightningRodPos.get().method_10084()));
            } else if (hitResult instanceof class_3965 blockHitResult) {
                class_2338 blockPos = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                this.summonLightningBolt(blockPos.method_46558().method_1031(0.0, -0.5, 0.0));
            } else if (hitResult instanceof class_3966 entityHitResult) {
                this.summonLightningBolt(entityHitResult.method_17782().method_73189());
            } else {
                this.summonLightningBolt(hitResult.method_17784());
            }
            this.method_31472();
        }

    }

    private void summonLightningBolt(class_243 pos) {
        class_1538 entity = new class_1538(class_1299.field_6112, this.method_73183());
        if (this.method_24921() instanceof class_3222 serverPlayerEntity) entity.method_6961(serverPlayerEntity);
        entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        this.method_73183().method_8649(entity);
    }
}
