package com.github.suninvr.virtualadditions.entity;

import com.github.suninvr.virtualadditions.interfaces.EntityInterface;
import com.github.suninvr.virtualadditions.registry.VADamageTypes;
import com.github.suninvr.virtualadditions.registry.VASoundEvents;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1344;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1395;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_8949;
import net.minecraft.class_9;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import net.minecraft.world.*;
import org.jetbrains.annotations.Nullable;

public class LumwaspEntity extends class_1588 implements class_1603, class_1432 {
    public LumwaspEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331(this, 20, true);
        this.method_5941(class_7.field_9, -1.0F);
        this.method_5941(class_7.field_18, -1.0F);
        this.method_5941(class_7.field_4, 16.0F);
        this.method_5941(class_7.field_21516, -1.0F);
        this.method_5941(class_7.field_10, -1.0F);
    }

    public static class_5132 createLumwaspAttributes() {
        return class_1308.method_26828()
                .method_26868(class_5134.field_23716, 16.0)
                .method_26868(class_5134.field_23720, 0.135)
                .method_26868(class_5134.field_23719, 0.1)
                .method_26868(class_5134.field_23721, 4.0)
                .method_26868(class_5134.field_23717, 16.0)
                .method_26866();
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        int i = 0;
        this.method_5783(class_3417.field_14789, 1.0F, 1.0F);
        double d = target.method_23320() - 1.100000023841858;
        double e = target.method_23317() - this.method_23317();
        double g = target.method_23321() - this.method_23321();
        double h = Math.sqrt(e * e + g * g) * 0.20000000298023224;
        while (i <= 2) {
            AcidSpitEntity projectile = new AcidSpitEntity(this.method_73183(), this);
            double f = d - projectile.method_23318();
            projectile.method_7485(e, f + h, g, 1.6F, 10.0F);
            this.method_73183().method_8649(projectile);
            i++;
        }
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, new AlwaysEscapeSunlightGoal(this, 1.2D));
        this.field_6201.method_6277(2, new MeleeCloseRangeGoal(this, 1.2D, 4, true));
        this.field_6201.method_6277(3, new class_1381(this, 1.1D, 45, 8));
        this.field_6201.method_6277(5, new class_1395(this, 1.0D));
        this.field_6201.method_6277(6, new class_1361(this, class_1657.class, 8.0F));
        this.field_6201.method_6277(6, new class_1376(this));
        this.field_6185.method_6277(1, new class_1399(this, LumwaspEntity.class, class_8949.class).method_6318());
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));
        this.field_6185.method_6277(3, new class_1400<>(this, class_1439.class, true));
        this.field_6185.method_6277(3, new class_1400<>(this, class_4466.class, true));
    }

    @Override
    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407(this, world) {
            public boolean method_6333(class_2338 pos) {
                return this.field_6677.method_8311(pos);
            }

            protected void method_6359() {
                super.method_6359();
                if (this.field_6677.method_8311(class_2338.method_49637(this.field_6684.method_23317(), this.field_6684.method_23318() + 0.5, this.field_6684.method_23321()))) {
                    return;
                }
                if (this.field_6681 != null) {
                    for (int i = 0; i < this.field_6681.method_38(); ++i) {
                        class_9 pathNode = this.field_6681.method_40(i);
                        if (this.field_6677.method_8311(new class_2338(pathNode.field_40, pathNode.field_39, pathNode.field_38))) {
                            this.field_6681.method_36(i);
                            return;
                        }
                    }
                }
            }
        };
        birdNavigation.method_70687(false);
        birdNavigation.method_6354(false);
        return birdNavigation;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return VASoundEvents.ENTITY_LUMWASP_HURT;
    }

    @Override
    protected class_3414 method_6002() {
        return VASoundEvents.ENTITY_LUMWASP_DEATH;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14760, 0.15F, 1.0F);
    }

    @Override
    public boolean method_5747(double fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Override
    public boolean method_5679(class_3218 world, class_1282 source) {
        return source.method_48789(VADamageTypes.ACID_TAG) || super.method_5679(world, source);
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    @Override
    protected boolean method_5776() {
        return this.method_6581();
    }

    @Override
    public boolean method_6581() {
        return !this.method_24828();
    }

    @Override
    public boolean method_5957(class_4538 world) {
        return super.method_5957(world);
    }

    public static boolean method_20680(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && (class_3730.method_54987(spawnReason) || LumwaspEntity.method_20679(world, pos, random)) && class_1588.method_20636(type, world, spawnReason, pos, random);
    }

    public static boolean method_20679(class_5425 world, class_2338 pos, class_5819 random) {
        if (world.method_8314(class_1944.field_9284, pos) > random.method_43048(32)) {
            return false;
        }
        if (world.method_8314(class_1944.field_9282, pos) > 7) {
            return false;
        }
        class_2874 dimensionType = world.method_8597();
        int j = world.method_8410().method_8546() ? world.method_22346(pos, 10) : world.method_22339(pos);
        return j <= dimensionType.method_44222().method_35008(random);
    }

    @Override
    protected void method_5958(class_3218 world) {
        if (this.method_5869() && !((EntityInterface)this).virtualAdditions$isInAcid() ) {
            this.method_64397(world, this.method_48923().method_48824(), 1.0F);
        }
    }

    @Override
    public boolean method_6121(class_3218 world, class_1297 target) {
        boolean bl = super.method_6121(world, target);
        if (bl && world.method_8407().compareTo(class_1267.field_5805) > 0 && target instanceof class_1309 livingEntity) {
            if (!this.method_6026().isEmpty()) {
                for (class_1293 statusEffect : this.method_6026()) {
                    livingEntity.method_37222(statusEffect, this);
                }
            } else {
                int duration = 100;
                duration += (this.method_73183().method_8407().method_5461() - 1) * 50;
                livingEntity.method_37222(new class_1293(class_1294.field_5911, duration), this);
            }

        }
        return bl;
    }


    @Override
    public void method_6091(class_243 movementInput) {
        if (this.method_24828()) {
            super.method_6091(movementInput);
            return;
        }
        this.method_70670(movementInput, this.method_6029());
    }

    private static class MeleeCloseRangeGoal extends class_1366 {
        private final int startRange;
        private final int continueRange;
        public MeleeCloseRangeGoal(class_1314 mob, double speed, int range, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.startRange = range * range;
            this.continueRange = (2 + range) * (2 + range);
        }

        @Override
        public boolean method_6264() {
            return checkDistance(this.startRange) && super.method_6264();
        }

        @Override
        public boolean method_6266() {
            return checkDistance(this.continueRange) && super.method_6266();
        }

        private boolean checkDistance(int range) {
            boolean bl = false;
            class_1309 target = this.field_6503.method_5968();
            if (target != null) {
                bl = (this.field_6503.method_5858(target) <= range);
            }
            return bl;
        }
    }
    private static class AlwaysEscapeSunlightGoal extends class_1344 {

        private final class_1937 world;

        public AlwaysEscapeSunlightGoal(class_1314 mob, double speed) {
            super(mob, speed);
            this.world = mob.method_73183();
        }

        @Override
        public boolean method_6264() {
            if (this.field_6419.method_5968() != null) {
                return false;
            } else if (!this.world.method_8530()) {
                return false;
            } else if (!this.world.method_8311(this.field_6419.method_24515())) {
                return false;
            } else {
                return this.method_18250();
            }
        }
    }
}
